// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_CALENDAR_H
#define _GTKMM_CALENDAR_H


#include <glibmm.h>

/* $Id: calendar.hg,v 1.4.6.2 2006/02/25 12:35:28 murrayc Exp $ */

/* calendar.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkCalendar GtkCalendar;
typedef struct _GtkCalendarClass GtkCalendarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Calendar_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%CalendarDisplayOptions operator|(CalendarDisplayOptions, CalendarDisplayOptions)</tt><br>
 * <tt>%CalendarDisplayOptions operator&(CalendarDisplayOptions, CalendarDisplayOptions)</tt><br>
 * <tt>%CalendarDisplayOptions operator^(CalendarDisplayOptions, CalendarDisplayOptions)</tt><br>
 * <tt>%CalendarDisplayOptions operator~(CalendarDisplayOptions)</tt><br>
 * <tt>%CalendarDisplayOptions& operator|=(CalendarDisplayOptions&, CalendarDisplayOptions)</tt><br>
 * <tt>%CalendarDisplayOptions& operator&=(CalendarDisplayOptions&, CalendarDisplayOptions)</tt><br>
 * <tt>%CalendarDisplayOptions& operator^=(CalendarDisplayOptions&, CalendarDisplayOptions)</tt><br>
 */
enum CalendarDisplayOptions
{
  CALENDAR_SHOW_HEADING = 1 << 0,
  CALENDAR_SHOW_DAY_NAMES = 1 << 1,
  CALENDAR_NO_MONTH_CHANGE = 1 << 2,
  CALENDAR_SHOW_WEEK_NUMBERS = 1 << 3,
  CALENDAR_WEEK_START_MONDAY = 1 << 4
};

/** @ingroup gtkmmEnums */
inline CalendarDisplayOptions operator|(CalendarDisplayOptions lhs, CalendarDisplayOptions rhs)
  { return static_cast<CalendarDisplayOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline CalendarDisplayOptions operator&(CalendarDisplayOptions lhs, CalendarDisplayOptions rhs)
  { return static_cast<CalendarDisplayOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline CalendarDisplayOptions operator^(CalendarDisplayOptions lhs, CalendarDisplayOptions rhs)
  { return static_cast<CalendarDisplayOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline CalendarDisplayOptions operator~(CalendarDisplayOptions flags)
  { return static_cast<CalendarDisplayOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline CalendarDisplayOptions& operator|=(CalendarDisplayOptions& lhs, CalendarDisplayOptions rhs)
  { return (lhs = static_cast<CalendarDisplayOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline CalendarDisplayOptions& operator&=(CalendarDisplayOptions& lhs, CalendarDisplayOptions rhs)
  { return (lhs = static_cast<CalendarDisplayOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline CalendarDisplayOptions& operator^=(CalendarDisplayOptions& lhs, CalendarDisplayOptions rhs)
  { return (lhs = static_cast<CalendarDisplayOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::CalendarDisplayOptions> : public Glib::Value_Flags<Gtk::CalendarDisplayOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** Display a calendar and/or allow the user to select a date.
 *
 * This is a widget that displays a calendar, one month at a time.
 *
 * The month and year currently displayed can be altered with
 * select_month().  The exact day can be selected from the displayed month
 * using select_day().
 *
 * The way in which the calendar itself is displayed can be altered using
 * set_display_options().
 *
 * The selected date can be retrieved from a GtkCalendar using get_date().
 *
 * If performing many 'mark' operations, the calendar can be frozen to
 * prevent flicker, using freeze(), and 'thawed' again using thaw().
 *
 * @ingroup Widgets
 */

class Calendar : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Calendar CppObjectType;
  typedef Calendar_Class CppClassType;
  typedef GtkCalendar BaseObjectType;
  typedef GtkCalendarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Calendar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Calendar_Class;
  static CppClassType calendar_class_;

  // noncopyable
  Calendar(const Calendar&);
  Calendar& operator=(const Calendar&);

protected:
  explicit Calendar(const Glib::ConstructParams& construct_params);
  explicit Calendar(GtkCalendar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkCalendar*       gobj()       { return reinterpret_cast<GtkCalendar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkCalendar* gobj() const { return reinterpret_cast<GtkCalendar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
  virtual void on_month_changed();
  virtual void on_day_selected();
  virtual void on_day_selected_double_click();
  virtual void on_prev_month();
  virtual void on_next_month();
  virtual void on_prev_year();
  virtual void on_next_year();


private:

public:
  Calendar();
  
  
  /** Shifts the calendar to a different month.
   * @param month A month number between 0 and 11.
   * @param year The year the month is in.
   * @return <tt>true</tt>, always.
   */
  int select_month(guint month, guint year);
  
  /** Selects a day from the current month.
   * @param day The day number between 1 and 31, or 0 to unselect 
   * the currently selected day.
   */
  void select_day(guint day);
  
  /** Places a visual marker on a particular day.
   * @param day The day number to mark between 1 and 31.
   * @return <tt>true</tt>, always.
   */
  int mark_day(guint day);
  
  /** Removes the visual marker from a particular day.
   * @param day The day number to unmark between 1 and 31.
   * @return <tt>true</tt>, always.
   */
  int unmark_day(guint day);
  
  /** Remove all visual markers.
   */
  void clear_marks();

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets display options (whether to display the heading and the month headings).
   * 
   * Deprecated: Use set_display_options() instead
   * @param flags The display options to set.
   */
  void display_options(CalendarDisplayOptions flags);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets display options (whether to display the heading and the month  
   * headings).
   * 
   * @newin2p4
   * @param flags The display options to set.
   */
  void set_display_options(CalendarDisplayOptions flags);
  
  /** Returns the current display options of @a calendar .
   * @return The display options.
   * 
   * @newin2p4.
   */
  CalendarDisplayOptions get_display_options() const;

  
  /** Obtains the selected date from a Gtk::Calendar.
   * @param year Location to store the year number, or <tt>0</tt>.
   * @param month Location to store the month number (between 0 and 11), or <tt>0</tt>.
   * @param day Location to store the day number (between 1 and 31), or <tt>0</tt>.
   */
  void get_date(guint& year, guint& month, guint& day) const;
  
  /** Does nothing. Previously locked the display of the calendar until
   * it was thawed with thaw().
   */
  void freeze();
  
  /** Does nothing. Previously defrosted a calendar; all the changes made
   * since the last freeze() were displayed.
   */
  void thaw();

  
  Glib::SignalProxy0< void > signal_month_changed();

  
  Glib::SignalProxy0< void > signal_day_selected();

  
  Glib::SignalProxy0< void > signal_day_selected_double_click();

  
  Glib::SignalProxy0< void > signal_prev_month();

  
  Glib::SignalProxy0< void > signal_next_month();

  
  Glib::SignalProxy0< void > signal_prev_year();

  
  Glib::SignalProxy0< void > signal_next_year();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Calendar
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Calendar* wrap(GtkCalendar* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_CALENDAR_H */

