// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEMODEL_H
#define _GTKMM_TREEMODEL_H

#include <glibmm.h>

/* $Id: treemodel.hg,v 1.6 2003/12/09 06:42:51 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktreemodel.h>
#include <glibmm/interface.h>
#include <gtkmm/treeiter.h>
#include <gtkmm/treemodelcolumn.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeModel GtkTreeModel;
typedef struct _GtkTreeModelClass GtkTreeModelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeModel_Class; } // namespace Gtk
namespace Gtk
{

class TreeModelSort;
class TreePath;
class TreeRowReference;


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%TreeModelFlags operator|(TreeModelFlags, TreeModelFlags)</tt><br>
 * <tt>%TreeModelFlags operator&(TreeModelFlags, TreeModelFlags)</tt><br>
 * <tt>%TreeModelFlags operator^(TreeModelFlags, TreeModelFlags)</tt><br>
 * <tt>%TreeModelFlags operator~(TreeModelFlags)</tt><br>
 * <tt>%TreeModelFlags& operator|=(TreeModelFlags&, TreeModelFlags)</tt><br>
 * <tt>%TreeModelFlags& operator&=(TreeModelFlags&, TreeModelFlags)</tt><br>
 * <tt>%TreeModelFlags& operator^=(TreeModelFlags&, TreeModelFlags)</tt><br>
 */
enum TreeModelFlags
{
  TREE_MODEL_ITERS_PERSIST = 1 << 0,
  TREE_MODEL_LIST_ONLY = 1 << 1
};

/** @ingroup gtkmmEnums */
inline TreeModelFlags operator|(TreeModelFlags lhs, TreeModelFlags rhs)
  { return static_cast<TreeModelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TreeModelFlags operator&(TreeModelFlags lhs, TreeModelFlags rhs)
  { return static_cast<TreeModelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TreeModelFlags operator^(TreeModelFlags lhs, TreeModelFlags rhs)
  { return static_cast<TreeModelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TreeModelFlags operator~(TreeModelFlags flags)
  { return static_cast<TreeModelFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline TreeModelFlags& operator|=(TreeModelFlags& lhs, TreeModelFlags rhs)
  { return (lhs = static_cast<TreeModelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline TreeModelFlags& operator&=(TreeModelFlags& lhs, TreeModelFlags rhs)
  { return (lhs = static_cast<TreeModelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline TreeModelFlags& operator^=(TreeModelFlags& lhs, TreeModelFlags rhs)
  { return (lhs = static_cast<TreeModelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeModelFlags> : public Glib::Value_Flags<Gtk::TreeModelFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** This class defines a generic tree interface for use by the Gtk::TreeView widget.
 * @ingroup TreeView
 * It is is designed to be usable with any appropriate data structure. The
 * programmer just has to implement this interface on their own data type for
 * it to be viewable by a Gtk::TreeView widget.
 *
 * The model is represented as a hierarchical tree of strongly-typed, columned
 * data. In other words, the model can be seen as a tree where every node has
 * different values depending on which column is being queried.  The type of
 * data found in a column is determined by TreeModel::Column<> templates.
 * The types are
 * homogeneous per column across all nodes. It is important to note that this
 * interface only provides a way of examining a model and observing changes.
 * The implementation of each individual model decides how and if changes are
 * made.
 *
 * In order to make life simpler for programmers who do not need to write their
 * own specialized model, two generic models are provided - the Gtk::TreeStore
 * and the Gtk::ListStore. To use these, the developer simply pushes data into
 * these models as necessary. These models provide the data structure as well
 * as all appropriate tree interfaces. As a result, implementing drag and drop,
 * sorting, and storing data is trivial. For the vast majority of trees and
 * lists, these two models are sufficient.
 *
 * Models are accessed on a node/column level of granularity. One can query for
 * the value of a model at a certain node and a certain column on that node.
 * There are two structures used to reference a particular node in a model.
 * They are the Path and the iterator. Most of the interface consists of
 * operations on a iterator.
 *
 * A path is essentially a potential node. It is a location on a model that may
 * or may not actually correspond to a node on a specific model. A Path can be
 * converted into either an array of unsigned integers or a string. The string
 * form is a list of numbers separated by a colon. Each number refers to the
 * offset at that level. Thus, the path "0" refers to the root node and the
 * path "2:4" refers to the fifth child of the third node.
 *
 * By contrast, a iterator is a reference to a specific node on a specific
 * model. It is a generic structure with an integer and three generic pointers.
 * These are filled in by the model in a model-specific way. One can convert a
 * path to an iterator by calling Gtk::TreeModel::get_iter(). These iterators
 * are the primary way of accessing a model and are similar to the iterators
 * used by Gtk::TextBuffer. The model interface defines a set of operations
 * using them for navigating the model.
 *
 * The lifecycle of an iterator can be a little confusing at first. Iterators
 * are expected to always be valid for as long as the model is unchanged (and
 * doesn't emit a signal). The model is considered to own all outstanding
 * iterators and nothing needs to be done to free them from the user's point of
 * view. Additionally, some models guarantee that an iterator is valid for as
 * long as the node it refers to is valid (most notably the Gtk::TreeStore and
 * Gtk::ListStore). Although generally uninteresting, as one always has to
 * allow for the case where iterators do not persist beyond a signal, some very
 * important performance enhancements were made in the sort model. As a result,
 * the GTK_TREE_MODEL_ITERS_PERSIST flag was added to indicate this behavior.
 */

class TreeModel : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TreeModel CppObjectType;
  typedef TreeModel_Class CppClassType;
  typedef GtkTreeModel BaseObjectType;
  typedef GtkTreeModelIface BaseClassType;

private:
  friend class TreeModel_Class;
  static CppClassType treemodel_class_;

  // noncopyable
  TreeModel(const TreeModel&);
  TreeModel& operator=(const TreeModel&);

protected:
  TreeModel(); // you must derive from this class
  explicit TreeModel(GtkTreeModel* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TreeModel();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTreeModel*       gobj()       { return reinterpret_cast<GtkTreeModel*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GtkTreeModel* gobj() const { return reinterpret_cast<GtkTreeModel*>(gobject_); }

private:

  
public:
  typedef TreeModelColumnRecord ColumnRecord;
  typedef TreeIter iterator;
  typedef const TreeIter const_iterator;
  typedef TreeRow Row;
  typedef TreePath Path;
  typedef TreeRowReference RowReference;
  typedef TreeNodeChildren Children;

  //These are part of GtkTreeModelFilter or GtkTreeModelSort, not GtkTreeModel:
  

  iterator get_iter(const Path& path);
  //TODO: Implement a const_iterator? const_iterator get_iter(const Path& path) const;
  iterator get_iter(const Glib::ustring& path_string);
  //TODO: Implement a const_iterator? const_iterator get_iter(const Glib::ustring& path_string) const;

  ///This returns an STL-like container API, for iterating over the rows.
  Children children();

  //TODO: Should this return a reference? The const here is meaningless. murrayc.
  ///This returns an STL-like container API, for iterating over the rows.
  const Children children() const;

  
  typedef SigC::Slot1<bool, const TreeModel::iterator&> SlotForeachIter;
  void foreach(const SlotForeachIter& slot);

  typedef SigC::Slot1<bool, const TreeModel::Path&> SlotForeachPath;
  void foreach(const SlotForeachPath& slot);

  typedef SigC::Slot2<bool, const TreeModel::Path&, const TreeModel::iterator&> SlotForeachPathAndIter;
  void foreach(const SlotForeachPathAndIter& slot);

  
  TreeModelFlags get_flags() const;
  
  int get_n_columns() const;
  
  GType get_column_type(int index) const;
  
  TreeModel::Path get_path(const iterator& iter) const;

  
  void row_changed(const Path& path, const iterator& iter);
  
  void row_inserted(const Path& path, const iterator& iter);
  
  void row_has_child_toggled(const Path& path, const iterator& iter);
  
  void row_deleted(const Path& path);
  
  void rows_reordered(const Path& path, const iterator& iter, int* new_order);

  
  Glib::ustring get_string(const iterator& iter) const;

 
  /**
   * @par Prototype:
   * <tt>void %row_changed(const TreeModel::Path& path, const TreeModel::iterator& iter)</tt>
   */
  Glib::SignalProxy2< void,const TreeModel::Path&,const TreeModel::iterator& > signal_row_changed();

  //TODO: re-enable when gtk+ bug 123923 has been dealt with: 
  //_WRAP_SIGNAL(void row_inserted(const TreeModel::Path& path, const TreeModel::iterator& iter), "row_inserted")
  
  /**
   * @par Prototype:
   * <tt>void %row_has_child_toggled(const TreeModel::Path& path, const TreeModel::iterator& iter)</tt>
   */
  Glib::SignalProxy2< void,const TreeModel::Path&,const TreeModel::iterator& > signal_row_has_child_toggled();

  
  /**
   * @par Prototype:
   * <tt>void %row_deleted(const TreeModel::Path& path)</tt>
   */
  Glib::SignalProxy1< void,const TreeModel::Path& > signal_row_deleted();

  
  /**
   * @par Prototype:
   * <tt>void %rows_reordered(const TreeModel::Path& path, const TreeModel::iterator& iter, int* new_order)</tt>
   */
  Glib::SignalProxy3< void,const TreeModel::Path&,const TreeModel::iterator&,int* > signal_rows_reordered();


protected:
  
  
  //These are only for deriving new TreeModels, which isn't very common or easy:
  
  
  //Called by iterator::operator bool(), which is a friend class:
  virtual bool iter_is_valid(const iterator& iter) const;

  //Called by TreeRow, which is a friend class:
  virtual void set_value_impl(const iterator& row, int column, const Glib::ValueBase& value);
  virtual void get_value_impl(const iterator& row, int column, Glib::ValueBase& value) const;

  friend class Gtk::TreeModelSort;
  friend class Gtk::TreeRow;
  friend class Gtk::TreeIter;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual TreeModelFlags get_flags_vfunc();
  virtual int get_n_columns_vfunc();
  virtual GType get_column_type_vfunc(int index);
  virtual bool iter_next_vfunc(GtkTreeIter* iter);
  virtual bool iter_children_vfunc(GtkTreeIter* iter, const GtkTreeIter* parent);
  virtual bool iter_has_child_vfunc(const GtkTreeIter* iter);
  virtual int iter_n_children_vfunc(const GtkTreeIter* iter);
  virtual bool iter_nth_child_vfunc(GtkTreeIter* iter, const GtkTreeIter* parent, int n);
  virtual bool iter_parent_vfunc(GtkTreeIter* iter, const GtkTreeIter* child);
  virtual void ref_node_vfunc(GtkTreeIter* iter);
  virtual void unref_node_vfunc(GtkTreeIter* iter);
  virtual TreeModel::Path get_path_vfunc(const TreeModel::iterator& iter);
  virtual bool get_iter_vfunc(GtkTreeIter* iter, const TreeModel::Path& path);
  virtual void get_value_vfunc(const TreeModel::iterator& iter, int column, GValue* value);

  //Default Signal Handlers::
  virtual void on_row_changed(const TreeModel::Path& path, const TreeModel::iterator& iter);
  virtual void on_row_has_child_toggled(const TreeModel::Path& path, const TreeModel::iterator& iter);
  virtual void on_row_deleted(const TreeModel::Path& path);
  virtual void on_rows_reordered(const TreeModel::Path& path, const TreeModel::iterator& iter, int* new_order);


};

} // namespace Gtk


namespace Glib
{

/** @relates Gtk::TreeModel */
Glib::RefPtr<Gtk::TreeModel> wrap(GtkTreeModel* object, bool take_copy = false);

} // namespace Glib

#endif /* _GTKMM_TREEMODEL_H */

