// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_DIALOG_H
#define _GTKMM_DIALOG_H

#include <glibmm.h>

/* $Id: dialog.hg,v 1.2 2003/01/22 23:04:19 murrayc Exp $ */

/* dialog.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/window.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkDialog GtkDialog;
typedef struct _GtkDialogClass GtkDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Dialog_Class; } // namespace Gtk
namespace Gtk
{

/** @defgroup Dialogs Dialogs
 */


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum ResponseType
{
  RESPONSE_NONE = -1,
  RESPONSE_REJECT = -2,
  RESPONSE_ACCEPT = -3,
  RESPONSE_DELETE_EVENT = -4,
  RESPONSE_OK = -5,
  RESPONSE_CANCEL = -6,
  RESPONSE_CLOSE = -7,
  RESPONSE_YES = -8,
  RESPONSE_NO = -9,
  RESPONSE_APPLY = -10,
  RESPONSE_HELP = -11
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ResponseType> : public Glib::Value_Enum<Gtk::ResponseType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** Create popup windows.
 *
 * Dialog boxes are a convenient way to prompt the user for a small amount
 * of input, eg. to display a message, ask a question, or anything else that
 * does not require extensive effort on the user's part. 
 *
 * gtkmm treats a dialog as a window split vertically. The top section is a
 * Gtk::VBox, and is where widgets such as a Gtk::Label or a Gtk::Entry should be
 * packed. The bottom area is known as the action_area. This is generally
 * used for packing buttons into the dialog which may perform functions such
 * as cancel, ok, or apply. The two areas are separated by a Gtk::HSeparator. 
 *
 * The dialog can be 'modal' (that is, one which freezes the rest of the
 * application from user input) - this can be specified in the Gtk::Dialog
 * constructor.
 *
 * When adding buttons using add_button(), clicking the button will emit
 * signal_response() with a "response id" you specified. You are encouraged
 * to use the Gtk::ResponseType enum. If a dialog receives a delete event,
 * the "response" signal will be emitted with a response id of
 * Gtk::RESPONSE_NONE.
 *
 * If you want to block waiting for a dialog to return before returning control
 * flow to your code, you can call run(). This function enters a
 * recursive main loop and waits for the user to respond to the dialog, returning
 * the response ID corresponding to the button the user clicked. 
 *
 * @ingroup Dialogs
 */

class Dialog : public Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Dialog CppObjectType;
  typedef Dialog_Class CppClassType;
  typedef GtkDialog BaseObjectType;
  typedef GtkDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Dialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Dialog_Class;
  static CppClassType dialog_class_;

  // noncopyable
  Dialog(const Dialog&);
  Dialog& operator=(const Dialog&);

protected:
  explicit Dialog(const Glib::ConstructParams& construct_params);
  explicit Dialog(GtkDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkDialog*       gobj()       { return reinterpret_cast<GtkDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkDialog* gobj() const { return reinterpret_cast<GtkDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_response(int response_id);


private:

  
public:
  Dialog();
  explicit Dialog(const Glib::ustring& title, bool modal = false, bool use_separator = false);
  Dialog(const Glib::ustring& title, Gtk::Window& parent, bool modal = false, bool use_separator = false);

  
  void add_action_widget(Widget& child, int response_id);
  
  Button* add_button(const Glib::ustring& button_text, int response_id);
  
  Button* add_button(const Gtk::StockID& stock_id, int response_id);
  
  void set_response_sensitive(int response_id, bool setting = true);
  
  void set_default_response(int response_id);
  
  void set_has_separator(bool setting = true);
  
  bool get_has_separator() const;
  
  void response(int response_id);
  
  int run();

  VBox* get_vbox();
  const VBox* get_vbox() const;
  HButtonBox* get_action_area();
  const HButtonBox* get_action_area() const;

  Glib::PropertyProxy<bool> property_has_separator();


  /**
   * @par Prototype:
   * <tt>void %response(int response_id)</tt>
   */
  Glib::SignalProxy1<void,int> signal_response();

  //_WRAP_SIGNAL(void response(int response_id), "response", custom_default_handler)


protected:
  void construct_(bool modal, bool use_separator);


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Dialog */
  Gtk::Dialog* wrap(GtkDialog* object, bool take_copy = false);
}
#endif /* _GTKMM_DIALOG_H */

