// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ACCELGROUP_H
#define _GTKMM_ACCELGROUP_H

#include <glibmm.h>

/* $Id: accelgroup.hg,v 1.2 2003/03/03 07:49:04 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gdkmm/types.h>
#include <gtkmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkAccelGroup GtkAccelGroup;
typedef struct _GtkAccelGroupClass GtkAccelGroupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class AccelGroup_Class; } // namespace Gtk
namespace Gtk
{

/** A Gtk::AccelGroup represents a group of keyboard accelerators, typically
 * attached to a toplevel Gtk::Window (with Gtk::Window::add_accel_group()).
 * Usually you won't need to create a Gtk::AccelGroup directly; instead, gtkmm
 * automatically sets up the accelerators for your menus.  Note that
 * accelerators are different from mnemonics.  Accelerators are shortcuts for
 * activating a menu item; they appear alongside the menu item for which
 * they're a shortcut. For example "Ctrl+Q" might appear alongside the "Quit"
 * menu item.  Mnemonics are shortcuts for GUI elements such as text entries or
 * buttons; they appear as underlined characters. See the Gtk::Label
 * constructor. Menu items can have both accelerators and mnemonics, of course.
 *
 * You can use Gtk::Window::get_accel_group() to get an accel group for that window,
 * then use it with other widgets too.
 */

class AccelGroup : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef AccelGroup CppObjectType;
  typedef AccelGroup_Class CppClassType;
  typedef GtkAccelGroup BaseObjectType;
  typedef GtkAccelGroupClass BaseClassType;

private:
  friend class AccelGroup_Class;
  static CppClassType accelgroup_class_;

  // noncopyable
  AccelGroup(const AccelGroup&);
  AccelGroup& operator=(const AccelGroup&);

protected:
  explicit AccelGroup(const Glib::ConstructParams& construct_params);
  explicit AccelGroup(GtkAccelGroup* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~AccelGroup();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkAccelGroup*       gobj()       { return reinterpret_cast<GtkAccelGroup*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkAccelGroup* gobj() const { return reinterpret_cast<GtkAccelGroup*>(gobject_); }

  GtkAccelGroup* gobj_copy();

private:

   
protected:
  AccelGroup();

public:
  /** Creates a new Gtk::AccelGroup object.
   * @return A Glib::RefPtr<> to a newly created Gtk::AccelGroup object.
   */
  
  static Glib::RefPtr<AccelGroup> create();


  void lock();
  
  void unlock();
  
  bool disconnect_key(guint accel_key, Gdk::ModifierType accel_mods);

  /** Determines whether a given keyval and modifier mask constitute
  * a valid keyboard accelerator. For example, the 'a' keyval
  * plus Gdk::CONTROL_MASK is valid - this is a "Ctrl+a" accelerator.
  * But you can't, for instance, use the GDK_Control_L keyval
  * as an accelerator.
  */
  static bool valid(guint keyval, Gdk::ModifierType modifiers);

   /** Parse the accelerator string.
   * @param accelerator See the Gtk::AccelKey constructor for the format.
   * @param accelerator_key Output argument
   * @param accelerator_mods Output argument
   */
  static void parse(const Glib::ustring& accelerator, guint& accelerator_key, Gdk::ModifierType& accelerator_mods);

  /** Converts an accelerator keyval and modifier mask
   * into a string parseable by parse().
   * For example, if you pass in 'q' and Gdk::CONTROL_MASK, it returns "&lt;Control&gt;q".
   */
  static Glib::ustring name(guint accelerator_key, Gdk::ModifierType accelerator_mods);

  /** Sets the modifiers that will be considered significant for keyboard
   * accelerators. The default mod mask is Gdk::CONTROL_MASK |
   * Gdk::SHIFT_MASK | Gdk::MOD1_MASK, that is, Control, Shift, and Alt.
   * Other modifiers will ignored by default.
   * You must include at least the three default modifiers in any
   * value you pass to this function.
   *
   * The default mod mask should be changed on application startup,
   * before using any accelerator groups.
   */
  static void set_default_mod_mask(Gdk::ModifierType default_mod_mask);

  /// See set_default_mod_mask().
  static Gdk::ModifierType get_default_mod_mask();

  
  static bool activate(Gtk::Object& object, guint accel_key, Gdk::ModifierType accel_mods);

  //gtkmmproc error: accel_changed :  signal defs lookup failed


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::AccelGroup */
  Glib::RefPtr<Gtk::AccelGroup> wrap(GtkAccelGroup* object, bool take_copy = false);
}


#endif /* _GTKMM_ACCELGROUP_H */

