// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_BUTTON_H
#define _GTKMM_BUTTON_H

#include <glibmm.h>

/* $Id: button.hg,v 1.2 2003/10/12 09:38:11 murrayc Exp $ */

/* box.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>
#include <gtkmm/stockid.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkButton GtkButton;
typedef struct _GtkButtonClass GtkButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Button_Class; } // namespace Gtk
namespace Gtk
{

namespace Stock { struct BuiltinStockID; }


/** A widget that creates a signal when clicked on.
 *
 * This widget is generally used with a signal handler that is called when the button is pressed.
 * It can hold any valid child widget.  The most commonly used child is the Gtk::Label.
 *
 * @ingroup Widgets
 */

class Button : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Button CppObjectType;
  typedef Button_Class CppClassType;
  typedef GtkButton BaseObjectType;
  typedef GtkButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Button();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Button_Class;
  static CppClassType button_class_;

  // noncopyable
  Button(const Button&);
  Button& operator=(const Button&);

protected:
  explicit Button(const Glib::ConstructParams& construct_params);
  explicit Button(GtkButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkButton*       gobj()       { return reinterpret_cast<GtkButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkButton* gobj() const { return reinterpret_cast<GtkButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_pressed();
  virtual void on_released();
  virtual void on_clicked();
  virtual void on_enter();
  virtual void on_leave();
  virtual void on_activate();


private:

public:

  /** Create an empty button.
   * With an empty button, you can Gtk::Button::add() a widget
   * such as a Gtk::Pixmap or Gtk::Box.
   *
   * If you just wish to add a Gtk::Label,
   * you may want to
   * use the Gtk::Button(const Glib::ustring& label) ctor
   * directly instead.
   */
  Button();
  

  /** Simple Push Button with label.
   * Create a button with the given label inside. You won't be able
   * to add a widget in this button since it already has a Gtk::Label
   * in it
   */
  explicit Button(const Glib::ustring& label, bool mnemonic = false);
  explicit Button(const StockID& stock_id);


  void pressed();
  
  void released();
  
  void clicked();
  
  void enter();
  
  void leave();

  
  void set_relief(ReliefStyle newstyle);
  
  ReliefStyle get_relief() const;


  void set_label(const Glib::ustring& label);
  
  Glib::ustring get_label() const;
  
  void set_use_underline(bool use_underline = true);
  
  bool get_use_underline() const;
  
  void set_use_stock(bool use_stock = true);
  
  bool get_use_stock() const;

  
  void set_focus_on_click(bool focus_on_click = true);
  
  bool get_focus_on_click() const;

  
  /**
   * @par Prototype:
   * <tt>void %pressed()</tt>
   */
  Glib::SignalProxy0<void> signal_pressed();

  
  /**
   * @par Prototype:
   * <tt>void %released()</tt>
   */
  Glib::SignalProxy0<void> signal_released();

  
  /**
   * @par Prototype:
   * <tt>void %clicked()</tt>
   */
  Glib::SignalProxy0<void> signal_clicked();

  
  /**
   * @par Prototype:
   * <tt>void %enter()</tt>
   */
  Glib::SignalProxy0<void> signal_enter();

  
  /**
   * @par Prototype:
   * <tt>void %leave()</tt>
   */
  Glib::SignalProxy0<void> signal_leave();

  
  /**
   * @par Prototype:
   * <tt>void %activate()</tt>
   */
  Glib::SignalProxy0<void> signal_activate();


  Glib::PropertyProxy<Glib::ustring> property_label();

  Glib::PropertyProxy<ReliefStyle> property_relief();

  Glib::PropertyProxy<bool> property_use_underline();

  Glib::PropertyProxy<bool> property_use_stock();

  Glib::PropertyProxy<bool> property_focus_on_click();


};

/*! A Gtk::Button example.
 * @example book/buttons/button/buttons.h
 * @example book/buttons/button/buttons.cc
 * @example book/buttons/button/main.cc
 */

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Button */
  Gtk::Button* wrap(GtkButton* object, bool take_copy = false);
}
#endif /* _GTKMM_BUTTON_H */

