// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gdkmm/region.h>
#include <gdkmm/private/region_p.h>

#include <gdk/gdkenumtypes.h>
// -*- c++ -*-
/* $Id: region.ccg,v 1.7 2002/10/11 18:05:38 murrayc Exp $ */

/*
 *
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkregion.h>

namespace Gdk
{

Region::Region(const Glib::ArrayHandle<Gdk::Point>& points, FillRule fill_rule)
:
  // The dangerous-looking cast to GdkPoint* works, because Gdk::Point
  // has only one member variable of type GdkPoint, and no vtable.  Please
  // don't copy this code, casts like that won't work with most other types.

  gobject_ (gdk_region_polygon(
      reinterpret_cast<GdkPoint*>(const_cast<Gdk::Point*>(points.data())),
      points.size(), (GdkFillRule)(fill_rule)))
{}

Region::Region(const Rectangle& rectangle)
:
  gobject_ (gdk_region_rectangle(const_cast<GdkRectangle*>(rectangle.gobj())))
{}

Glib::ArrayHandle<Rectangle> Region::get_rectangles() const
{
  GdkRectangle* rectangles = 0;
  int n_rectangles = 0;

  gdk_region_get_rectangles(gobject_, &rectangles, &n_rectangles);

  // The dangerous-looking cast to Rectangle* works, because Gdk::Rectangle
  // has only one member variable of type GdkRectangle, and no vtable.  Please
  // don't copy this code, casts like that won't work with most other types.

  return Glib::ArrayHandle<Rectangle>(
      reinterpret_cast<Rectangle*>(rectangles), n_rectangles, Glib::OWNERSHIP_SHALLOW);
}

} // namespace Gdk


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::FillRule>::value_type()
{
  return gdk_fill_rule_get_type();
}

// static
GType Glib::Value<Gdk::OverlapType>::value_type()
{
  return gdk_overlap_type_get_type();
}


namespace Glib
{

Gdk::Region wrap(GdkRegion* object, bool take_copy /* = false */)
{
  return Gdk::Region(object, take_copy);
}

} // namespace Glib


namespace Gdk
{


Region::Region()
:
  gobject_ (gdk_region_new())
{}

Region::Region(const Region& src)
:
  gobject_ ((src.gobject_) ? gdk_region_copy(src.gobject_) : 0)
{}

Region::Region(GdkRegion* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = gdk_region_copy(castitem);
    else
      gobject_ = 0;
  }
}

Region& Region::operator=(const Region& src)
{
  GdkRegion *const new_gobject = (src.gobject_) ? gdk_region_copy(src.gobject_) : 0;

  if(gobject_)
    gdk_region_destroy(gobject_);

  gobject_ = new_gobject;

  return *this;
}

Region::~Region()
{
  if(gobject_)
    gdk_region_destroy(gobject_);
}

GdkRegion* Region::gobj_copy() const
{
  return gdk_region_copy(gobject_);
}


void Region::get_clipbox(const Rectangle& rectangle)
{
  gdk_region_get_clipbox(gobj(), const_cast<GdkRectangle*>(rectangle.gobj()));
}

bool Region::empty()
{
  return gdk_region_empty(gobj());
}

bool Region::point_in(int x, int y)
{
  return gdk_region_point_in(gobj(), x, y);
}

OverlapType Region::rect_in(const Rectangle& rect)
{
  return ((OverlapType)(gdk_region_rect_in(gobj(), const_cast<GdkRectangle*>(rect.gobj()))));
}

void Region::offset(int dx, int dy)
{
  gdk_region_offset(gobj(), dx, dy);
}

void Region::shrink(int dx, int dy)
{
  gdk_region_shrink(gobj(), dx, dy);
}

void Region::union_with_rect(const Rectangle& rect)
{
  gdk_region_union_with_rect(gobj(), const_cast<GdkRectangle*>(rect.gobj()));
}

void Region::intersect(Region& source2)
{
  gdk_region_intersect(gobj(), (source2).gobj());
}

void Region::union_(Region& source2)
{
  gdk_region_union(gobj(), (source2).gobj());
}

void Region::subtract(Region& source2)
{
  gdk_region_subtract(gobj(), (source2).gobj());
}

void Region::xor_(Region& source2)
{
  gdk_region_xor(gobj(), (source2).gobj());
}

void Region::spans_intersect_foreach(GdkSpan* spans, int n_spans, bool sorted, GdkSpanFunc function, gpointer data)
{
  gdk_region_spans_intersect_foreach(gobj(), spans, n_spans, static_cast<int>(sorted), function, data);
}


bool operator==(const Region& lhs, const Region& rhs)
{
  return (gdk_region_equal(const_cast<GdkRegion*>(lhs.gobj()), const_cast<GdkRegion*>(rhs.gobj())) != 0);
}

bool operator!=(const Region& lhs, const Region& rhs)
{
  return (gdk_region_equal(const_cast<GdkRegion*>(lhs.gobj()), const_cast<GdkRegion*>(rhs.gobj())) == 0);
}


} // namespace Gdk


