// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_CLIPBOARD_H
#define _GTKMM_CLIPBOARD_H

#include <glibmm.h>

/* $Id: clipboard.hg,v 1.9 2003/01/04 14:40:22 murrayc Exp $ */

/* accelgroup.h
 * 
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 
#include <gdkmm/display.h>
#include <gtkmm/targetentry.h>
#include <gtkmm/selectiondata.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkClipboard GtkClipboard;
typedef struct _GtkClipboardClass GtkClipboardClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Clipboard_Class; } // namespace Gtk
namespace Gtk
{


class Clipboard : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Clipboard CppObjectType;
  typedef Clipboard_Class CppClassType;
  typedef GtkClipboard BaseObjectType;
  typedef GtkClipboardClass BaseClassType;

private:
  friend class Clipboard_Class;
  static CppClassType clipboard_class_;

  // noncopyable
  Clipboard(const Clipboard&);
  Clipboard& operator=(const Clipboard&);

protected:
  explicit Clipboard(const Glib::ConstructParams& construct_params);
  explicit Clipboard(GtkClipboard* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Clipboard();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkClipboard*       gobj()       { return reinterpret_cast<GtkClipboard*>(gobject_); }
  const GtkClipboard* gobj() const { return reinterpret_cast<GtkClipboard*>(gobject_); }

  GtkClipboard* gobj_copy();

private:


public:

  
  /** Returns the clipboard object for the given selection.
   * See gtk_clipboard_get_for_display() for complete details.
   * @param selection A Gdk::Atom which identifies the clipboard
   * to use.
   * @return The appropriate clipboard object. If no
   * clipboard already exists, a new one will
   * be created. Once a clipboard object has
   * been created, it is persistent for all time and
   * cannot be freed.
   */
  static Glib::RefPtr<Clipboard> get(GdkAtom selection = GDK_SELECTION_CLIPBOARD);
  
  /** Returns the clipboard object for the given selection.
   * Cut/copy/paste menu items and keyboard shortcuts should use
   * the default clipboard, returned by passing Gdk::SELECTION_CLIPBOARD for @a selection .
   * (Gdk::NONE is supported as a synonym for GDK_SELECTION_CLIPBOARD
   * for backwards compatibility reasons.)
   * The currently-selected object or text should be provided on the clipboard
   * identified by Gdk::SELECTION_PRIMARY. Cut/copy/paste menu items
   * conceptually copy the contents of the Gdk::SELECTION_PRIMARY clipboard
   * to the default clipboard, i.e. they copy the selection to what the
   * user sees as the clipboard.
   * 
   * (Passing Gdk::NONE is the same as using <tt>gdk_atom_intern
   * ("CLIPBOARD", <tt>false</tt>)</tt>. See
   * 
   * http://www.freedesktop.org/standards/clipboards.txt
   * for a detailed discussion of the "CLIPBOARD" vs. "PRIMARY" selections
   * under the X window system. On Win32 the Gdk::SELECTION_PRIMARY
   * clipboard is essentially ignored.)
   * 
   * It's possible to have arbitrary named clipboards; if you do invent
   * new clipboards, you should prefix the selection name with an
   * underscore (because the ICCCM requires that nonstandard atoms are
   * underscore-prefixed), and namespace it as well. For example,
   * if your application called "Foo" has a special-purpose
   * clipboard, you might call it "_FOO_SPECIAL_CLIPBOARD".
   * @param display The display for which the clipboard is to be retrieved or created.
   * @param selection A Gdk::Atom which identifies the clipboard
   * to use.
   * @return The appropriate clipboard object. If no
   * clipboard already exists, a new one will
   * be created. Once a clipboard object has
   * been created, it is persistent for all time and
   * cannot be freed.
   * 
   * Since: 2.2.
   */
  static Glib::RefPtr<Clipboard> get_for_display(const Glib::RefPtr<Gdk::Display>& display, GdkAtom selection = GDK_SELECTION_CLIPBOARD);

  
  /** Gets the Gdk::Display associated with @a clipboard 
   * @return The Gdk::Display associated with @a clipboard 
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<Gdk::Display> get_display();
  
  /** Gets the Gdk::Display associated with @a clipboard 
   * @return The Gdk::Display associated with @a clipboard 
   * 
   * Since: 2.2.
   */
  Glib::RefPtr<const Gdk::Display> get_display() const;

  /// e.g.: void on_get(Gtk::SelectionData& selection_data, guint info);
  typedef SigC::Slot2<void, SelectionData&, guint> SlotGet;

  /// e.g.: void on_clear();
  typedef SigC::Slot0<void> SlotClear;

 /**
  * Virtually sets the contents of the specified clipboard by providing
  * a list of supported formats for the clipboard data and a function
  * to call to get the actual data when it is requested.
  *
  * @param targets Information about the available forms for the clipboard data.
  * @param slot_get method to call to get the actual clipboard data.
  * @param slot_clear When the clipboard contents are set again, this method will
  *              be called, and slot_get will not be subsequently called.
  *
  * @return true if setting the clipboard data succeeded. If setting
  *               the clipboard data failed then the provided callback methods
  *               will be ignored.
  */
  bool set(const ArrayHandle_TargetEntry& targets, const SlotGet& slot_get, const SlotClear& slot_clear);
  
  
  /** If the clipboard contents callbacks were set with 
   * gtk_clipboard_set_with_owner(), and the gtk_clipboard_set_with_data() or 
   * gtk_clipboard_clear() has not subsequently called, returns the owner set 
   * by gtk_clipboard_set_with_owner().
   * @return The owner of the clipboard, if any; otherwise <tt>0</tt>.
   */
  Glib::RefPtr<Glib::Object> get_owner();
  
  /** If the clipboard contents callbacks were set with 
   * gtk_clipboard_set_with_owner(), and the gtk_clipboard_set_with_data() or 
   * gtk_clipboard_clear() has not subsequently called, returns the owner set 
   * by gtk_clipboard_set_with_owner().
   * @return The owner of the clipboard, if any; otherwise <tt>0</tt>.
   */
  Glib::RefPtr<const Glib::Object> get_owner() const;

  /**
  * Clears the contents of the clipboard. Generally this should only
  * be called between the time you call set()
  * and when the slot_clear you supplied is called. Otherwise, the
  * clipboard may be owned by someone else.
  */
  
  /** Clears the contents of the clipboard. Generally this should only
   * be called between the time you call gtk_clipboard_set_with_owner()
   * or gtk_clipboard_set_with_data(),
   * and when the @a clear_func  you supplied is called. Otherwise, the
   * clipboard may be owned by someone else.
   */
  void clear();

  /**
   * Sets the contents of the clipboard to the given UTF-8 string. GTK+ will
   * make a copy of the text and take responsibility for responding
   * for requests for the text, and for converting the text into
   * the requested format.
   *
   * @param text  A UTF-8 string.
   *
   */
  void set_text(const Glib::ustring& text);
  

  /// e.g.: void on_received(const SelectionData& selection_data);
  typedef SigC::Slot1<void, const SelectionData&> SlotReceived;
  void request_contents(const Glib::ustring& target, const SlotReceived& slot);
  

  /* This requests the special "TARGETS" target.
   * Call Gtk::SelectionData::get_targets() on the selection_data provided to the callback,
   *  to see what targets are available.
   */
  void request_targets(const SlotReceived& slot);
  
  /// e.g.: void on_textreceived(const Glib::ustring& text);
  typedef SigC::Slot1<void, const Glib::ustring&> SlotTextReceived;
  void request_text(const SlotTextReceived& slot);
  
               
  /**
   * Requests the contents of the clipboard using the given target.
   * This function waits for the data to be received using the main
   * loop, so events, timeouts, etc, may be dispatched during the wait.
   *
   * @param target The form into which the clipboard owner should convert the selection.
   *
   * @return A GtkSelectionData object, which will be invalid if retrieving the given target failed. 
   **/
  SelectionData wait_for_contents(const Glib::ustring& target) const;
  

  /** Requests the contents of the clipboard as text and converts
   * the result to UTF-8 if necessary. This function waits for
   * the data to be received using the main loop, so events,
   * timeouts, etc, may be dispatched during the wait.
   * @return A newly-allocated UTF-8 string which must
   * be freed with Glib::free(), or <tt>0</tt> if retrieving
   * the selection data failed. (This could happen
   * for various reasons, in particular if the
   * clipboard was empty or if the contents of the
   * clipboard could not be converted into text form.).
   */
  Glib::ustring wait_for_text() const;
  
  /** Test to see if there is text available to be pasted
   * This is done by requesting the TARGETS atom and checking
   * if it contains any of the names: STRING, TEXT, COMPOUND_TEXT,
   * UTF8_STRING. This function waits for the data to be received
   * using the main loop, so events, timeouts, etc, may be dispatched
   * during the wait.
   * 
   * This function is a little faster than calling
   * gtk_clipboard_wait_for_text() since it doesn't need to retrieve
   * the actual text.
   * @return <tt>true</tt> is there is text available, <tt>false</tt> otherwise.
   */
  bool wait_is_text_available() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Clipboard */
  Glib::RefPtr<Gtk::Clipboard> wrap(GtkClipboard* object, bool take_copy = false);
}


#endif /* _GTKMM_CLIPBOARD_H */

