// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PAGESETUP_H
#define _GTKMM_PAGESETUP_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gtkmm/enums.h>
#include <gtkmm/papersize.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPageSetup GtkPageSetup;
typedef struct _GtkPageSetupClass GtkPageSetupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class PageSetup_Class; } // namespace Gtk
namespace Gtk
{

/** A PageSetup object stores the page size, orientation and margins. You can get one of these from the page setup dialog 
 * and then pass it to the PrintOperation when printing. The benefit of splitting this out of the PrintSettings is that 
 * these affect the actual layout of the page, and thus need to be set long before the user prints.
 *
 * The margins specified in this object are the "print margins", i.e. the parts of the page that the printer cannot print  
 * on. These are different from the layout margins that a word processor uses; they are typically used to determine the 
 * minimal size for the layout margins.
 *
 * To obtain a PageSetup use PageSetup::create() to get the defaults, or use run_page_setup_dialog() to show the page 
 * setup dialog and receive the resulting page setup. 
 *
 * @newin2p10
 *
 * @ingroup Printing
 */

class PageSetup : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef PageSetup CppObjectType;
  typedef PageSetup_Class CppClassType;
  typedef GtkPageSetup BaseObjectType;
  typedef GtkPageSetupClass BaseClassType;

private:  friend class PageSetup_Class;
  static CppClassType pagesetup_class_;

private:
  // noncopyable
  PageSetup(const PageSetup&);
  PageSetup& operator=(const PageSetup&);

protected:
  explicit PageSetup(const Glib::ConstructParams& construct_params);
  explicit PageSetup(GtkPageSetup* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~PageSetup();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkPageSetup*       gobj()       { return reinterpret_cast<GtkPageSetup*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkPageSetup* gobj() const { return reinterpret_cast<GtkPageSetup*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkPageSetup* gobj_copy();

private:

protected:
  PageSetup();

#if 0 //TODO: Reimplement, or add _construct_from_* functions in GTK+.
GtkPageSetup	  *gtk_page_setup_new_from_file	    (const gchar         *file_name,
						     GError              **error);
GtkPageSetup	  *gtk_page_setup_new_from_key_file (GKeyFile            *key_file,
						     const gchar         *group_name,
						     GError             **error);
#endif

public:
  
  static Glib::RefPtr<PageSetup> create();


  /** Gets the page orientation of the Gtk::PageSetup.
   * @return The page orientation
   * 
   * @newin2p10.
   */
  PageOrientation get_orientation() const;
  
  /** Sets the page orientation of the Gtk::PageSetup.
   * 
   * @newin2p10
   * @param orientation A Gtk::PageOrientation value.
   */
  void set_orientation(PageOrientation orientation);

  
  /** Gets the paper size of the Gtk::PageSetup.
   * @return The paper size
   * 
   * @newin2p10.
   */
  PaperSize get_paper_size();
  
  /** Gets the paper size of the Gtk::PageSetup.
   * @return The paper size
   * 
   * @newin2p10.
   */
  const PaperSize get_paper_size() const;
  
  /** Sets the paper size of the Gtk::PageSetup without
   * changing the margins. See 
   * gtk_page_setup_set_paper_size_and_default_margins().
   * 
   * @newin2p10
   * @param size A Gtk::PaperSize.
   */
  void set_paper_size(const PaperSize& paper_size);

  
  /** Gets the top margin in units of @a unit .
   * @param unit The unit for the return value.
   * @return The top margin
   * 
   * @newin2p10.
   */
  double get_top_margin(Unit unit) const;
  
  /** Sets the top margin of the Gtk::PageSetup.
   * 
   * @newin2p10
   * @param margin The new top margin in units of @a unit .
   * @param unit The units for @a margin .
   */
  void set_top_margin(double margin, Unit unit);

  
  /** Gets the bottom margin in units of @a unit .
   * @param unit The unit for the return value.
   * @return The bottom margin
   * 
   * @newin2p10.
   */
  double get_bottom_margin(Unit unit) const;
  
  /** Sets the bottom margin of the Gtk::PageSetup.
   * 
   * @newin2p10
   * @param margin The new bottom margin in units of @a unit .
   * @param unit The units for @a margin .
   */
  void set_bottom_margin(double margin, Unit unit);

  
  /** Gets the left margin in units of @a unit .
   * @param unit The unit for the return value.
   * @return The left margin
   * 
   * @newin2p10.
   */
  double get_left_margin(Unit unit) const;
  
  /** Sets the left margin of the Gtk::PageSetup.
   * 
   * @newin2p10
   * @param margin The new left margin in units of @a unit .
   * @param unit The units for @a margin .
   */
  void set_left_margin(double margin, Unit unit);

  
  /** Gets the right margin in units of @a unit .
   * @param unit The unit for the return value.
   * @return The right margin
   * 
   * @newin2p10.
   */
  double get_right_margin(Unit unit) const;
  
  /** Sets the right margin of the Gtk::PageSetup.
   * 
   * @newin2p10
   * @param margin The new right margin in units of @a unit .
   * @param unit The units for @a margin .
   */
  void set_right_margin(double margin, Unit unit);

  
  /** Sets the paper size of the Gtk::PageSetup and modifies
   * the margins according to the new paper size.
   * 
   * @newin2p10
   * @param size A Gtk::PaperSize.
   */
  void set_paper_size_and_default_margins(const PaperSize& paper_size);

  
  /** Return value: the paper width.
   * @param unit The unit for the return value.
   * @return The paper width.
   * 
   * @newin2p10.
   */
  double get_paper_width(Unit unit) const;
  
  /** Return value: the paper height.
   * @param unit The unit for the return value.
   * @return The paper height.
   * 
   * @newin2p10.
   */
  double get_paper_height(Unit unit) const;

  
  /** Return value: the page width.
   * @param unit The unit for the return value.
   * @return The page width.
   * 
   * @newin2p10.
   */
  double get_page_width(Unit unit) const;
  
  /** Return value: the page height.
   * @param unit The unit for the return value.
   * @return The page height.
   * 
   * @newin2p10.
   */
  double get_page_height(Unit unit) const;

  //The save_ prefix was added to these functions to make them clearer. GTK+ didn't want to change them.
  
  /** This function saves the information from @a setup  to @a file_name .
   * @param file_name The file to save to.
   * @param error Return location for errors, or <tt>0</tt>.
   * @return <tt>true</tt> on success
   * 
   * @newin2p12.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool save_to_file(const std::string& file_name) const;
#else
  bool save_to_file(const std::string& file_name, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** This function adds the page setup from @a setup  to @a key_file .
   * 
   * @newin2p12
   * @param key_file The G::KeyFile to save the page setup to.
   * @param group_name The group to add the settings to in @a key_file , 
   * or <tt>0</tt> to use the default name "Page Setup".
   */
  void save_to_key_file(Glib::KeyFile& key_file, const Glib::ustring& group_name);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::PageSetup
   */
  Glib::RefPtr<Gtk::PageSetup> wrap(GtkPageSetup* object, bool take_copy = false);
}


#endif /* _GTKMM_PAGESETUP_H */

