// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gdkmm/display.h>
#include <gdkmm/private/display_p.h>

#include <gdk/gdkenumtypes.h>
// -*- c++ -*-
/* $Id: display.ccg,v 1.1 2002/11/21 19:48:38 murrayc Exp $ */

/*
 *
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/window.h>
#include <gdk/gdkdisplay.h>

namespace Gdk
{

guint32 Display::get_drag_protocol(guint32 xid, GdkDragProtocol* protocol)
{
  return gdk_drag_get_protocol_for_display(gobj(), xid, protocol);
}

GdkKeymap* Display::get_keymap()
{
  return gdk_keymap_get_for_display(gobj());
}

bool Display::set_selection_owner(const Glib::RefPtr<Window>& owner, GdkAtom selection, guint32 time_, bool send_event)
{
  return gdk_selection_owner_set_for_display(gobj(), owner->gobj(), selection, time_, (gboolean)send_event);
}

Glib::RefPtr<Window> Display::get_selection_owner(GdkAtom selection)
{
  return Glib::wrap( (GdkWindowObject*)gdk_selection_owner_get_for_display(gobj(), selection) , true);
}

void Display::selection_send_notify(guint32 requestor, GdkAtom selection, GdkAtom target, GdkAtom property, guint32 time_)
{
  gdk_selection_send_notify_for_display(gobj(), requestor, selection, target, property, time_);
}

void Display::get_pointer(Glib::RefPtr<Screen>& screen, int& x, int& y, ModifierType& mask)
{
  GdkScreen* cScreen = 0;
  GdkModifierType cMask = (GdkModifierType)mask;
  gdk_display_get_pointer(gobj(), &cScreen, &x, &y, &cMask);
  screen = Glib::wrap(cScreen);
  mask = (ModifierType)cMask;
}


} //Gdk


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gdk::Display> wrap(GdkDisplay* object, bool take_copy)
{
  return Glib::RefPtr<Gdk::Display>( dynamic_cast<Gdk::Display*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Display_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Display_Class::class_init_function;

    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually necessary?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_display_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Display_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

}


Glib::ObjectBase* Display_Class::wrap_new(GObject* object)
{
  return new Display((GdkDisplay*)object);
}


/* The implementation: */

GdkDisplay* Display::gobj_copy()
{
  reference();
  return gobj();
}

Display::Display(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

Display::Display(GdkDisplay* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Display::~Display()
{}

Display::CppClassType Display::display_class_; // initialize static member

GType Display::get_type()
{
  return display_class_.init().get_type();
}

GType Display::get_base_type()
{
  return gdk_display_get_type();
}

Display::Display()
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Glib::Object(Glib::ConstructParams(display_class_.init()))
{
  }

Glib::RefPtr<Display> Display::open(const Glib::ustring& display_name)
{
  return Glib::wrap(gdk_display_open(display_name.c_str()));
}

Glib::ustring Display::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gdk_display_get_name(const_cast<GdkDisplay*>(gobj())));
}

int Display::get_n_screens() const
{
  return gdk_display_get_n_screens(const_cast<GdkDisplay*>(gobj()));
}

Glib::RefPtr<Screen> Display::get_screen(int screen_num)
{

  Glib::RefPtr<Screen> retvalue = Glib::wrap(gdk_display_get_screen(gobj(), screen_num));

  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Screen> Display::get_default_screen()
{

  Glib::RefPtr<Screen> retvalue = Glib::wrap(gdk_display_get_default_screen(gobj()));

  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Display::pointer_ungrab(guint32 time_)
{
  gdk_display_pointer_ungrab(gobj(), time_);
}

void Display::keyboard_ungrab(guint32 time_)
{
  gdk_display_keyboard_ungrab(gobj(), time_);
}

bool Display::pointer_is_grabbed() const
{
  return gdk_display_pointer_is_grabbed(const_cast<GdkDisplay*>(gobj()));
}

void Display::beep()
{
  gdk_display_beep(gobj());
}

void Display::sync()
{
  gdk_display_sync(gobj());
}

void Display::close()
{
  gdk_display_close(gobj());
}

Glib::ListHandle< Glib::RefPtr<Device> > Display::list_devices()
{
  return Glib::ListHandle< Glib::RefPtr<Device> >(gdk_display_list_devices(gobj()), Glib::OWNERSHIP_DEEP);
}

GdkEvent* Display::get_event()
{
  return gdk_display_get_event(gobj());
}

GdkEvent* Display::peek_event()
{
  return gdk_display_peek_event(gobj());
}

void Display::put_event(GdkEvent* event)
{
  gdk_display_put_event(gobj(), event);
}

void Display::add_client_message_filter(GdkAtom message_type, GdkFilterFunc func, gpointer data)
{
  gdk_display_add_client_message_filter(gobj(), message_type, func, data);
}

void Display::set_double_click_time(guint msec)
{
  gdk_display_set_double_click_time(gobj(), msec);
}

Glib::RefPtr<Display> Display::get_default()
{
  return Glib::wrap(gdk_display_get_default());
}

Glib::RefPtr<Device> Display::get_core_pointer()
{
  return Glib::wrap(gdk_display_get_core_pointer(gobj()));
}

Glib::RefPtr<const Device> Display::get_core_pointer() const
{
  return Glib::wrap(gdk_display_get_core_pointer(const_cast<GdkDisplay*>(gobj())));
}

Glib::RefPtr<Window> Display::get_window_at_pointer(int& win_x, int& win_y)
{
  return Glib::wrap((GdkWindowObject*)(gdk_display_get_window_at_pointer(gobj(), &win_x, &win_y)));
}

GdkDisplayPointerHooks* Display::set_pointer_hooks(const GdkDisplayPointerHooks * new_hooks)
{
  return gdk_display_set_pointer_hooks(gobj(), new_hooks);
}

Glib::RefPtr<Display> Display::open_default_libgtk_only()
{
  return Glib::wrap(gdk_display_open_default_libgtk_only());
}

Glib::RefPtr<Pixmap> Display::lookup_pixmap(GdkNativeWindow anid)
{
  return Glib::wrap((GdkPixmapObject*)(gdk_pixmap_lookup_for_display(gobj(), anid)));
}

Glib::RefPtr<const Pixmap> Display::lookup_pixmap(GdkNativeWindow anid) const
{
  return Glib::wrap((GdkPixmapObject*)(gdk_pixmap_lookup_for_display(const_cast<GdkDisplay*>(gobj()), anid)));
}


} // namespace Gdk


