// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GLIBMM_CONVERT_H
#define _GLIBMM_CONVERT_H


/* $Id: convert.hg,v 1.4 2002/10/06 22:56:45 daniel Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glib/gtypes.h> /* for gsize */

#include <glibmm/error.h>
#include <glibmm/ustring.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GIConv* GIConv; }
#endif


namespace Glib
{

/** @defgroup CharsetConv Character Set Conversion
 * Utility functions for converting strings between different character sets.
 * @{
 */

/** Exception class for charset conversion errors.
 * Glib::convert() and friends throw a ConvertError exception if the charset
 * conversion failed for some reason.  When writing non-trivial applications
 * you should always catch those errors, and then try to recover, or tell the
 * user the input was invalid.
 */
class ConvertError : public Glib::Error
{
public:
  enum Code
  {
    NO_CONVERSION,
    ILLEGAL_SEQUENCE,
    FAILED,
    PARTIAL_INPUT,
    BAD_URI,
    NOT_ABSOLUTE_PATH
  };

  explicit ConvertError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  static void throw_func(GError* gobject);
  friend void wrap_init(); // uses throw_func()
#endif
};


/** Thin %iconv() wrapper.
 * glibmm provides Glib::convert() and Glib::locale_to_utf8() which
 * are likely more convenient than the raw iconv wrappers.  However,
 * creating an IConv object once and using the convert() method could
 * be useful when converting multiple times between the same charsets.
 */
class IConv
{
public:
  /** Open new conversion descriptor.
   * @param to_codeset Destination codeset.
   * @param from_codeset %Source codeset.
   * @throw Glib::ConvertError
   */
  IConv(const std::string& to_codeset, const std::string& from_codeset);

  explicit IConv(GIConv gobject);

  /** Close conversion descriptor.
   */
  ~IConv();

  /** Same as the standard UNIX routine %iconv(), but may be implemented
   * via libiconv on UNIX flavors that lack a native implementation.  glibmm
   * provides Glib::convert() and Glib::locale_to_utf8() which are likely
   * more convenient than the raw iconv wrappers.
   * @param inbuf Bytes to convert.
   * @param inbytes_left In/out parameter, bytes remaining to convert in @a inbuf.
   * @param outbuf Converted output bytes.
   * @param outbytes_left In/out parameter, bytes available to fill in @a outbuf.
   * @return Count of non-reversible conversions, or <tt>static_cast<size_t>(-1)</tt> on error.
   */
  size_t iconv(char** inbuf, gsize* inbytes_left, char** outbuf, gsize* outbytes_left);

  /** Reset conversion descriptor to initial state.
   * Same as <tt>iconv(0, 0, 0, 0)</tt>, but implemented slightly differently
   * in order to work on Sun Solaris <= 7.  It's also more obvious so you're
   * encouraged to use it.
   */
  void reset();

  /** Convert from one encoding to another.
   * @param str The string to convert.
   * @return The converted string.
   * @throw Glib::ConvertError
   */
  std::string convert(const std::string& str);

  GIConv gobj() { return gobject_; }

private:
  GIConv gobject_;

  // noncopyable
  IConv(const IConv&);
  IConv& operator=(const IConv&);
};


/** Get the charset used by the current locale.
 * @return Whether the current locale uses the UTF-8 charset.
 */
bool get_charset();

/** Get the charset used by the current locale.
 * @param charset Will be filled with the charset's name.
 * @return Whether the current locale uses the UTF-8 charset.
 */
bool get_charset(std::string& charset);

/** Convert from one encoding to another.
 * @param str The string to convert.
 * @param to_codeset Name of the target charset.
 * @param from_codeset Name of the source charset.
 * @return The converted string.
 * @throw Glib::ConvertError
 */
std::string convert(const std::string& str,
                    const std::string& to_codeset,
                    const std::string& from_codeset);

/** Converts a string from one character set to another, possibly including
 * fallback sequences for characters not representable in the output.
 * Characters not in the target encoding will be represented as Unicode
 * escapes <tt>\\x{XXXX}</tt> or <tt>\\x{XXXXXX}</tt>.
 * @param str The string to convert.
 * @param to_codeset Name of the target charset.
 * @param from_codeset Name of the source charset.
 * @return The converted string.
 * @throw Glib::ConvertError
 */
std::string convert_with_fallback(const std::string& str,
                                  const std::string& to_codeset,
                                  const std::string& from_codeset);

/** Converts a string from one character set to another, possibly including
 * fallback sequences for characters not representable in the output.
 * @note It is not guaranteed that the specification for the fallback sequences
 * in @a fallback will be honored. Some systems may do a approximate conversion
 * from @a from_codeset to @a to_codeset in their iconv() functions, in which
 * case GLib will simply return that approximate conversion.
 *
 * @param str The string to convert.
 * @param to_codeset Name of the target charset.
 * @param from_codeset Name of the source charset.
 * @param fallback UTF-8 string to be used in place of characters which aren't
 *  available in the target encoding.  All characters in the fallback string
 *  @em must be available in the target encoding.
 * @return The converted string.
 * @throw Glib::ConvertError
 */
std::string convert_with_fallback(const std::string& str,
                                  const std::string& to_codeset,
                                  const std::string& from_codeset,
                                  const Glib::ustring& fallback);

/** Convert from the current locale's encoding to UTF-8.
 * Convenience wrapper around Glib::convert().
 * @param opsys_string The string to convert.  Must be encoded in the charset
 *  used by the operating system's current locale.
 * @return The input string converted to UTF-8 encoding.
 * @throw Glib::ConvertError
 */
Glib::ustring locale_to_utf8(const std::string& opsys_string);

/** Convert from UTF-8 to the current locale's encoding.
 * Convenience wrapper around Glib::convert().
 * @param utf8_string The UTF-8 string to convert.
 * @return The input string converted to the charset used by the operating
 *  system's current locale.
 * @throw Glib::ConvertError
 */
std::string locale_from_utf8(const Glib::ustring& utf8_string);

/** Converts a string which is in the encoding used for filenames into
 * a UTF-8 string.
 * @param opsys_string A string in the encoding for filenames.
 * @return The converted string.
 * @throw Glib::ConvertError
 */
Glib::ustring filename_to_utf8(const std::string& opsys_string);

/** Converts a string from UTF-8 to the encoding used for filenames.
 * @param utf8_string A UTF-8 encoded string.
 * @return The converted string.
 * @throw Glib::ConvertError
 */
std::string filename_from_utf8(const Glib::ustring& utf8_string);

/** Converts an escaped UTF-8 encoded URI to a local filename
 * in the encoding used for filenames.
 * @param uri A string in the encoding for filenames.
 * @param hostname Location to store hostname for the URI. If there is no
 *   hostname in the URI, <tt>""</tt> will be stored in this location.
 * @return The resulting filename.
 * @throw Glib::ConvertError
 */
std::string filename_from_uri(const Glib::ustring& uri, Glib::ustring& hostname);

/** Converts an escaped UTF-8 encoded URI to a local filename in the encoding
 * used for filenames.
 * @param uri A string in the encoding for filenames.
 * @return The resulting filename.
 * @throw Glib::ConvertError
 */
std::string filename_from_uri(const Glib::ustring& uri);

/** Converts an absolute filename to an escaped UTF-8 encoded URI.
 * @param filename An absolute filename specified in the encoding used
 *   for filenames by the operating system.
 * @param hostname A UTF-8 encoded hostname.
 * @return The resulting URI.
 * @throw Glib::ConvertError
 */
Glib::ustring filename_to_uri(const std::string& filename, const Glib::ustring& hostname);

/** Converts an absolute filename to an escaped UTF-8 encoded URI.
 * @param filename An absolute filename specified in the encoding used
 *   for filenames by the operating system.
 * @return The resulting URI.
 * @throw Glib::ConvertError
 */
Glib::ustring filename_to_uri(const std::string& filename);

/** @} group CharsetConv */

} // namespace Glib


#endif /* _GLIBMM_CONVERT_H */

