// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_STYLE_H
#define _GTKMM_STYLE_H

#include <glibmm.h>

/* $Id: style.hg,v 1.36 2002/10/11 18:05:59 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <pangomm/fontdescription.h>
#include <pangomm/layout.h>

#include <gdkmm/gc.h>
#include <gdkmm/pixmap.h>
#include <gdkmm/types.h>
#include <gdkmm/window.h>

#include <gtkmm/object.h>
#include <gtkmm/enums.h>
#include <gtkmm/iconsource.h>
#include <gtkmm/iconset.h>
#include <gtkmmconfig.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkStyle GtkStyle;
typedef struct _GtkStyleClass GtkStyleClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Style_Class; } // namespace Gtk
namespace Gtk
{

class Widget;
class RcStyle;


class Style : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Style CppObjectType;
  typedef Style_Class CppClassType;
  typedef GtkStyle BaseObjectType;
  typedef GtkStyleClass BaseClassType;

private:
  friend class Style_Class;
  static CppClassType style_class_;

  // noncopyable
  Style(const Style&);
  Style& operator=(const Style&);

protected:
  explicit Style(const Glib::ConstructParams& construct_params);
  explicit Style(GtkStyle* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Style();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkStyle*       gobj()       { return reinterpret_cast<GtkStyle*>(gobject_); }
  const GtkStyle* gobj() const { return reinterpret_cast<GtkStyle*>(gobject_); }

  GtkStyle* gobj_copy();

private:

  
public:

  void set_bg(StateType state, const Gdk::Color& color);
Gdk::Color get_bg(StateType state) const;

  void set_light(StateType state, const Gdk::Color& color);
Gdk::Color get_light(StateType state) const;

  void set_dark(StateType state, const Gdk::Color& color);
Gdk::Color get_dark(StateType state) const;

  void set_mid(StateType state, const Gdk::Color& color);
Gdk::Color get_mid(StateType state) const;

  void set_base(StateType state, const Gdk::Color& color);
Gdk::Color get_base(StateType state) const;

  void set_fg(StateType state, const Gdk::Color& color);
Gdk::Color get_fg(StateType state) const;

  void set_text(StateType state, const Gdk::Color& color);
Gdk::Color get_text(StateType state) const;

  void set_text_aa(StateType state, const Gdk::Color& color);
Gdk::Color get_text_aa(StateType state) const;


  void set_font(const Pango::FontDescription& font_desc);

/* These are only available after being attached to a window */
  Pango::FontDescription get_font() const;

  Glib::RefPtr<Gdk::GC> get_fg_gc(StateType state_type);
  Glib::RefPtr<const Gdk::GC> get_fg_gc(StateType state_type) const;

  Glib::RefPtr<Gdk::GC> get_bg_gc(StateType state_type);
  Glib::RefPtr<const Gdk::GC> get_bg_gc(StateType state_type) const;

  Glib::RefPtr<Gdk::GC> get_light_gc(StateType state_type);
  Glib::RefPtr<const Gdk::GC> get_light_gc(StateType state_type) const;

  Glib::RefPtr<Gdk::GC> get_dark_gc(StateType state_type);
  Glib::RefPtr<const Gdk::GC> get_dark_gc(StateType state_type) const;

  Glib::RefPtr<Gdk::GC> get_mid_gc ( StateType state_type);
  Glib::RefPtr<const Gdk::GC> get_mid_gc ( StateType state_type) const;

  Glib::RefPtr<Gdk::GC> get_text_gc(StateType state_type);
  Glib::RefPtr<const Gdk::GC> get_text_gc(StateType state_type) const;

  Glib::RefPtr<Gdk::GC> get_base_gc(StateType state_type);
  Glib::RefPtr<const Gdk::GC> get_base_gc(StateType state_type) const;

  Glib::RefPtr<Gdk::GC> get_black_gc();
  Glib::RefPtr<const Gdk::GC> get_black_gc() const;
  Glib::RefPtr<Gdk::GC> get_white_gc();
  Glib::RefPtr<const Gdk::GC> get_white_gc() const;

  Gdk::Color get_background(StateType state_type) const;
  Glib::RefPtr<Gdk::Pixmap> get_background_pixmap(StateType state_type);

  
  void paint_arrow(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  ArrowType                         arrow_type,
                  bool                              fill,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  
  void paint_box(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  
  void paint_box_gap(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height,
                  PositionType                      gap_side,
                  int                               gap_x,
                  int                               gap_width) const;

  
  void paint_check(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  
  void paint_diamond(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  
  void paint_extension(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height,
                  PositionType                      gap_side) const;

  
  void paint_flat_box(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  
  void paint_focus(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  
  void paint_handle(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height,
                  Orientation                       orientation) const;

  
  /** Draws a horizontal line from ( @a x1, @a y) to ( @a x2, @a y) in @a window
   * using the given style and state.
   * @param style A Gtk::Style.
   * @param window A Gdk::Window.
   * @param state_type A state.
   * @param area Rectangle to which the output is clipped.
   * @param x1 The starting x coordinate.
   * @param x2 The ending x coordinate.
   * @param y The y coordinate.
   */
  void paint_hline(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x1,
                  int                               x2,
                  int                               y) const;

  
  void paint_option(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  void paint_polygon(
                  const Glib::RefPtr<Gdk::Window>&      window,
                  StateType                             state_type,
                  ShadowType                            shadow_type,
                  const Gdk::Rectangle&                 area,
                  Widget&                               widget,
                  const Glib::ustring&                  detail,
                  const Glib::ArrayHandle<Gdk::Point>&  points,
                  bool                                  fill) const;

  
  void paint_shadow(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  
  void paint_shadow_gap(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height,
                  PositionType                      gap_side,
                  int                               gap_x,
                  int                               gap_width) const;

  
  void paint_slider(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height,
                  Orientation                       orientation) const;

  
  void paint_tab(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  ShadowType                        shadow_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;

  
  /** Draws a vertical line from ( @a x, @a y1) to ( @a x, @a y1) in @a window
   * using the given style and state.
   * @param style A Gtk::Style.
   * @param window A Gdk::Window.
   * @param state_type A state.
   * @param area Rectangle to which the output is clipped.
   * @param y1 The starting y coordinate.
   * @param y2 The ending y coordinate.
   * @param x The x coordinate.
   */
  void paint_vline(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               y1,
                  int                               y2,
                  int                               x) const;

  
  void paint_expander(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  int                               x,
                  int                               y,
                  ExpanderStyle                     expander_style) const;

  
  void paint_layout(
                  const Glib::RefPtr<Gdk::Window>&    window,
                  StateType                           state_type,
                  bool                                use_text,
                  const Gdk::Rectangle&               area,
                  Widget&                             widget,
                  const Glib::ustring&                detail,
                  int                                 x,
                  int                                 y,
                  const Glib::RefPtr<Pango::Layout>&  layout) const;

  
  void paint_resize_grip(
                  const Glib::RefPtr<Gdk::Window>&  window,
                  StateType                         state_type,
                  const Gdk::Rectangle&             area,
                  Widget&                           widget,
                  const Glib::ustring&              detail,
                  Gdk::WindowEdge                   edge,
                  int                               x,
                  int                               y,
                  int                               width,
                  int                               height) const;


  Glib::RefPtr<Style> copy();

  // These are worthless to the users they should use set_style instead.
  
  //_WRAP_METHOD(Glib::RefPtr<Style> attach(const Glib::RefPtr<Gdk::Window>& window), gtk_style_attach)
  //_WRAP_METHOD(void detach(), gtk_style_detach)

  
  /** Sets the background of @a window to the background color or pixmap
   * specified by @a style for the given state.
   * @param window A Gdk::Window.
   * @param state_type A state.
   */
  void set_background(const Glib::RefPtr<Gdk::Window>& window, StateType state_type);

  
  void apply_default_background(const Glib::RefPtr<Gdk::Window>& window, bool set_bg,
					      Gtk::StateType state_type, const Gdk::Rectangle& area,
					      int x, int y, int width, int height);

  
  IconSet lookup_icon_set(const Gtk::StockID& stock_id);

  
  /** Renders the icon specified by @a source at the given @a size 
   * according to the given parameters and returns the result in a 
   * pixbuf.
   * @param source The Gtk::IconSource specifying the icon to render.
   * @param direction A text direction.
   * @param state A state.
   * @param size The size to render the icon at. A size of (GtkIconSize)-1
   * means render at the size of the source and don't scale.
   * @param widget The widget.
   * @param detail A style detail.
   * @return A newly-created Gdk::Pixbuf containing the rendered icon.
   */
  Glib::RefPtr<Gdk::Pixbuf> render_icon(const IconSource& source,
                                       Gtk::TextDirection direction, Gtk::StateType state, Gtk::IconSize size,
                                       Gtk::Widget& widget, const Glib::ustring& detail);

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual void realize_vfunc();
  virtual void unrealize_vfunc();
  virtual void copy_vfunc(const Glib::RefPtr<Style>& src);
  virtual Glib::RefPtr<Style> clone_vfunc();
  virtual void init_from_rc_vfunc(const Glib::RefPtr<RcStyle>& rc_style);
  virtual void set_background_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type);
  virtual Glib::RefPtr<Gdk::Pixbuf> render_icon_vfunc(const IconSource& source, TextDirection direction, StateType state, IconSize size, Widget* widget, const Glib::ustring& detail);
  virtual void draw_hline_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x1, int x2, int y);
  virtual void draw_vline_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int y1, int y2, int x);
  virtual void draw_shadow_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height);
  virtual void draw_polygon_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, GdkPoint* point, int npoints, bool fill);
  virtual void draw_arrow_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, Gtk::ArrowType arrow_type, bool fill, int x, int y, int width, int height);
  virtual void draw_diamond_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height);
  virtual void draw_string_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, const Glib::ustring& string);
  virtual void draw_box_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height);
  virtual void draw_flat_box_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height);
  virtual void draw_check_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height);
  virtual void draw_option_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height);
  virtual void draw_tab_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height);
  virtual void draw_shadow_gap_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, Gtk::PositionType gap_side, int gap_x, int gap_width);
  virtual void draw_box_gap_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, Gtk::PositionType gap_side, int gap_x, int gap_width);
  virtual void draw_extension_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, PositionType gap_side);
  virtual void draw_focus_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height);
  virtual void draw_slider_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, Orientation orientation);
  virtual void draw_handle_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, Orientation orientation);
  virtual void draw_expander_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, ExpanderStyle expander_style);
  virtual void draw_layout_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, bool use_text, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, const Glib::RefPtr<Pango::Layout>& layout);
  virtual void draw_resize_grip_vfunc(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, Gdk::WindowEdge edge, int x, int y, int width, int height);

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Style */
  Glib::RefPtr<Gtk::Style> wrap(GtkStyle* object, bool take_copy = false);
}


#endif /* _GTKMM_STYLE_H */

