// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_SCALE_H
#define _GTKMM_SCALE_H

#include <glibmm.h>

/* $Id: scale.hg,v 1.17 2002/07/08 07:42:32 murrayc Exp $ */

/* scale.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/range.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkScale GtkScale;
typedef struct _GtkScaleClass GtkScaleClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Scale_Class; } // namespace Gtk
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkVScale GtkVScale;
typedef struct _GtkVScaleClass GtkVScaleClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class VScale_Class; } // namespace Gtk
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkHScale GtkHScale;
typedef struct _GtkHScaleClass GtkHScaleClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class HScale_Class; } // namespace Gtk
namespace Gtk
{

/** 
 * A Gtk::Scale is a slider control used to select a numeric value. To use it,
 * you'll probably want to investigate the methods on its base class,
 * Gtk::Range, in addition to the methods for Gtk::Scale itself. To set the
 * value of a scale, you would normally use set_value(). To detect
 * changes to the value, you would normally use signal_value_changed().
 *
 * The Gtk::Scale widget is an abstract class, used only for deriving the
 * subclasses Gtk::HScale and Gtk::VScale, so you should use them instead.
 *
 * @ingroup Widgets
 */

class Scale : public Range
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Scale CppObjectType;
  typedef Scale_Class CppClassType;
  typedef GtkScale BaseObjectType;
  typedef GtkScaleClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Scale();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Scale_Class;
  static CppClassType scale_class_;

  // noncopyable
  Scale(const Scale&);
  Scale& operator=(const Scale&);

protected:
  explicit Scale(const Glib::ConstructParams& construct_params);
  explicit Scale(GtkScale* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkScale*       gobj()       { return reinterpret_cast<GtkScale*>(gobject_); }
  const GtkScale* gobj() const { return reinterpret_cast<GtkScale*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual void draw_value_vfunc();

  //Default Signal Handlers::
  virtual Glib::ustring on_format_value(double value);


private:

protected:
  Scale();
public:
  

  /** &lt;para&gt;
   * Sets the number of decimal places that are displayed in the value.  Also causes
   * the value of the adjustment to be rounded off to this number of digits, so the
   * retrieved value matches the value the user saw.
   * &lt;/para&gt;
   * 
   * 2 to display 1.00 etc.
   * @param digits The number of decimal places to display, e.g. use 1 to display 1.0,.
   */
  void set_digits(int digits);
  
  /** &lt;para&gt;
   * Gets the number of decimal places that are displayed in the value.
   * &lt;/para&gt;
   * @return The number of decimal places that are displayed.
   */
  int get_digits() const;

  
  /** &lt;para&gt;
   * Specifies whether the current value is displayed as a string next to the
   * slider.
   * &lt;/para&gt;
   * @param draw_value A boolean.
   */
  void set_draw_value(int draw_value);
  
  /** &lt;para&gt;
   * Returns whether the current value is displayed as a string next to the
   * slider.
   * &lt;/para&gt;
   * @return Whether the current value is displayed as a string.
   */
  int get_draw_value() const;

  
  /** &lt;para&gt;
   * Sets the position in which the current value is displayed.
   * &lt;/para&gt;
   * @param pos The position in which the current value is displayed.
   */
  void set_value_pos(PositionType pos);
  
  /** &lt;para&gt;
   * Gets the position in which the current value is displayed.
   * &lt;/para&gt;
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkScale::format-value ##### --&gt;
   * &lt;para&gt;
   * Signal which allows you to change how the scale value is displayed.  Connect a
   * signal handler which returns an allocated string representing @value.
   * That string will then be used to display the scale's value.
   * Here's an example signal handler which displays a value 1.0 as
   * with "--&gt;1.0&lt;--".
   * &lt;informalexample&gt;&lt;programlisting&gt;
   * static gchar*
   * format_value_callback (GtkScale *scale,
   *                        gdouble   value)
   * {
   *   return g_strdup_printf ("--&gt;%0.*g&lt;--",
   *                           gtk_scale_get_digits (scale), value);
   * }
   * &lt;/programlisting&gt;&lt;/informalexample&gt;
   * &lt;/para&gt;
   * @param arg1 
   * @return The position in which the current value is displayed.
   * allocated string representing @value.
   */
  PositionType get_value_pos() const;

  
  /**
   * @par Prototype:
   * <tt>Glib::ustring %format_value(double value)</tt>
   */
  Glib::SignalProxy1<Glib::ustring,double> signal_format_value();


  Glib::PropertyProxy<int> property_digits();

  Glib::PropertyProxy<bool> property_draw_value();

  Glib::PropertyProxy<PositionType> property_value_pos();


protected:
  virtual int calc_digits_(double step);


};

/** 
 * The Gtk::VScale widget is used to allow the user to select a value using a
 * horizontal slider. See the Gtk::Scale documentation for more information
 * on how to use a Gtk::VScale.
 *
 * @ingroup Widgets
 */

class VScale : public Scale
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef VScale CppObjectType;
  typedef VScale_Class CppClassType;
  typedef GtkVScale BaseObjectType;
  typedef GtkVScaleClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~VScale();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class VScale_Class;
  static CppClassType vscale_class_;

  // noncopyable
  VScale(const VScale&);
  VScale& operator=(const VScale&);

protected:
  explicit VScale(const Glib::ConstructParams& construct_params);
  explicit VScale(GtkVScale* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkVScale*       gobj()       { return reinterpret_cast<GtkVScale*>(gobject_); }
  const GtkVScale* gobj() const { return reinterpret_cast<GtkVScale*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:
  VScale();
  VScale(double min, double max, double step);
  explicit VScale(Adjustment& adjustment);
  

};

/** 
 * The Gtk::HScale widget is used to allow the user to select a value using a
 * horizontal slider. See the Gtk::Scale documentation for more information
 * on how to use a Gtk::HScale.
 * 
 * @ingroup Widgets
 */

class HScale : public Scale
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef HScale CppObjectType;
  typedef HScale_Class CppClassType;
  typedef GtkHScale BaseObjectType;
  typedef GtkHScaleClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~HScale();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class HScale_Class;
  static CppClassType hscale_class_;

  // noncopyable
  HScale(const HScale&);
  HScale& operator=(const HScale&);

protected:
  explicit HScale(const Glib::ConstructParams& construct_params);
  explicit HScale(GtkHScale* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkHScale*       gobj()       { return reinterpret_cast<GtkHScale*>(gobject_); }
  const GtkHScale* gobj() const { return reinterpret_cast<GtkHScale*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:
  HScale();
  HScale(double min, double max, double step);
  explicit HScale(Adjustment& adjustment);
  

};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Scale */
  Gtk::Scale* wrap(GtkScale* object, bool take_copy = false);
}
namespace Glib
{
  /** @relates Gtk::VScale */
  Gtk::VScale* wrap(GtkVScale* object, bool take_copy = false);
}
namespace Glib
{
  /** @relates Gtk::HScale */
  Gtk::HScale* wrap(GtkHScale* object, bool take_copy = false);
}
#endif /* _GTKMM_SCALE_H */

