// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/object.h>
#include <gtkmm/private/object_p.h>

/* $Id: object.ccg,v 1.24 2002/06/08 21:57:57 daniel Exp $ */

/* Copyright 1998-1999 The gtkmm Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/quark.h>
#include <gtk/gtkobject.h>


namespace Gtk
{

Object::Object(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{
  referenced_ = true; // not managed
  gobject_disposed_ = false;

  if(gobject_)
  {
    g_object_ref(gobject_);
    gtk_object_sink((GtkObject*) gobject_);
  }
}

Object::Object(GtkObject* castitem)
:
  Glib::Object((GObject*) castitem)
{
  referenced_ = true; //Not managed.
  gobject_disposed_ = false;

  if(gobject_)
  {
    //Glib::Object::Object has already store a pointer to this C++ instance in the underlying C instance,
    //and connected a callback which will, in turn, call our destroy_notify_(),
    //so that we know when GTK+ disposes of the underlying instance.

    // GTK+ objects are floating, by default. This means that the container widget controls their lifetime.
    // We'll change this:
    g_object_ref(gobject_);  //Increase ref by 1 so that it doesn't get deleted when we sink() it.
    gtk_object_sink((GtkObject*)gobject_); //Stops it from being floating - we will make this optional ( see Gtk::manage() ),
  }
}

Object::~Object()
{
  cpp_destruction_in_progress_ = true;

  // remove our hook.
  GtkObject* object = gobj();
  if (object)
  {
    if (!gobject_disposed_) //We can't do anything with the gobject_ if it's already been disposed.
    {
      if (referenced_) //unref is meaningless for manage()ed (floating) objects.
      {
        g_object_unref(object);
      }

      if (!gobject_disposed_) //If the C instance still isn't dead.
      {
        gtk_object_destroy(object); //Container widgets can respond to this.
      }
    }

    disconnect_cpp_wrapper();
    //If we are killing the C++ instance before the C instance, then this might lead to strange behaviour.
    //If this is a problem, then you'll have to use a managed() object, which will die only upon GTK+'s request.

    //Glib::Object::~Object() will not g_object_unref()ing it too. because gobject_ is now 0.
  }
}

void Object::disconnect_cpp_wrapper()
{
  //Prevent gtk vfuncs and default signal handlers from calling our instance methods:
  g_object_steal_qdata((GObject*)gobj(), Glib::quark_); //It will no longer be possible to get the C++ instance from the C instance.

  //Prevent C++ instance from using GTK+ object:
  gobject_ = 0;

  //TODO: Disconnect any signals, using gtk methods.
  //We'll have to keep a record of all the connections.
}

void Object::destroy_notify_()
{
  //Overriden.

  //Remember that it's been disposed (which only happens once):
  //This also stops us from destroying it again in the destructor when it calls destroy_().
  gobject_disposed_ = true;

  if(!cpp_destruction_in_progress_) //This function might have been called as a side-effect of destroy() when it called gtk_object_destroy().
  {
    if (!referenced_) //If it's manage()ed.
    {
      delete this; //Free the C++ instance.
    }
    else  //It's not managed, but the C gobject_ just died before the C++ instance..
    {
      gobject_ = 0;
    }
  }
}

void Object::destroy_()
{
  //Called from destructors.

  if ( !cpp_destruction_in_progress_ ) //see comment below.
  {
    //Prevent destroy_notify_() from running as a possible side-effect of gtk_object_destroy.
    //We can't predict whether destroy_notify_() will really be run, so we'll disconnect the C++ instance here.
    cpp_destruction_in_progress_ = true;

    //Prevent our *_Class callbacks from accessing the now half-destroyed C++ instance.
    //For instance, even using dynamic_cast<> on the half-destroyed C++ instance could segfault.

    if(GtkObject* gobject = gobj()) //gobj() won't work after disconnect_cpp_wrapper().
    {
      disconnect_cpp_wrapper();

      //Tell the C instance to unref anything that it has.
      //This might call gtk_object_dispose, and therefore our destroy_notify_(). It might not,
      if(!gobject_disposed_) //Don't destroy it twice.
      {
        gtk_object_destroy(gobject); //cpp_destruction_in_progress prevents destroy_notify_() from deleting this
      }
    }
  }
}

// This should indicate that this was a C++ wrapper generated
// by the translating API and not directly.  
// It must:
//   remove the reference to the object so that object lifetime is not 
//     increased
void Object::set_manage() 
{
  if (!referenced_) return; //It's already managed.

  // tell libsigc that the object is disposable
  SigC::ObjectBase::set_manage();

  // remove our reference
  if (gobject_->ref_count == 1)
  {
    // Cowardly refuse to remove last reference make floating instead
    GTK_OBJECT_SET_FLAGS(gobj(), GTK_FLOATING);
  }
  else
  {
    g_object_unref(gobj());
  }

  referenced_ = false;
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Object* wrap(GtkObject* object, bool take_copy)
{
  return dynamic_cast<Gtk::Object *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Object_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Object_Class::class_init_function;

    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually necessary?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_object_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Object_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

}


Glib::ObjectBase* Object_Class::wrap_new(GObject* o)
{
  return manage(new Object((GtkObject*)(o)));
}


/* The implementation: */

Object::CppClassType Object::object_class_; // initialize static member

GType Object::get_type()
{
  return object_class_.init().get_type();
}

GType Object::get_base_type()
{
  return gtk_object_get_type();
}


Glib::PropertyProxy<void*> Object::property_user_data()
{
  return Glib::PropertyProxy<void*>(this, "user_data");
}


} // namespace Gtk


