// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_MENU_H
#define _GTKMM_MENU_H

#include <glibmm.h>

/* $Id: menu.hg,v 1.30 2002/07/13 21:43:25 murrayc Exp $ */

/* Copyright (C) 1998-2000 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtk/gtkmenu.h>
#include <gtkmm/menushell.h>
#include <gtkmm/menuitem.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkMenu GtkMenu;
typedef struct _GtkMenuClass GtkMenuClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Menu_Class; } // namespace Gtk
namespace Gtk
{

class AccelGroup;

/** @defgroup Menus Menu classes
 */

/** A drop-down menu consisting of Gtk::MenuItem objects which can be navigated and activated by the user to perform application functions.
 * Menus are normally placed inside a Gtk::MenuBar or another MenuItem as a sub menu.
 * A Menu can also be popped up, for instance as a right-click context menu, by calling the popup() method.
 * See also Gtk::OptionMenu.
 * @ingroup Widgets
 * @ingroup Menus
 */

class Menu : public MenuShell
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Menu CppObjectType;
  typedef Menu_Class CppClassType;
  typedef GtkMenu BaseObjectType;
  typedef GtkMenuClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Menu();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Menu_Class;
  static CppClassType menu_class_;

  // noncopyable
  Menu(const Menu&);
  Menu& operator=(const Menu&);

protected:
  explicit Menu(const Glib::ConstructParams& construct_params);
  explicit Menu(GtkMenu* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkMenu*       gobj()       { return reinterpret_cast<GtkMenu*>(gobject_); }
  const GtkMenu* gobj() const { return reinterpret_cast<GtkMenu*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:
  Menu();

/* append, prepend, and insert are defined in MenuShell */

  
  /** 
   * Displays a menu and makes it available for selection.  Applications can use
   * this function to display context-sensitive menus, and will typically supply
   * <tt>0</tt> for the @a parent_menu_shell, @a parent_menu_item, @a func and @a data 
   * parameters.  The default menu positioning function will position the menu
   * at the current pointer position.
   * 
   * @param parent_menu_shell The menu shell containing the triggering menu item.
   * @param parent_menu_item The menu item whose activation triggered the popup.
   * @param func A user supplied function used to position the menu.
   * @param data User supplied data to be passed to @a func.
   * @param button The button which was pressed to initiate the event.
   * @param activate_time The time at which the activation event occurred.
   */
  void popup(MenuShell& parent_menu_shell, MenuItem& parent_menu_item, GtkMenuPositionFunc func, gpointer data, guint button, guint32 activate_time);

  ///void on_menu_position(int&, int&, bool& push_in);
  typedef SigC::Slot3<void, int&, int&, bool&> SlotPositionCalc;

  /// Displays a menu and makes it available for selection.
  void popup(const SlotPositionCalc& position_calc_slot, guint button, guint32 activate_time);

  /** Displays a menu and makes it available for selection.
   * Applications can use this function to display context-sensitive menus.
   * The default menu positioning function will position the menu at the current pointer position.
   * @param window Use the accelerator group from this window.
   * @param button The button which was pressed to initiate the event.
   * @param activate_time The time at which the activation event occurred.
   */
  void popup(Gtk::Window& window, guint button, guint32 activate_time);

  
  /** 
   * Repositions the menu according to its position function.
   * 
   */
  void reposition();

  
  /** 
   * Removes the menu from the screen.
   * 
   */
  void popdown();

  
  /** 
   * Returns the selected menu item from the menu.  This is used by the 
   * Gtk::OptionMenu.
   * 
   * 
   * selection has not yet been made, the first menu item is selected.
   * @return The Gtk::MenuItem that was last selected in the menu.  If a.
   */
  MenuItem* get_active();
  
  /** 
   * Selects the specified menu item within the menu.  This is used by the
   * Gtk::OptionMenu and should not be used by anyone else.
   * 
   * 
   * 0 to n-1.
   * @param index The index of the menu item to select.  Index values are from.
   */
  void set_active(guint index);

  
  /** 
   * Set the Gtk::AccelGroup which holds global accelerators for the menu.
   * This accelerator group needs to also be added to all windows that
   * this menu is being used in with Gtk::Window::add_accel_group(), in order
   * for those windows to support all the accelerators contained in this group.
   * 
   * @param accel_group The Gtk::AccelGroup to be associated with the menu.
   */
  void set_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);
  void unset_accel_group();
  
  /** 
   * Gets the Gtk::AccelGroup which holds global accelerators for the menu.
   * See set_accel_group().
   * 
   * @return The Gtk::AccelGroup associated with the menu.
   */
  Glib::RefPtr<AccelGroup> get_accel_group();

  
  /** Sets an accelerator path for this menu from which accelerator paths
   * for its immediate children, its menu items, can be constructed.
   * The main purpose of this function is to spare the programmer the
   * inconvenience of having to call Gtk::MenuItem::set_accel_path() on
   * each menu item that should support runtime user changable accelerators.
   * Instead, by just calling set_accel_path() on their parent,
   * each menu item of this menu, that contains a label describing its purpose,
   * automatically gets an accel path assigned. For example, a menu containing
   * menu items "New" and "Exit", will, after 
   * <tt>gtk_menu_set_accel_path (menu, "&lt;Gnumeric-Sheet&gt;/File");</tt>
   * has been called, assign its items the accel paths:
   * <tt>"&lt;Gnumeric-Sheet&gt;/File/New"</tt> and <tt>"&lt;Gnumeric-Sheet&gt;/File/Exit"</tt>.
   * Assigning accel paths to menu items then enables the user to change
   * their accelerators at runtime. More details about accelerator paths
   * and their default setups can be found at gtk_accel_map_add_entry().
   * 
   * 
   * 
   * @param accel_path A valid accelerator path.
   */
  void set_accel_path(const Glib::ustring& accel_path);

  
  /** 
   * Detaches the menu from the widget to which it had been attached.  
   * This function will call the callback function, @a detacher, provided
   * when the attach_to_widget() function was called.
   * 
   */
  void detach();
  
  /** 
   * Returns the Gtk::Widget that the menu is attached to.
   * 
   * @return The Gtk::Widget that the menu is attached to.
   */
  Widget* get_attach_widget();

  
  /** 
   * Changes the tearoff state of the menu.  A menu is normally displayed 
   * as drop down menu which persists as long as the menu is active.  It can 
   * also be displayed as a tearoff menu which persists until it is closed 
   * or reattached.
   * 
   * @param torn_off If <tt>true</tt>, menu is displayed as a tearoff menu.
   */
  void set_tearoff_state(bool torn_off = true);
  
  /** Returns whether the menu is torn off. See
   * set_tearoff_state().
   * 
   * 
   * 
   * 
   * @return <tt>true</tt> if the menu is currently torn off.
   */
  bool get_tearoff_state() const;

  
  /** Sets the title string for the menu.  The title is displayed when the menu
   * is shown as a tearoff menu.
   * 
   * 
   * @param title A string containing the title for the menu.
   */
  void set_title(const Glib::ustring& title);
  void unset_title();
  
  /** Returns the title of the menu. See set_title().
   * 
   * 
   * 
   * 
   * @return The title of the menu, or <tt>0</tt> if the menu has no
   * title set on it.
   */
  Glib::ustring get_title() const;

  void reorder_child(const MenuItem& child, int position);

  Glib::PropertyProxy<Glib::ustring> property_tearoff_title();


protected:
  //- Attach the menu to a widget. {\var detacher} is a function which takes
  //- the attached GtkWidget* and GtkMenu*
  //- ({\b NOTE! NOT the Gtk::Widget and Gtk::Menu!})
  //- This is mostly used by other widgets like Gtk::MenuItem or
  //- Gtk::NoteBook. You probably don't need to care about it.
  
  /** 
   * Attaches the menu to the widget and provides a callback function that will
   * be invoked when the menu calls detach() during its destruction.
   * 
   * 
   * the menu calls detach().
   * @param attach_widget The Gtk::Widget that the menu will be attached to.
   * @param detacher The user supplied callback function that will be called when.
   */
  void attach_to_widget(Widget& widget, GtkMenuDetachFunc detacher);


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Menu */
  Gtk::Menu* wrap(GtkMenu* object, bool take_copy = false);
}
#endif /* _GTKMM_MENU_H */

