// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ALIGNMENT_H
#define _GTKMM_ALIGNMENT_H

#include <glibmm.h>

/* $Id: alignment.hg,v 1.16 2002/07/08 15:17:30 murrayc Exp $ */

/* alignment.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkAlignment GtkAlignment;
typedef struct _GtkAlignmentClass GtkAlignmentClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Alignment_Class; } // namespace Gtk
namespace Gtk
{

/** A widget which controls the alignment and size of its child.
 *
 * Normally, a widget is allocated at least as much size as it requests, and,
 * most widgets expand to fill any extra allocated space, but sometimes
 * this behavior is not desired. The alignment widget allows the
 * programmer to specify how a widget should expand and position itself
 * to fill the area it is allocated.
 *
 * It has four settings: xscale, yscale, xalign, and yalign:
 * The scale settings specify how much the child widget should expand to fill the space allocated to the Gtk::Alignment. The values can range from 0 (meaning the child doesn't expand at all) to 1 (meaning the child expands to fill all of the available space).
 * The align settings place the child widget within the available area. The values range from 0 (top or left) to 1 (bottom or right). Of course, if the scale settings are both set to 1, the alignment settings have no effect.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class Alignment : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Alignment CppObjectType;
  typedef Alignment_Class CppClassType;
  typedef GtkAlignment BaseObjectType;
  typedef GtkAlignmentClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Alignment();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Alignment_Class;
  static CppClassType alignment_class_;

  // noncopyable
  Alignment(const Alignment&);
  Alignment& operator=(const Alignment&);

protected:
  explicit Alignment(const Glib::ConstructParams& construct_params);
  explicit Alignment(GtkAlignment* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkAlignment*       gobj()       { return reinterpret_cast<GtkAlignment*>(gobject_); }
  const GtkAlignment* gobj() const { return reinterpret_cast<GtkAlignment*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  explicit Alignment(float xalign = 0.5, float yalign = 0.5,
		float xscale = 1.0, float yscale = 1.0);

  
  /** 
   * Sets the Gtk::Alignment values.
   * 
   * 
   * (right).
   * (bottom).
   * unused space, from 0 to 1.
   * A value of 0 indicates that the child widget should never expand.
   * A value of 1 indicates that the child widget will expand to fill all of the
   * space allocated for the Gtk::Alignment.
   * unused space, from 0 to 1. The values are similar to @a xscale.
   * 
   * 
   * &lt;!-- ##### ARG GtkAlignment:xalign ##### --&gt;
   * 
   * the horizontal alignment of the child widget, from 0 (left) to 1 (right).
   * 
   * 
   * &lt;!-- ##### ARG GtkAlignment:yalign ##### --&gt;
   * 
   * the vertical alignment of the child widget, from 0 (top) to 1 (bottom).
   * 
   * 
   * &lt;!-- ##### ARG GtkAlignment:xscale ##### --&gt;
   * 
   * the amount that the child widget expands horizontally to fill up
   * unused space, from 0 to 1.
   * A value of 0 indicates that the child widget should never expand.
   * A value of 1 indicates that the child widget will expand to fill all of the
   * space allocated for the Gtk::Alignment.
   * 
   * 
   * &lt;!-- ##### ARG GtkAlignment:yscale ##### --&gt;
   * 
   * the amount that the child widget expands vertically to fill up
   * unused space, from 0 to 1. The values are similar to @a xscale.
   * 
   * @param xalign The horizontal alignment of the child widget, from 0 (left) to 1.
   * @param yalign The vertical alignment of the child widget, from 0 (top) to 1.
   * @param xscale The amount that the child widget expands horizontally to fill up.
   * @param yscale The amount that the child widget expands vertically to fill up.
   */
  void set(float xalign = 0.5, float yalign = 0.5, float xscale = 1.0, float yscale=  1.0);

  Glib::PropertyProxy<float> property_xalign();

  Glib::PropertyProxy<float> property_yalign();

  Glib::PropertyProxy<float> property_xscale();

  Glib::PropertyProxy<float> property_yscale();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Alignment */
  Gtk::Alignment* wrap(GtkAlignment* object, bool take_copy = false);
}
#endif /* _GTKMM_ALIGNMENT_H */

