
#include <iostream>
#include <glibmm/random.h>
#include <glibmm/thread.h>
#include <glibmm/threadpool.h>
#include <glibmm/timer.h>


namespace
{

Glib::StaticMutex mutex = GLIBMM_STATIC_MUTEX_INIT;

void print_char(char c)
{
  Glib::Rand rand;

  for(int i = 0; i < 100; ++i)
  {
    {
      Glib::Mutex::Lock lock (mutex);
      std::cout << c;
    }
    Glib::usleep(rand.get_int_range(10000, 100000));
  }
}

}


int main(int argc, char** argv)
{
  Glib::thread_init();

  Glib::ThreadPool pool (10);

  for(char c = 'a'; c <= 'z'; ++c)
    pool.push(SigC::bind(SigC::slot(&print_char), c));

  pool.shutdown();

  std::cout << std::endl;

  return 0;
}

