// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_WINDOW_H
#define _GTKMM_WINDOW_H

#include <glibmm.h>

/* $Id: window.hg,v 1.47 2002/04/16 13:01:53 murrayc Exp $ */

/* window.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/listhandle.h>
#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkWindow GtkWindow;
typedef struct _GtkWindowClass GtkWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Window_Class; } // namespace Gtk
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkWindowGroup GtkWindowGroup;
typedef struct _GtkWindowGroupClass GtkWindowGroupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class WindowGroup_Class; } // namespace Gtk
namespace Gtk
{

class AccelGroup;
class WindowGroup;


/** Toplevel Window
 * This represents all widgets which are physical windows controlled
 * by the window manager.  Windows have a hidden reference controlled
 * by the gtkmm kit.
 *
 * Windows which are told to manage() do not deleted until they are
 * sent the destroy signal.
 * @ingroup Widgets
 */

class Window : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GtkWindow BaseObjectType;
  typedef GtkWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Window();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class Window_Class;
  static CppClassType window_class_;

  Window(const Window&);
  Window& operator=(const Window&); // not implemented

protected:
  explicit Window(GtkWindow* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkWindow* gobj()             { return (GtkWindow*)(gobject_); }
  const GtkWindow* gobj() const { return (GtkWindow*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_focus(Widget* focus);
  virtual bool on_frame_event(GdkEvent* event);
  virtual void on_activate_focus();
  virtual void on_activate_default();
  virtual void on_move_focus(DirectionType direction);


private:

  
public:
  explicit Window(WindowType type = WINDOW_TOPLEVEL);

  Glib::PropertyProxy<Glib::ustring> property_title();

  Glib::PropertyProxy<bool> property_allow_shrink();

  Glib::PropertyProxy<bool> property_allow_grow();

  Glib::PropertyProxy<bool> property_resizable();

  Glib::PropertyProxy<bool> property_modal();

  Glib::PropertyProxy<WindowPosition> property_window_position();

  Glib::PropertyProxy<int> property_default_width();

  Glib::PropertyProxy<int> property_default_height();

  Glib::PropertyProxy<bool> property_destroy_with_parent();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_icon();


  bool is_toplevel() const;
  bool is_dialog() const;
  bool is_popup() const;

  WindowType get_window_type() const;

  //: This is special to the GTK+ linux-fb port.
  Glib::RefPtr<Gdk::Window> get_frame();
  Glib::RefPtr<const Gdk::Window> get_frame() const;


  /**
   * @par Prototype:
   * <tt>void %set_focus(Widget* focus)</tt>
   */
  Glib::SignalProxy1<void,Widget*> signal_set_focus();

  
  /**
   * @par Prototype:
   * <tt>bool %frame_event(GdkEvent* event)</tt>
   */
  Glib::SignalProxy1<bool,GdkEvent*> signal_frame_event();


  //: Actions for keybindings.
  
  /**
   * @par Prototype:
   * <tt>void %activate_focus()</tt>
   */
  Glib::SignalProxy0<void> signal_activate_focus();

  
  /**
   * @par Prototype:
   * <tt>void %activate_default()</tt>
   */
  Glib::SignalProxy0<void> signal_activate_default();

  
  /**
   * @par Prototype:
   * <tt>void %move_focus(DirectionType direction)</tt>
   */
  Glib::SignalProxy1<void,DirectionType> signal_move_focus();


  //: Sets the title of the window.
  //- The title of a window will be displayed in its title bar; on the
  //- X Window System, the title bar is rendered by the window manager, so
  //- exactly how the title appears to users may vary according to a user's
  //- exact configuration. The title should help a user distinguish this
  //- window from other windows they may have open. A good title might include
  //- the application name and current document filename, for example.
  
  void set_title(const Glib::ustring& title);

  //: Retrieves the title of the window.
  //- See {set_title()}.
  
  Glib::ustring get_title() const;

  //: Set the window manager class and name hints.
  //- Don't use this function. It sets the X Window System "class" and
  //- "name" hints for a window.  According to the ICCCM, you should
  //- always set these to the same value for all windows in an
  //- application, and GTK sets them to that value by default, so calling
  //- this function is sort of pointless. However, you may want to call
  //- {set_role()} on each window in your application, for the
  //- benefit of the session manager. Setting the role allows the window
  //- manager to restore window positions when loading a saved session.
  
  void set_wmclass(const Glib::ustring& wmclass_name,
                                const Glib::ustring& wmclass_class);

  //: Sets the role of the window.
  //- In combination with the window title, the window role allows a
  //- window manager to identify "the same" window when an application is
  //- restarted. So for example you might set the "toolbox" role on your
  //- app's toolbox window, so that when the user restarts their session,
  //- the window manager can put the toolbox back in the same place.
  //-
  //- If a window already has a unique title, you don't need to set the
  //- role, since the WM can use the title to identify the window when
  //- restoring the session.
  
  void set_role(const Glib::ustring& role);

  //: Returns the role of the window.
  //- See {set_role()} for further explanation.
  
  Glib::ustring get_role() const;


  void add_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  void remove_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  void set_position(WindowPosition position);

  
  bool activate_focus();
  
  void set_focus(Gtk::Widget& focus);
  
  Widget* get_focus();
  
  void set_default(Gtk::Widget& defaultw);
  
  bool activate_default();


  //: Sets the transient parent of the window.
  //- Dialog windows should be set transient for the main application window
  //- they were spawned from. This allows window managers to e.g. keep the
  //- dialog on top of the main window, or center the dialog over the main
  //- window.
  
  void set_transient_for(Window& parent);

  //: Fetches the transient parent for this window.
  //- See {set_transient_for()}.
  
  Window* get_transient_for();

  //: Set the type hint for the window.
  //- By setting the type hint for the window, you allow the window manager
  //- to decorate and handle the window in a way which is suitable to the
  //- function of the window in your application.
  //-
  //- This function should be called before the window becomes visible.
  
  void set_type_hint(Gdk::WindowTypeHint hint);

  //: Gets the type hint for this window.
  //- See {set_type_hint()}.
  
  Gdk::WindowTypeHint get_type_hint() const;

  //: Sets whether the window should be destroyed with its transient parent.
  //- If {setting} is {true}, then destroying the transient parent of this
  //- window will also destroy this window itself. This is useful for dialogs
  //- that shouldn't persist beyond the lifetime of the main window they're
  //- associated with, for example.
  //_WRAP_METHOD(void set_destroy_with_parent(bool setting = true), gtk_window_set_destroy_with_parent)
  // I don't that that this is ever a good thing for C++.murrayc.

  //: Returns whether the window will be destroyed with its transient parent.
  //- See {set_destroy_with_parent()}.
  
  bool get_destroy_with_parent() const;
  // I don't that that this is ever a good thing for C++.murrayc.

  //: Sets whether the user can resize a window.
  //- Windows are user resizable by default.
  
  void set_resizable(bool resizeable = true);

  //: Gets the value set by {set_resizable()}.
  
  bool get_resizable() const;

  //: Sets the window gravity.
  //- Window gravity defines the meaning of coordinates passed to {move()}.
  //- See {move()} and {Gdk::Gravity} for more details.
  //-
  //- The default window gravity is {/enum GDK_GRAVITY_NORTH_WEST} which
  //- will typically "do what you mean."
  
  void set_gravity(Gdk::Gravity gravity);

  //: Gets the value set by {set_gravity()}.
  
  Gdk::Gravity get_gravity() const;

  //: Sets geometry hints of the window.
  //- This function sets up hints about how a window can be resized by
  //- the user.  You can set a minimum and maximum size; allowed resize
  //- increments (e.g. for xterm, you can only resize by the size of a
  //- character); aspect ratios; and more. See {Gdk::Geometry}.
  //-
  //- Parameters:
  //-
  //- {geometry_widget}: widget the geometry hints will be applied to.
  //- {geometry}: object containing geometry information.
  //- {geom_mask}: mask indicating which struct fields should be paid
  //- attention to.
  
  void set_geometry_hints(Widget& geometry_widget,
                                       const Gdk::Geometry& geometry,
                                       Gdk::WindowHints geom_mask);

  //: Sets wether the window should have a frame window exterior.
  //- (Note: this is a special-purpose function for the framebuffer port,
  //- that causes GTK+ to draw its own window border. For most applications,
  //- you want {set_decorated()} instead, which tells the window manager
  //- whether to draw the window border.)
  //-
  //- If this function is called on a window with setting of {true}, before
  //- it is realized or showed, it will have a "frame" window around
  //- FIXME widget->window, accessible in FIXME window->frame. Using the
  //- signal FIXME frame_event you can recieve all events targeted at the
  //- frame.
  //-
  //- This function is used by the linux-fb port to implement managed
  //- windows, but it could concievably be used by X-programs that want
  //- to do their own window decorations.
  
  void set_has_frame(bool setting = true);

  //: Returns whether the window has a frame window exterior.
  //- Gets the value set by {set_has_frame()}.
  
  bool get_has_frame() const;

  //: Sets the dimensions of the frame window exterior.
  //- (Note: this is a special-purpose function intended for the framebuffer
  //- port; see {set_has_frame()}. It will have no effect on the window
  //- border drawn by the window manager, which is the normal case when using
  //- the X Window system.)
  //-
  //- For windows with frames (see {set_has_frame()}) this function can
  //- be used to change the size of the frame border.
  
  void set_frame_dimensions(int left,  int top,
                                         int right, int bottom);

  
  void get_frame_dimensions(int& left,  int& top,
                                         int& right, int& bottom) const;

  
  void set_decorated(bool setting = true);

  
  bool get_decorated() const;


  Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > get_icon_list() const;

  
  void set_icon_list(const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list);

  
  void set_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon);

  
  Glib::RefPtr<Gdk::Pixbuf> get_icon() const;

  
  static void set_default_icon_list(
                   const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list);

  
  static Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > get_default_icon_list();


  void set_modal(bool modal = true);

  
  bool get_modal() const;


  static Glib::ListHandle<Window*> list_toplevels();


  void add_mnemonic(guint keyval, Widget& target);

  
  void remove_mnemonic(guint keyval, Widget& target);

  
  bool mnemonic_activate(guint keyval, Gdk::ModifierType modifier);

  
  void set_mnemonic_modifier(Gdk::ModifierType modifier);

  
  Gdk::ModifierType get_mnemonic_modifier();


  void present();

  
  void iconify();
  
  void deiconify();

  
  void stick();
  
  void unstick();

  
  void maximize();
  
  void unmaximize();


  void begin_resize_drag(Gdk::WindowEdge edge,
                   int button, int root_x, int root_y, guint32 timestamp);

  
  void begin_move_drag(
                   int button, int root_x, int root_y, guint32 timestamp);

  
  void set_default_size(int width, int height);

  
  void get_default_size(int& width, int& height) const;

  
  void resize(int width, int height);

  
  void get_size(int& width, int& height) const;


  void move(int x, int y);

  
  void get_position(int& root_x, int& root_y) const;

  
  bool parse_geometry(const Glib::ustring& geometry);

  //: Ignore this unless you are writing a GUI builder.
  
  void reshow_with_initial_size();

  /** returns a default accel group for this window
   * This is a gtkmm-specific function.  This accel group can not
   * be removed.
   */
  Glib::RefPtr<AccelGroup> get_accel_group();

  /** Brings the window to the front.
   * This is just a more obvious convenience wrapper for get_window()->raise().
   */
  virtual void raise();

private:

  //We'll create an accel_group if it's requested, and remember it.
  //Otherwise, you'd have to create it, add it to the window, then remember it somewhere else while you add it to other widgets.
  Glib::RefPtr<AccelGroup> accel_group_;


};


class WindowGroup : public Glib::Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef WindowGroup          CppObjectType;
  typedef WindowGroup_Class    CppClassType;
  typedef GtkWindowGroup           BaseObjectType;
  typedef GtkWindowGroupClass      BaseClassType;

private:
  friend class WindowGroup_Class;
  static CppClassType windowgroup_class_;

  WindowGroup(const WindowGroup&);
  WindowGroup& operator=(const WindowGroup&); // not implemented

protected:
  explicit WindowGroup(GtkWindowGroup* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~WindowGroup();

  static Glib::RefPtr<WindowGroup> wrap_specific_type(GtkWindowGroup* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkWindowGroup* gobj()             { return (GtkWindowGroup*)(gobject_); }
  const GtkWindowGroup* gobj() const { return (GtkWindowGroup*)(gobject_); }

  GtkWindowGroup* gobj_copy();


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:


public:
  WindowGroup();

  
  void add_window(Window& window);
  
  void remove_window(Window& window);


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Window */
  Gtk::Window* wrap(GtkWindow* object, bool take_copy = false);
}

namespace Glib
{
  /** @relates Gtk::WindowGroup */
  Glib::RefPtr<Gtk::WindowGroup> wrap(GtkWindowGroup* object, bool take_copy = false);
}


#endif /* _GTKMM_WINDOW_H */

