
#include <gtkmm/liststore.h>
#include <gtkmm/private/liststore_p.h>

// -*- c++ -*-
/* $Id: liststore.ccg,v 1.14 2002/05/09 14:09:59 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/textmark.h>
#include <glibmm/value.h>
#include <gtk/gtkliststore.h>

namespace Gtk
{

ListStore::ListStore(const TreeModelColumnRecord& columns)
:
  Glib::Object((GObject*) g_object_new(get_type(), (char*)0))
{
  gtk_list_store_set_column_types(gobj(), columns.size(), const_cast<GType*>(columns.types()));
}

TreeModel::iterator ListStore::erase(const iterator& iter)
{
  g_assert(iter.get_gobject_if_not_end() != 0);

  iterator next (iter);
  ++next;

  GtkTreeIter tmp = *iter.gobj();
  gtk_list_store_remove(gobj(), &tmp);

  return next;
}

TreeModel::iterator ListStore::insert(const iterator& iter)
{
  iterator new_pos (this);

  gtk_list_store_insert_before(
      gobj(), new_pos.gobj(),
      const_cast<GtkTreeIter*>(iter.get_gobject_if_not_end())); //TODO: What does get_gobject_if_not_end() do?

  if(new_pos.gobj()->stamp == 0) //TODO: What does stamp == 0 mean?
    new_pos.setup_end_iterator(iter); //TODO: What does setup_end_iterator() do?

  return new_pos;
}

TreeModel::iterator ListStore::prepend()
{
  iterator new_pos (this);
  gtk_list_store_prepend(gobj(), new_pos.gobj());
  return new_pos;
}

TreeModel::iterator ListStore::append()
{
  iterator new_pos(this);
  gtk_list_store_append(gobj(), new_pos.gobj());
  return new_pos;
}

void ListStore::set_value_impl(const iterator& row, const TreeModelColumnBase& column,
                               const Glib::ValueBase& value)
{
  gtk_list_store_set_value(
      gobj(), const_cast<GtkTreeIter*>(row.gobj()),
      column.index(), const_cast<GValue*>(value.gobj()));
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::ListStore> wrap(GtkListStore* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::ListStore>( dynamic_cast<Gtk::ListStore*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType ListStore_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_list_store_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  TreeModel::add_interface(get_type());
  TreeSortable::add_interface(get_type());
  TreeDragSource::add_interface(get_type());
  TreeDragDest::add_interface(get_type());
  }

  return gtype_;
}

void ListStore_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* ListStore_Class::wrap_new(GObject* o)
{
  return new ListStore((GtkListStore*)(o));
}


/* The implementation: */

GtkListStore* ListStore::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<ListStore> ListStore::wrap_specific_type(GtkListStore* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<ListStore> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    ListStore* pCppObject = dynamic_cast<ListStore*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<ListStore>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<ListStore>( new ListStore(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

ListStore::ListStore(GtkListStore* castitem)
: Glib::Object((GObject*)(castitem))
{}

ListStore::~ListStore()
{
}

ListStore::CppClassType ListStore::liststore_class_; //Initialize static member.

GType ListStore::get_type()
{
  return liststore_class_.get_type();
}

GType ListStore::get_base_type()
{
  return gtk_list_store_get_type();
}

Glib::RefPtr<ListStore> ListStore::create(const TreeModelColumnRecord& columns)
{
  return Glib::RefPtr<ListStore>( new ListStore(columns) );
}
void ListStore::clear()
{
  gtk_list_store_clear(gobj());
}


} // namespace Gtk

