#include <iostream>
#include <cstdio>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/main.h>
#include <gtkmm/label.h>
#include <gtkmm/separator.h>
#include <gtkmm/window.h>

using std::cerr;
using std::endl;

// Gtk-- version of the "packbox" example from the gtk+ tutorial


class PackBox : public Gtk::HBox
{
public:
  PackBox(bool homogeneous, int spacing, Gtk::AttachOptions, int padding = 0);
  virtual ~PackBox() { delete m_button6; }

  Gtk::Button m_button1, m_button2, m_button3, m_button4, m_button5,
    *m_button6;
  char padstr[80];
};

PackBox::PackBox(bool homogeneous, int spacing, Gtk::AttachOptions options, int padding) :
  Gtk::HBox(homogeneous, spacing),
  m_button1("gtk_box_pack"),
  m_button2("(box,"),
  m_button3("button,"),
  m_button4( ((options & Gtk::EXPAND) == Gtk::EXPAND) ? "true," : "false,"),
  m_button5( ((options & Gtk::FILL) == Gtk::FILL) ? "true," : "false,")
{
  pack_start(m_button1, options, padding);
  pack_start(m_button2, options, padding);
  pack_start(m_button3, options, padding);
  pack_start(m_button4, options, padding);
  pack_start(m_button5, options, padding);

  sprintf(padstr, "%d);", padding);
  
  m_button6 = new Gtk::Button(padstr);
  pack_start(*m_button6, options, padding);
}

  

class PackBoxDemo : public Gtk::Window
{
public:
  Gtk::Button m_button;
  Gtk::VBox m_box1;
  Gtk::HBox m_boxQuit;
  Gtk::Button m_buttonQuit;
  
  Gtk::HSeparator m_seperator1, m_seperator2, m_seperator3, m_seperator4, m_seperator5;
  
  PackBoxDemo(int which);
  ~PackBoxDemo();
};

PackBoxDemo::PackBoxDemo(int which) :
  m_box1(false, 0),
  m_boxQuit(false, 0),
  m_buttonQuit("Quit")
{
  Gtk::Label *m_label1, *m_label2;
  PackBox *m_packbox1, *m_packbox2, *m_packbox3,
    *m_packbox4, *m_packbox5;

  switch(which) {
  case 1:
    // create a new label.
    m_label1 = manage(new Gtk::Label("hbox(false, 0);"));

    // Align the label to the left side.  We'll discuss this function and 
    // others in the section on Widget Attributes. 
    m_label1->set_alignment(0, 0);
    
    // Pack the label into the vertical box (vbox box1).  Remember that 
    // widgets added to a vbox will be packed one on top of the other in
    // order. 
    m_box1.pack_start(*m_label1, Gtk::SHRINK);

    // Create a PackBox - homogeneous = false, spacing = 0,
    // expand = false, fill = false, padding = 0 
    m_packbox1 = manage(new PackBox(false, 0, Gtk::SHRINK));
    m_box1.pack_start(*m_packbox1, Gtk::SHRINK);

    // Create a PackBox - homogeneous = false, spacing = 0,
    // expand = true, fill = false, padding = 0 
    m_packbox2 = manage(new PackBox(false, 0, Gtk::FILL));
    m_box1.pack_start(*m_packbox2, Gtk::SHRINK);

    // Create a PackBox - homogeneous = false, spacing = 0,
    // expand = true, fill = true, padding = 0 
    m_packbox3 = manage(new PackBox(false, 0, Gtk::EXPAND | Gtk::FILL));
    m_box1.pack_start(*m_packbox3, Gtk::SHRINK);
    
    // pack the separator into the vbox.  Remember each of these
    // widgets are being packed into a vbox, so they'll be stacked
    // vertically. 
    m_box1.pack_start(m_seperator1, Gtk::FILL, 5);
    
    // create another new label, and show it.
    m_label2 = manage(new Gtk::Label("hbox(true, 0);"));
    m_label2->set_alignment(0, 0);
    m_box1.pack_start(*m_label2, Gtk::SHRINK);
    
    // Args are: homogeneous, spacing, expand, fill, padding
    m_packbox4 = manage(new PackBox(true, 0, Gtk::EXPAND));
    m_box1.pack_start(*m_packbox4, Gtk::SHRINK);

    // Args are: homogeneous, spacing, expand, fill, padding
    m_packbox5 = manage(new PackBox(true, 0, Gtk::EXPAND));
    m_box1.pack_start(*m_packbox5, Gtk::SHRINK);

    m_box1.pack_start(m_seperator2, Gtk::FILL, 5);
    
    break;
    
  case 2:

    m_label1 = manage(new Gtk::Label("hbox(false, 10);"));
    m_label1->set_alignment(0, 0);
    m_box1.pack_start(*m_label1, Gtk::SHRINK);

    m_packbox1 = manage(new PackBox(false, 10, Gtk::EXPAND));
    m_box1.pack_start(*m_packbox1, Gtk::SHRINK);
    
    m_packbox2 = manage(new PackBox(false, 10, Gtk::EXPAND | Gtk::FILL));
    m_box1.pack_start(*m_packbox2, Gtk::SHRINK);

    m_box1.pack_start(m_seperator1, Gtk::FILL, 5);


    m_label2 = manage(new Gtk::Label("hbox(false, 10);"));
    m_label2->set_alignment(0, 0);
    m_box1.pack_start(*m_label2, Gtk::SHRINK);

    m_packbox3 = manage(new PackBox(false, 0, Gtk::FILL, 10));
    m_box1.pack_start(*m_packbox3, Gtk::SHRINK);
    
    m_packbox4 = manage(new PackBox(false, 0, Gtk::EXPAND | Gtk::FILL, 10));
    m_box1.pack_start(*m_packbox4, Gtk::SHRINK);

    m_box1.pack_start(m_seperator2, Gtk::FILL, 5);

    break;
    
  case 3:

    // This demonstrates the ability to use Gtk::Box::pack_end() to
    // right justify widgets.  First, we create a new box as before. 
    m_packbox1 = manage(new PackBox(false, 0, Gtk::SHRINK));
    // create the label that will be put at the end. 
    m_label1 = manage(new Gtk::Label("end"));
    // pack it using pack_end(), so it is put on the right side
    // of the PackBox. 
    m_packbox1->pack_end(*m_label1, Gtk::SHRINK);
    
    m_box1.pack_start(*m_packbox1, Gtk::SHRINK);
    
    // this explicitly sets the separator to 400 pixels wide by 5 pixels
    // high.  This is so the hbox we created will also be 400 pixels wide,
    // and the "end" label will be separated from the other labels in the
    // hbox.  Otherwise, all the widgets in the hbox would be packed as
    // close together as possible. 
    m_seperator1.set_size_request(400, 5);
    
    // pack the separator into ourselves 
    m_box1.pack_start(m_seperator1, Gtk::FILL, 5);
  }
  
  // setup the signal to destroy the window.  Remember that this will send
  // the "destroy" signal to the window which will be caught by our signal
  // handler as defined above. 
  m_buttonQuit.signal_clicked().connect(SigC::slot(&Gtk::Main::quit));

  // pack the button into the quitbox.
  // The last 3 arguments to gtk_box_pack_start are: expand, fill, padding. 
  m_boxQuit.pack_start(m_buttonQuit, Gtk::EXPAND);
  m_box1.pack_start(m_boxQuit, Gtk::SHRINK);
  
  // pack the vbox (box1) which now contains all our widgets, into the
  // main window. 
  add(m_box1);

  show_all();
  
}

PackBoxDemo::~PackBoxDemo()
{}


int main (int argc, char *argv[])
{
          
  // all GTK applications must have a gtk_main(). Control ends here
  // and waits for an event to occur (like a key press or mouse event).
  Gtk::Main myapp(&argc, &argv);

  if (argc != 2) {
    cerr << "usage: packbox num, where num is 1, 2, or 3." << endl;
    // this just does cleanup in GTK, and exits with an exit status of 1. 
    gtk_exit (1);
  }

  PackBoxDemo packboxdemo(atoi(argv[1]));

  myapp.run(packboxdemo);
  return 0;
}
