// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_DRAWABLE_H
#define _GDKMM_DRAWABLE_H

#include <glibmm.h>

/* $Id: drawable.hg,v 1.23 2002/04/21 23:40:14 murrayc Exp $ */

/* drawable.h
 *
 * Copyright (C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gdk/gdkdrawable.h>
#include <gdk/gdkrgb.h>
#include <gdkmm/gc.h>
#include <gdkmm/image.h>
//#include <gdkmm/font.h>
#include <gdkmm/color.h>
#include <gdkmm/region.h>
#include <gdkmm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkDrawable GdkDrawable;
typedef struct _GdkDrawableClass GdkDrawableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Drawable_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum RgbDither
{
  RGB_DITHER_NONE,
  RGB_DITHER_NORMAL,
  RGB_DITHER_MAX
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::RgbDither> : public Glib::Value_Enum<Gdk::RgbDither>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


//: Gdk Drawable handle.
//- A drawable is a base class for all of the objects that accept
//- drawing commands.  The available drawables include pixmaps,
//- windows, and bitmaps.  Drawable is an abstract as
//- there is no such type on the server side.
//-
//- To use a drawable, create a concrete drawable of the type you
//- wish to use and a GC (graphics context) for that drawable.
//- With the GC you can draw lines, strings, arcs and such.
//-

class Drawable : public Glib::Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Drawable          CppObjectType;
  typedef Drawable_Class    CppClassType;
  typedef GdkDrawable           BaseObjectType;
  typedef GdkDrawableClass      BaseClassType;

private:
  friend class Drawable_Class;
  static CppClassType drawable_class_;

  Drawable(const Drawable&);
  Drawable& operator=(const Drawable&); // not implemented

protected:
  explicit Drawable(GdkDrawable* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Drawable();

  static Glib::RefPtr<Drawable> wrap_specific_type(GdkDrawable* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GdkDrawable* gobj()             { return (GdkDrawable*)(gobject_); }
  const GdkDrawable* gobj() const { return (GdkDrawable*)(gobject_); }

  GdkDrawable* gobj_copy();


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
protected:

  Drawable();

public:
  
  static Glib::RefPtr<Drawable> create();


  void get_size(int& width, int& height);
  
  void set_colormap(const Glib::RefPtr<Colormap>& colormap);
  
  Glib::RefPtr<Colormap> get_colormap();
  
  Glib::RefPtr<Visual> get_visual();
  
  int get_depth();

  
  void draw_point(const Glib::RefPtr<GC>& gc, int x, int y);
  
  void draw_line(const Glib::RefPtr<GC>& gc, int x1, int y1, int x2, int y2);
  
  void draw_rectangle(const Glib::RefPtr<GC>& gc, int filled, int x, int y, int width, int height);
  
  void draw_arc(const Glib::RefPtr<GC>& gc, int filled, int x, int y, int width, int height, int angle1, int angle2);
  
  void draw_polygon(const Glib::RefPtr<GC>& gc, int filled, GdkPoint* points, int npoints);
  //_WRAP_METHOD(void draw_string(Font& font, const Glib::RefPtr<GC>& gc, int x, int y, const Glib::ustring& string), gdk_draw_string)
  //_WRAP_METHOD(void draw_text(Font& font, const Glib::RefPtr<GC>& gc, int x, int y, const Glib::ustring& text, int text_length), gdk_draw_text)
  //_WRAP_METHOD(void draw_text_wc(Font& font, const Glib::RefPtr<GC>& gc, int x, int y, const GdkWChar* text, int text_length), gdk_draw_text_wc)
  
  void draw_drawable(const Glib::RefPtr<GC>& gc, const Glib::RefPtr<Drawable>& src, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
  
  void draw_image(const Glib::RefPtr<GC>& gc, const Glib::RefPtr<Image>& image, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
  
  void draw_points(const Glib::RefPtr<GC>& gc, GdkPoint* points, int npoints);
  
  void draw_segments(const Glib::RefPtr<GC>& gc, GdkSegment* segs, int nsegs);
  
  void draw_lines(const Glib::RefPtr<GC>& gc, GdkPoint* points, int npoints);
  
  void draw_glyphs(const Glib::RefPtr<GC>& gc, PangoFont* font, int x, int y, PangoGlyphString *glyphs);
  
  void draw_layout_line(const Glib::RefPtr<GC>& gc, int x, int y, PangoLayoutLine* line);
  
  void draw_layout(const Glib::RefPtr<GC>& gc, int x, int y, PangoLayout* layout);
  
  void draw_layout_line_with_colors (const Glib::RefPtr<GC>& gc, int x, int y, PangoLayoutLine *line, const Color& foreground, const Color& background);
  
  void draw_layout_with_colors(const Glib::RefPtr<GC>& gc, int x, int y, PangoLayout* layout, const Color& foreground, const Color& background);

  
  Glib::RefPtr<Image> get_image(int x, int y, int width, int height);
  
  Region get_clip_region();
  
  Region get_visible_region();


  // **** RGB stuff ****

  
  void draw_rgb_image(
                   const Glib::RefPtr<Gdk::GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride);

  
  void draw_rgb_image_dithalign(
                   const Glib::RefPtr<Gdk::GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride,
                   int xdith, int ydith);

  
  void draw_rgb_32_image(
                   const Glib::RefPtr<Gdk::GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride);

  
  void draw_rgb_32_image_dithalign(
                   const Glib::RefPtr<Gdk::GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride,
                   int xdith, int ydith);

  
  void draw_gray_image(
                   const Glib::RefPtr<Gdk::GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride);

  
  void draw_indexed_image(
                   const Glib::RefPtr<Gdk::GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride,
                   GdkRgbCmap& cmap);


};

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::Drawable */
  Glib::RefPtr<Gdk::Drawable> wrap(GdkDrawable* object, bool take_copy = false);
}


#endif /* _GDKMM_DRAWABLE_H */

