// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTVIEW_H
#define _GTKMM_TEXTVIEW_H

#include <glibmm.h>

/* $Id: textview.hg,v 1.19 2002/04/16 13:01:53 murrayc Exp $ */


/* textview.h
 *
 * Copyright(C) 2001 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/textbuffer.h>
#include <gtkmm/textmark.h>
#include <gtkmm/menu.h>
#include <gtkmm/adjustment.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextView GtkTextView;
typedef struct _GtkTextViewClass GtkTextViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TextView_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TextWindowType
{
  TEXT_WINDOW_PRIVATE,
  TEXT_WINDOW_WIDGET,
  TEXT_WINDOW_TEXT,
  TEXT_WINDOW_LEFT,
  TEXT_WINDOW_RIGHT,
  TEXT_WINDOW_TOP,
  TEXT_WINDOW_BOTTOM
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextWindowType> : public Glib::Value_Enum<Gtk::TextWindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @ingroup Widgets
 * @ingroup Containers
 */

class TextView : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TextView CppObjectType;
  typedef TextView_Class CppClassType;
  typedef GtkTextView BaseObjectType;
  typedef GtkTextViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TextView();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class TextView_Class;
  static CppClassType textview_class_;

  TextView(const TextView&);
  TextView& operator=(const TextView&); // not implemented

protected:
  explicit TextView(GtkTextView* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTextView* gobj()             { return (GtkTextView*)(gobject_); }
  const GtkTextView* gobj() const { return (GtkTextView*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment);
  virtual void on_populate_popup(Menu* menu);
  virtual void on_move_cursor(MovementStep step, int count, bool extend_selection);
  virtual void on_page_horizontally(int count, bool extend_selection);
  virtual void on_set_anchor();
  virtual void on_insert_at_cursor(const Glib::ustring& str);
  virtual void on_delete_from_cursor(DeleteType type, int count);
  virtual void on_cut_clipboard();
  virtual void on_copy_clipboard();
  virtual void on_paste_clipboard();
  virtual void on_toggle_overwrite();
  virtual void on_move_focus(DirectionType direction);


private:

public:
  TextView();
  explicit TextView(const Glib::RefPtr<TextBuffer>& buffer);
  

  void set_buffer(const Glib::RefPtr<TextBuffer>& buffer);
  
  Glib::RefPtr<TextBuffer> get_buffer();
  
  bool scroll_to_iter(TextIter& iter, double within_margin, bool use_align,
                                                    double xalign, double yalign);
  
  void scroll_to_mark(const Glib::RefPtr<TextMark>&mark,
                                                    double within_margin,
                                                    bool use_align,
                                                    double xalign,
                                                    double yalign);
  
  void scroll_mark_onscreen(const Glib::RefPtr<TextMark>& mark);
  
  bool move_mark_onscreen(const Glib::RefPtr<TextMark>& mark);
  
  bool place_cursor_onscreen();

  
  void get_visible_rect(Gdk::Rectangle& visible_rect);
  
  void set_cursor_visible(bool setting = true);
  
  bool get_cursor_visible();

  
  void get_iter_location(const TextIter&  iter,
                                                    Gdk::Rectangle& location);
  
  void get_iter_at_location(TextIter& iter, int x, int y);
  
  void get_line_yrange(const TextIter&  iter,
                                                   int& y, int& height);

  
  void get_line_at_y(TextIter&  target_iter, int y, int& line_top);

  
  void buffer_to_window_coords(TextWindowType  win,
                                            int buffer_x, int buffer_y,
                                            int& window_x, int& window_y);
  
  void window_to_buffer_coords(TextWindowType  win,
                                            int window_x, int window_y,
                                            int& buffer_x, int& buffer_y);

  
  Glib::RefPtr<Gdk::Window> get_window(TextWindowType win);
  
  TextWindowType get_window_type(const Glib::RefPtr<Gdk::Window>& window);

  
  void set_border_window_size(TextWindowType  type, int size);
  
  int get_border_window_size(TextWindowType type);

  
  bool forward_display_line(TextIter& iter);
  
  bool backward_display_line(TextIter& iter);
  
  bool forward_display_line_end(TextIter& iter);
  
  bool backward_display_line_start(TextIter& iter);
  
  bool starts_display_line(const TextIter&  iter);
  
  bool move_visually(TextIter& iter, int count);

/* Adding child widgets */
  
  void add_child_at_anchor(Widget& child, const Glib::RefPtr<TextChildAnchor>& anchor);

  
  void add_child_in_window(Widget& child, TextWindowType which_window,
                                        int xpos, int ypos);

  
  void move_child(Widget& child, int xpos,int ypos);

/* Default style settings(fallbacks if no tag affects the property) */

  
  void set_wrap_mode(WrapMode wrap_mode);
  
  WrapMode get_wrap_mode();
  
  void set_editable(bool setting = true);
  
  bool get_editable();
  
  void set_pixels_above_lines(int pixels_above_lines);
  
  int get_pixels_above_lines();
  
  void set_pixels_below_lines(int pixels_below_lines);
  
  int get_pixels_below_lines();
  
  void set_pixels_inside_wrap(int pixels_inside_wrap);
  
  int get_pixels_inside_wrap();
  
  void set_justification(Justification justification);
  
  Justification get_justification();
  
  void set_left_margin(int left_margin);
  
  int get_left_margin();
  
  void set_right_margin(int right_margin);
  
  int get_right_margin();
  
  void set_indent(int indent);
  
  int get_indent();
  
  void set_tabs(Pango::TabArray& tabs);
  
  Pango::TabArray get_tabs();
  
  TextAttributes get_default_attributes();

  
  /**
   * @par Prototype:
   * <tt>void %set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment)</tt>
   */
  Glib::SignalProxy2<void,Adjustment*,Adjustment*> signal_set_scroll_adjustments();

  
  /**
   * @par Prototype:
   * <tt>void %populate_popup(Menu* menu)</tt>
   */
  Glib::SignalProxy1<void,Menu*> signal_populate_popup();


  /**
   * @par Prototype:
   * <tt>void %move_cursor(MovementStep step, int count, bool extend_selection)</tt>
   */
  Glib::SignalProxy3<void,MovementStep,int,bool> signal_move_cursor();

  
  /**
   * @par Prototype:
   * <tt>void %page_horizontally(int count, bool extend_selection)</tt>
   */
  Glib::SignalProxy2<void,int,bool> signal_page_horizontally();

  
  /**
   * @par Prototype:
   * <tt>void %set_anchor()</tt>
   */
  Glib::SignalProxy0<void> signal_set_anchor();

  
  /**
   * @par Prototype:
   * <tt>void %insert_at_cursor(const Glib::ustring& str)</tt>
   */
  Glib::SignalProxy1<void,const Glib::ustring&> signal_insert_at_cursor();

  
  /**
   * @par Prototype:
   * <tt>void %delete_from_cursor(DeleteType type, int count)</tt>
   */
  Glib::SignalProxy2<void,DeleteType,int> signal_delete_from_cursor();

  
  /**
   * @par Prototype:
   * <tt>void %cut_clipboard()</tt>
   */
  Glib::SignalProxy0<void> signal_cut_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void %copy_clipboard()</tt>
   */
  Glib::SignalProxy0<void> signal_copy_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void %paste_clipboard()</tt>
   */
  Glib::SignalProxy0<void> signal_paste_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void %toggle_overwrite()</tt>
   */
  Glib::SignalProxy0<void> signal_toggle_overwrite();

  
  /**
   * @par Prototype:
   * <tt>void %move_focus(DirectionType direction)</tt>
   */
  Glib::SignalProxy1<void,DirectionType> signal_move_focus();


  Glib::PropertyProxy<int> property_pixels_above_lines();

  Glib::PropertyProxy<int> property_pixels_below_lines();

  Glib::PropertyProxy<int> property_pixels_inside_wrap();

  Glib::PropertyProxy<bool> property_editable();

  Glib::PropertyProxy<WrapMode> property_wrap_mode();

  Glib::PropertyProxy<Justification> property_justification();

  Glib::PropertyProxy<int> property_left_margin();

  Glib::PropertyProxy<int> property_right_margin();

  Glib::PropertyProxy<int> property_indent();

  Glib::PropertyProxy<Pango::TabArray> property_tabs();

  Glib::PropertyProxy<bool> property_cursor_visible();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::TextView */
  Gtk::TextView* wrap(GtkTextView* object, bool take_copy = false);
}
#endif /* _GTKMM_TEXTVIEW_H */

