
#include <gtkmm/table.h>
#include <gtkmm/private/table_p.h>

// -*- c++ -*-
/* $Id: table.ccg,v 1.9 2002/01/22 15:39:15 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktable.h>

namespace Gtk
{


void Table::set_spacings(guint spacing)
{
  set_row_spacings(spacing);
  set_col_spacings(spacing);
}

Table::TableList& Table::children()
{
  children_proxy_ = TableList(gobj());
  return children_proxy_;
}

const Table::TableList& Table::children() const
{
  children_proxy_ = TableList(const_cast<GtkTable*>(gobj()));
  return children_proxy_;
}


} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Table* wrap(GtkTable* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Table *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Table_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_table_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Table_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Table_Class::wrap_new(GObject* o)
{
  return manage(new Table((GtkTable*)(o)));
}


/* The implementation: */

Table::Table(GtkTable* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Table::~Table()
{
  destroy_();
}

Table::CppClassType Table::table_class_; //Initialize static member.

GType Table::get_type()
{
  return table_class_.get_type();
}

GType Table::get_base_type()
{
  return gtk_table_get_type();
}


namespace Table_Helpers
{

void TableList::remove(const_reference child)
{
  g_return_if_fail(child != 0);
  gtk_container_remove(GTK_CONTAINER(gparent_),
                       (GtkWidget*)(child->gobj()));
}

void TableList::remove(Widget &w)
{
  gtk_container_remove(GTK_CONTAINER(gparent_), (GtkWidget*)(w.gobj()));
}

TableList::iterator TableList::erase(iterator position)
{
  if ( !position.node || (position == end()) )
    return end();

  iterator next = position;
  next++;

  gtk_container_remove(GTK_CONTAINER(gparent_),
      (GtkWidget*)((*position)->gobj()));
  return next;
}

} /* namespace Table_Helpers */


namespace Table_Helpers
{

TableList::TableList()
{}

TableList::TableList(GtkTable* gparent)
: type_base((GObject*)gparent)
{}

TableList::TableList(const TableList& src)
{
  operator=(src);
}

TableList& TableList::operator=(const TableList& src)
{
  gparent_ = src.gparent_;
  return *this;
}

GList*& TableList::glist() const
{
  return ((GtkTable*)gparent_)->children;
}

void TableList::erase(iterator start, iterator stop)
{
  type_base::erase(start, stop);
}

GtkTable* TableList::gparent()
{
  return (GtkTable*)type_base::gparent();
}

const GtkTable* TableList::gparent() const
{
  return (GtkTable*)type_base::gparent();
}

TableList::value_type TableList::operator[](size_type l) const
{
  return type_base::operator[](l);
}

} /* namespace Table_Helpers */

Table::Table(guint n_rows, guint n_columns, bool homogeneous)
: Gtk::Container((GtkContainer*)( g_object_new(get_type(), "n_rows", n_rows, "n_columns", n_columns, "homogeneous", static_cast<int>(homogeneous), (char*)0) ))
{}

void Table::attach(Widget & child, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach, AttachOptions xoptions, AttachOptions yoptions, guint xpadding, guint ypadding)
{
  gtk_table_attach(gobj(), (child).Gtk::Widget::gobj(), left_attach, right_attach, top_attach, bottom_attach, ((GtkAttachOptions)(xoptions)), ((GtkAttachOptions)(yoptions)), xpadding, ypadding);
}

void Table::resize(guint rows, guint columns)
{
  gtk_table_resize(gobj(), rows, columns);
}

void Table::set_row_spacing(guint row, guint spacing)
{
  gtk_table_set_row_spacing(gobj(), row, spacing);
}

guint Table::get_row_spacing(guint row) const
{
  return gtk_table_get_row_spacing(const_cast<GtkTable*>(gobj()), row);
}

void Table::set_col_spacing(guint column, guint spacing)
{
  gtk_table_set_col_spacing(gobj(), column, spacing);
}

guint Table::get_col_spacing(guint column) const
{
  return gtk_table_get_col_spacing(const_cast<GtkTable*>(gobj()), column);
}

void Table::set_row_spacings(guint spacing)
{
  gtk_table_set_row_spacings(gobj(), spacing);
}

void Table::set_col_spacings(guint spacing)
{
  gtk_table_set_col_spacings(gobj(), spacing);
}

guint Table::get_default_row_spacing()
{
  return gtk_table_get_default_row_spacing(gobj());
}

guint Table::get_default_col_spacing()
{
  return gtk_table_get_default_col_spacing(gobj());
}

void Table::set_homogeneous(bool homogeneous)
{
  gtk_table_set_homogeneous(gobj(), static_cast<int>(homogeneous));
}

bool Table::get_homogeneous() const
{
  return gtk_table_get_homogeneous(const_cast<GtkTable*>(gobj()));
}


Glib::PropertyProxy<guint> Table::property_n_rows()
{
  return Glib::PropertyProxy<guint>(this, "n_rows");
}

Glib::PropertyProxy<guint> Table::property_n_columns()
{
  return Glib::PropertyProxy<guint>(this, "n_columns");
}

Glib::PropertyProxy<guint> Table::property_column_spacing()
{
  return Glib::PropertyProxy<guint>(this, "column_spacing");
}

Glib::PropertyProxy<guint> Table::property_row_spacing()
{
  return Glib::PropertyProxy<guint>(this, "row_spacing");
}


} // namespace Gtk

