
#include <gtkmm/radiomenuitem.h>
#include <gtkmm/private/radiomenuitem_p.h>

// -*- c++ -*-
/* $Id: radiomenuitem.ccg,v 1.10 2001/12/19 07:31:20 kenelson Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/misc.h>
#include <gtkmm/label.h>
#include <gtk/gtkradiomenuitem.h>

typedef Gtk::RadioMenuItem::Group Group;

namespace Gtk
{

RadioMenuItem::RadioMenuItem(Group& groupx)
  : CheckMenuItem((GtkCheckMenuItem*)(g_object_new(get_type(),0)))
{

  groupx.add(*this);
}

RadioMenuItem::RadioMenuItem(Group& groupx, const Glib::ustring &label, bool mnemonic /* = false */)
  : CheckMenuItem((GtkCheckMenuItem*)(g_object_new(get_type(),0)))
{

  groupx.add(*this);
  add_accel_label(label, mnemonic);
}

void
RadioMenuItem_Helpers::Group::add(RadioMenuItem& item)
{
  item.set_group(*this);
  group_ = item.gobj()->group;
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::RadioMenuItem* wrap(GtkRadioMenuItem* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::RadioMenuItem *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType RadioMenuItem_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_radio_menu_item_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void RadioMenuItem_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* RadioMenuItem_Class::wrap_new(GObject* o)
{
  return manage(new RadioMenuItem((GtkRadioMenuItem*)(o)));
}


/* The implementation: */

RadioMenuItem::RadioMenuItem(GtkRadioMenuItem* castitem)
: Gtk::CheckMenuItem((GtkCheckMenuItem*)(castitem))
{}

RadioMenuItem::~RadioMenuItem()
{
  destroy_();
}

RadioMenuItem::CppClassType RadioMenuItem::radiomenuitem_class_; //Initialize static member.

GType RadioMenuItem::get_type()
{
  return radiomenuitem_class_.get_type();
}

GType RadioMenuItem::get_base_type()
{
  return gtk_radio_menu_item_get_type();
}

Group RadioMenuItem::group()
{
  return Group(gtk_radio_menu_item_get_group(gobj()));
}

void RadioMenuItem::set_group(Group group)
{
  gtk_radio_menu_item_set_group(gobj(), group.group_);
}


} // namespace Gtk

