
#include <gtkmm/adjustment.h>
#include <gtkmm/private/adjustment_p.h>

// -*- c++ -*-
/* $Id: adjustment.ccg,v 1.13 2002/04/21 23:37:05 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtkadjustment.h>

namespace Gtk
{

Adjustment::Adjustment(double value,
      	     double lower,  double upper,
      	     double step_increment /* = 1 */, double page_increment /* = 10 */,
      	     double page_size /* = 0 */)
: Gtk::Object((GtkObject*)( g_object_new( get_type(), 0 ) ))
{
  set_value(value);
  set_lower(lower);
  set_upper(upper);
  set_step_increment(step_increment);
  set_page_increment(page_increment);
  set_page_size(page_size);
}


void Adjustment::set_lower(double lower)
{
  gobj()->lower = lower;
  changed();
}

void Adjustment::set_upper(double upper)
{
  gobj()->upper = upper;
 changed();
}

void Adjustment::set_step_increment(double incr)
{
  gobj()->step_increment = incr;
  changed();
}

void Adjustment::set_page_increment(double incr)
{
  gobj()->page_increment = incr;
  changed();
}

void Adjustment::set_page_size(double size)
{
  gobj()->page_size = size;
  changed();
}

} //namespace Gtk


namespace
{

const Glib::SignalProxyInfo Adjustment_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo Adjustment_signal_value_changed_info =
{
  "value_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Adjustment* wrap(GtkAdjustment* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Adjustment *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Adjustment_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_adjustment_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Adjustment_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->changed = &changed_callback;
  klass->value_changed = &value_changed_callback;
}


void Adjustment_Class::changed_callback(GtkAdjustment* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->changed)
      (*base->changed)(self);
  }
}

void Adjustment_Class::value_changed_callback(GtkAdjustment* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_value_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->value_changed)
      (*base->value_changed)(self);
  }
}


Glib::ObjectBase* Adjustment_Class::wrap_new(GObject* o)
{
  return manage(new Adjustment((GtkAdjustment*)(o)));
}


/* The implementation: */

Adjustment::Adjustment(GtkAdjustment* castitem)
: Gtk::Object((GtkObject*)(castitem))
{}

Adjustment::~Adjustment()
{
  destroy_();
}

Adjustment::CppClassType Adjustment::adjustment_class_; //Initialize static member.

GType Adjustment::get_type()
{
  return adjustment_class_.get_type();
}

GType Adjustment::get_base_type()
{
  return gtk_adjustment_get_type();
}

void Adjustment::changed()
{
  gtk_adjustment_changed(gobj());
}

void Adjustment::value_changed()
{
  gtk_adjustment_value_changed(gobj());
}

void Adjustment::clamp_page(double lower, double upper)
{
  gtk_adjustment_clamp_page(gobj(), lower, upper);
}

void Adjustment::set_value(double value)
{
  gtk_adjustment_set_value(gobj(), value);
}

double Adjustment::get_value() const
{
  return gtk_adjustment_get_value(const_cast<GtkAdjustment*>(gobj()));
}

double Adjustment::get_lower() const
{
  return gobj()->lower;
}

double Adjustment::get_upper() const
{
  return gobj()->upper;
}

double Adjustment::get_step_increment() const
{
  return gobj()->step_increment;
}

double Adjustment::get_page_increment() const
{
  return gobj()->page_increment;
}

double Adjustment::get_page_size() const
{
  return gobj()->page_size;
}


Glib::SignalProxy0<void> Adjustment::signal_changed()
{
  return Glib::SignalProxy0<void>(this, &Adjustment_signal_changed_info);
}

Glib::SignalProxy0<void> Adjustment::signal_value_changed()
{
  return Glib::SignalProxy0<void>(this, &Adjustment_signal_value_changed_info);
}


void Gtk::Adjustment::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->changed)
    (*base->changed)(gobj());
}

void Gtk::Adjustment::on_value_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->value_changed)
    (*base->value_changed)(gobj());
}


} // namespace Gtk

