// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTBUFFER_H
#define _GTKMM_TEXTBUFFER_H

#include <glibmm.h>

/* $Id: textbuffer.hg,v 1.22 2002/04/01 16:19:35 murrayc Exp $ */

/* textbuffer.h
 * 
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/object.h>
#include <gtkmm/texttagtable.h>
//#include <gtkmm/textmark.h>
#include <gtkmm/textiter.h>
#include <gtk/gtktextbuffer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
//typedef struct _GtkTextBuffer GtkTextBuffer;
//typedef struct _GtkTextBufferClass GtkTextBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{ class TextBuffer_Class; } // namespace Gtk
namespace Gtk
{

class TextMark;


class TextBuffer : public Glib::Object
{
   public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TextBuffer          CppObjectType;
  typedef TextBuffer_Class    CppClassType;
  typedef GtkTextBuffer           BaseObjectType;
  typedef GtkTextBufferClass      BaseClassType;

private:
  friend class CppClassType;
  static CppClassType textbuffer_class_;

  TextBuffer(const TextBuffer&);
  TextBuffer& operator=(const TextBuffer&); // not implemented

protected:
  explicit TextBuffer(GtkTextBuffer* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TextBuffer();

  static Glib::RefPtr<TextBuffer> wrap_specific_type(GtkTextBuffer* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTextBuffer* gobj()             { return (GtkTextBuffer*)(gobject_); }
  const GtkTextBuffer* gobj() const { return (GtkTextBuffer*)(gobject_); }

  GtkTextBuffer* gobj_copy();


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_insert_text(const TextIter& pos, const Glib::ustring& text, int bytes);
  virtual void on_insert_pixbuf(const TextIter& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  virtual void on_insert_child_anchor(const TextIter& pos, const Glib::RefPtr<TextChildAnchor>& anchor);
  virtual void on_delete_range(const TextIter& start, const TextIter& end);
  virtual void on_changed();
  virtual void on_modified_changed();
  virtual void on_mark_set(const TextIter& location, const Glib::RefPtr<TextMark>& mark);
  virtual void on_mark_deleted(const Glib::RefPtr<TextMark>& mark);
  virtual void on_apply_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start_char, const TextIter& end_char);
  virtual void on_remove_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start_char, const TextIter& end_char);
  virtual void on_begin_user_action();
  virtual void on_end_user_action();


private:

   
protected:
  TextBuffer();
  explicit TextBuffer(const Glib::RefPtr<TextTagTable>& tag_table);

public:

  
  static Glib::RefPtr<TextBuffer> create();

  
  static Glib::RefPtr<TextBuffer> create(const Glib::RefPtr<TextTagTable>& tag_table);


  /** Obtains the number of lines in the buffer. This value is cached, so
   * the function is very fast.
   * @return Number of lines in the buffer.
   */
  int get_line_count() const;
  
  /** Gets the number of characters in the buffer; note that characters
   * and bytes are not the same, you can't e.g.\ expect the contents of
   * the buffer in string form to be this many bytes long. The character
   * count is cached, so this function is very fast.
   * @return Number of characters in the buffer.
   */
  int get_char_count() const;

  
  /** Get the Gtk::TextTagTable associated with this buffer.
   * @return The buffer's tag table.
   */
  Glib::RefPtr<TextTagTable> get_tag_table();

  void set_text(const Glib::ustring& text);
  void set_text(const char* text_begin, const char* text_end);

  void insert(TextIter& iter, const Glib::ustring& text);
  void insert(TextIter& iter, const char* text_begin, const char* text_end);

  void insert_at_cursor(const Glib::ustring& text);
  void insert_at_cursor(const char* text_begin, const char* text_end);

  bool insert_interactive(TextIter& iter, const Glib::ustring& text, bool default_editable);
  bool insert_interactive(TextIter& iter, const char* text_begin, const char* text_end, bool default_editable);

  bool insert_interactive_at_cursor(const Glib::ustring& text, bool default_editable);
  bool insert_interactive_at_cursor(const char* text_begin, const char* text_end, bool default_editable);

  
  /** Copies text, tags, and pixbufs between @a start and @a end (the order
   * of @a start and @a end doesn't matter) and inserts the copy at @a iter.
   * Used instead of simply getting/inserting text because it preserves
   * images and tags. If @a start and @a end are in a different buffer from
   * @a buffer, the two buffers must share the same tag table.
   * 
   * Implemented via emissions of the insert_text and apply_tag signals,
   * so expect those.
   * @param iter A position in @a buffer.
   * @param start A position in a Gtk::TextBuffer.
   * @param end Another position in the same buffer as @a start.
   */
  void insert_range(TextIter& iter, const TextIter& start, const TextIter& end);
  
  /** Same as insert_range(), but does nothing if the
   * insertion point isn't editable. The @a default_editable parameter
   * indicates whether the text is editable at @a iter if no tags
   * enclosing @a iter affect editability. Typically the result of
   * Gtk::TextView::get_editable() is appropriate here.
   * @param iter A position in @a buffer.
   * @param start A position in a Gtk::TextBuffer.
   * @param end Another position in the same buffer as @a start.
   * @param default_editable Default editability of the buffer.
   * @return Whether an insertion was possible at @a iter.
   */
  bool insert_range_interactive(TextIter& iter, const TextIter& start, const TextIter& end,
                                             bool default_editable);

  void insert_with_tag(TextIter& iter, const Glib::ustring& text, const Glib::RefPtr<TextTag>& tag);
  void insert_with_tag(TextIter& iter, const char* text_begin, const char* text_end, const Glib::RefPtr<TextTag>& tag);

  void insert_with_tag(TextIter& iter, const Glib::ustring& text, const Glib::ustring& tag_name);
  void insert_with_tag(TextIter& iter, const char* text_begin, const char* text_end, const Glib::ustring& tag_name);

  void insert_with_tags(TextIter& iter, const Glib::ustring& text,
                        const Glib::ArrayHandle< Glib::RefPtr<TextTag> >& tags);
  void insert_with_tags(TextIter& iter, const char* text_begin, const char* text_end,
                        const Glib::ArrayHandle< Glib::RefPtr<TextTag> >& tags);

  void insert_with_tags_by_name(TextIter& iter, const Glib::ustring& text,
                                const Glib::StringArrayHandle& tag_names);
  void insert_with_tags_by_name(TextIter& iter, const char* text_begin, const char* text_end,
                                const Glib::StringArrayHandle& tag_names);

  
  /** Deletes text between @a start and @a end. The order of @a start and @a end
   * is not actually relevant; delete() will reorder
   * them. This function actually emits the "delete_range" signal, and
   * the default handler of that signal deletes the text. Because the
   * buffer is modified, all outstanding iterators become invalid after
   * calling this function; however, the @a start and @a end will be
   * re-initialized to point to the location where text was deleted.
   * @param start A position in @a buffer.
   * @param end Another position in @a buffer.
   */
  void delete_(TextIter& start, TextIter& end);
  
  /** Deletes all <em>editable</em> text in the given range.
   * Calls delete() for each editable sub-range of
   * [@a start,@a end). @a start and @a end are revalidated to point to
   * the location of the last deleted range, or left untouched if
   * no text was deleted.
   * @param start_iter Start of range to delete.
   * @param end_iter End of range.
   * @param default_editable Whether the buffer is editable by default.
   * @return Whether some text was actually deleted.
   */
  bool delete_interactive(TextIter& start_iter, TextIter& end_iter, bool default_editable);


  /** Returns the text in the range [@a start,@a end). Excludes undisplayed
   * text (text marked with tags that set the invisibility attribute) if
   * @a include_hidden_chars is FALSE. Does not include characters
   * representing embedded images, so byte and character indexes into
   * the returned string do <em>not</em> correspond to byte
   * and character indexes into the buffer. Contrast with
   * get_slice().
   * @param start Start of a range.
   * @param end End of a range.
   * @param include_hidden_chars Whether to include invisible text.
   * @return An allocated UTF-8 string.
   */
  Glib::ustring get_text(const TextIter& start, const TextIter& end,
                                                     bool include_hidden_chars);

  
  /** Returns the text in the range [@a start,@a end). Excludes undisplayed
   * text (text marked with tags that set the invisibility attribute) if
   * @a include_hidden_chars is FALSE. The returned string includes a
   * 0xFFFC character whenever the buffer contains
   * embedded images, so byte and character indexes into
   * the returned string <em>do</em> correspond to byte
   * and character indexes into the buffer. Contrast with
   * get_text(). Note that 0xFFFC can occur in normal
   * text as well, so it is not a reliable indicator that a pixbuf or
   * widget is in the buffer.
   * @param start Start of a range.
   * @param end End of a range.
   * @param include_hidden_chars Whether to include invisible text.
   * @return An allocated UTF-8 string.
   */
  Glib::ustring get_slice(const TextIter& start, const TextIter& end,
                                                     bool include_hidden_chars);


  /** Inserts an image into the text buffer at @a iter. The image will be
   * counted as one character in character counts, and when obtaining
   * the buffer contents as a string, will be represented by the Unicode
   * "object replacement character" 0xFFFC. Note that the "slice"
   * variants for obtaining portions of the buffer as a string include
   * this character for pixbufs, but the "text" variants do
   * not. e.g. see get_slice() and
   * get_text().
   * @param iter Location to insert the pixbuf.
   * @param pixbuf A Gdk::Pixbuf.
   */
  void insert_pixbuf(TextIter& iter, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

  
  /** Inserts a child widget anchor into the text buffer at @a iter. The
   * anchor will be counted as one character in character counts, and
   * when obtaining the buffer contents as a string, will be represented
   * by the Unicode "object replacement character" 0xFFFC. Note that the
   * "slice" variants for obtaining portions of the buffer as a string
   * include this character for child anchors, but the "text" variants do
   * not. e.g. see get_slice() and
   * get_text(). Consider
   * create_child_anchor() as a more convenient
   * alternative to this function. The buffer will add a reference to
   * the anchor, so you can unref it after insertion.
   * @param iter Location to insert the anchor.
   * @param anchor A Gtk::TextChildAnchor.
   */
  void insert_child_anchor(TextIter& iter, const Glib::RefPtr<TextChildAnchor>& anchor);
  
  /** This is a convenience function which simply creates a child anchor
   * with Gtk::TextChildAnchor::new() and inserts it into the buffer
   * with insert_child_anchor(). The new anchor is
   * owned by the buffer; no reference count is returned to
   * the caller of create_child_anchor().
   * @param iter Location in the buffer.
   * @return The created child anchor.
   */
  Glib::RefPtr<TextChildAnchor> create_child_anchor(TextIter& iter);

  
  /** Creates a mark at position @a where. If @a mark_name is <tt>0</tt>, the mark
   * is anonymous; otherwise, the mark can be retrieved by name using
   * get_mark(). If a mark has left gravity, and text is
   * inserted at the mark's current location, the mark will be moved to
   * the left of the newly-inserted text. If the mark has right gravity
   * (@a left_gravity = <tt>false</tt>), the mark will end up on the right of
   * newly-inserted text. The standard left-to-right cursor is a mark
   * with right gravity (when you type, the cursor stays on the right
   * side of the text you're typing).
   * 
   * The caller of this function does <em>not</em> own a reference
   * to the returned Gtk::TextMark, so you can ignore the return value
   * if you like. Marks are owned by the buffer and go away when the
   * buffer does.
   * 
   * Emits the "mark_set" signal as notification of the mark's initial
   * placement.
   * @param mark_name Name for mark, or <tt>0</tt>.
   * @param where Location to place mark.
   * @param left_gravity Whether the mark has left gravity.
   * @return The new Gtk::TextMark object.
   */
  Glib::RefPtr<TextMark> create_mark(const Glib::ustring& mark_name, const TextIter& where, bool left_gravity);
  
  /** Moves @a mark to the new location @a where. Emits the "mark_set" signal
   * as notification of the move.
   * @param mark A Gtk::TextMark.
   * @param where New location for @a mark in @a buffer.
   */
  void move_mark(const Glib::RefPtr<TextMark>& mark, const TextIter& where);
  
  /** Deletes @a mark, so that it's no longer located anywhere in the
   * buffer. Removes the reference the buffer holds to the mark, so if
   * you haven't called g_object_ref() on the mark, it will be freed. Even
   * if the mark isn't freed, most operations on @a mark become
   * invalid. There is no way to undelete a
   * mark. Gtk::TextMark::get_deleted() will return TRUE after this
   * function has been called on a mark; Gtk::TextMark::get_deleted()
   * indicates that a mark no longer belongs to a buffer. The "mark_deleted"
   * signal will be emitted as notification after the mark is deleted.
   * @param mark A Gtk::TextMark in @a buffer.
   */
  void delete_mark(const Glib::RefPtr<TextMark>& mark);
  
  /** Returns the mark named @a name in buffer @a buffer, or NULL if no such
   * mark exists in the buffer.
   * @param name A mark name.
   * @return A Gtk::TextMark, or NULL.
   */
  Glib::RefPtr<TextMark> get_mark(const Glib::ustring& name);

  
  /** Moves the mark named @a name (which must exist) to location @a where.
   * See move_mark() for details.
   * @param name Name of a mark.
   * @param where New location for mark.
   */
  void move_mark_by_name(const Glib::ustring& name, const TextIter& where);
  
  /** Deletes the mark named @a name; the mark must exist. See
   * delete_mark() for details.
   * @param name Name of a mark in @a buffer.
   */
  void delete_mark_by_name(const Glib::ustring& name);

  
  /** Returns the mark that represents the cursor (insertion point).
   * Equivalent to calling get_mark() to get the mark
   * named "insert", but very slightly more efficient, and involves less
   * typing.
   * @return Insertion point mark.
   */
  Glib::RefPtr<TextMark> get_insert();
  
  /** Returns the mark that represents the selection bound.  Equivalent
   * to calling get_mark() to get the mark named
   * "selection_bound", but very slightly more efficient, and involves
   * less typing.
   * 
   * The currently-selected text in @a buffer is the region between the
   * "selection_bound" and "insert" marks. If "selection_bound" and
   * "insert" are in the same place, then there is no current selection.
   * get_selection_bounds() is another convenient function
   * for handling the selection, if you just want to know whether there's a
   * selection and what its bounds are.
   * @return Selection bound mark.
   */
  Glib::RefPtr<TextMark> get_selection_bound();

  
  /** This function moves the "insert" and "selection_bound" marks
   * simultaneously.  If you move them to the same place in two steps
   * with move_mark(), you will temporarily select a
   * region in between their old and new locations, which can be pretty
   * inefficient since the temporarily-selected region will force stuff
   * to be recalculated. This function moves them as a unit, which can
   * be optimized.
   * @param where Where to put the cursor.
   */
  void place_cursor(const TextIter& where);
  
  /** Emits the "apply_tag" signal on @a buffer. The default
   * handler for the signal applies @a tag to the given range.
   * @a start and @a end do not have to be in order.
   * @param tag A Gtk::TextTag.
   * @param start One bound of range to be tagged.
   * @param end Other bound of range to be tagged.
   */
  void apply_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start, const TextIter& end);
  
  /** Emits the "remove_tag" signal. The default handler for the signal
   * removes all occurrences of @a tag from the given range. @a start and
   * @a end don't have to be in order.
   * @param tag A Gtk::TextTag.
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start, const TextIter& end);
  
  /** Calls Gtk::TextTagTable::lookup() on the buffer's tag table to
   * get a Gtk::TextTag, then calls apply_tag().
   * @param name Name of a named Gtk::TextTag.
   * @param start One bound of range to be tagged.
   * @param end Other bound of range to be tagged.
   */
  void apply_tag_by_name(const Glib::ustring& name, const TextIter& start, const TextIter& end);
  
  /** Calls Gtk::TextTagTable::lookup() on the buffer's tag table to
   * get a Gtk::TextTag, then calls remove_tag().
   * @param name Name of a Gtk::TextTag.
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_tag_by_name(const Glib::ustring& name, const TextIter& start, const TextIter& end);
  
  /** Removes all tags in the range between @a start and @a end.  Be careful
   * with this function; it could remove tags added in code unrelated to
   * the code you're currently writing. That is, using this function is
   * probably a bad idea if you have two or more unrelated code sections
   * that add tags.
   * @param start One bound of range to be untagged.
   * @param end Other bound of range to be untagged.
   */
  void remove_all_tags(const TextIter& start, const TextIter& end);

  Glib::RefPtr<TextTag> create_tag(const Glib::ustring& tag_name);

  TextIter get_iter_at_line_offset(int line_number, int char_offset);
  TextIter get_iter_at_line_index(int line_number, int byte_index);
  TextIter get_iter_at_offset(int char_offset);
  TextIter get_iter_at_line(int line_number);
  TextIter get_start_iter();
  TextIter get_end_iter();
  void get_bounds(TextIter& start, TextIter& end);
  TextIter get_iter_at_mark(const Glib::RefPtr<TextMark>& mark);

  TextIter get_iter_at_child_anchor(const Glib::RefPtr<TextChildAnchor>& anchor);

  
  /** Indicates whether the buffer has been modified since the last call
   * to set_modified() set the modification flag to
   * <tt>false</tt>. Used for example to enable a "save" function in a text
   * editor.
   * @return <tt>true</tt> if the buffer has been modified.
   */
  bool get_modified();
  
  /** Used to keep track of whether the buffer has been modified since the
   * last time it was saved. Whenever the buffer is saved to disk, call
   * gtk_text_buffer_set_modified (@a buffer, FALSE). When the buffer is modified,
   * it will automatically toggled on the modified bit again. When the modified
   * bit flips, the buffer emits a "modified_changed" signal.
   * @param setting Modification flag setting.
   */
  void set_modified(bool setting = true);

//TODO:
//  _WRAP_METHOD(void add_selection_clipboard(GtkClipboard* clipboard), gtk_text_buffer_add_selection_clipboard)
//  _WRAP_METHOD(void remove_selection_clipboard(GtkClipboard* clipboard), gtk_text_buffer_remove_selection_clipboard)
//
//  _WRAP_METHOD(void cut_clipboard(GtkClipboard  *clipboard, bool default_editable), gtk_text_buffer_cut_clipboard)
//  _WRAP_METHOD(void copy_clipboard(GtkClipboard  *clipboard), gtk_text_buffer_copy_clipboard)
  //_WRAP_METHOD(void paste_clipboard(GtkClipboard  *clipboard, TextIter& override_location, bool default_editable), gtk_text_buffer_paste_clipboard)

  //_WRAP_METHOD(bool gtk_text_buffer_get_selection_bounds(TextIter& start, TextIter& end), )
  void get_selection_bounds(TextIter& start, TextIter& end);
  
  /** Deletes the range between the "insert" and "selection_bound" marks,
   * that is, the currently-selected text. If @a interactive is <tt>true</tt>,
   * the editability of the selection will be considered (users can't delete
   * uneditable text).
   * @param interactive Whether the deletion is caused by user interaction.
   * @param default_editable Whether the buffer is editable by default.
   * @return Whether there was a non-empty selection to delete.
   */
  bool delete_selection(bool interactive, bool default_editable);

/* Called to specify atomic user actions, used to implement undo */
  
  /** Called to indicate that the buffer operations between here and a
   * call to end_user_action() are part of a single
   * user-visible operation. The operations between
   * begin_user_action() and
   * end_user_action() can then be grouped when creating
   * an undo stack. Gtk::TextBuffer maintains a count of calls to
   * begin_user_action() that have not been closed with
   * a call to end_user_action(), and emits the "begin_user_action"
   * and "end_user_action" signals only for the outermost pair of calls.
   * This allows you to build user actions from other user actions.
   * 
   * The "interactive" buffer mutation functions, such as
   * insert_interactive(), automatically call begin/end
   * user action around the buffer operations they perform, so there's
   * no need to add extra calls if you user action consists solely of a
   * single call to one of those functions.
   */
  void begin_user_action();
  
  /** Should be paired with a call to begin_user_action().
   * See that function for a full explanation.
   */
  void end_user_action();


  /**
   * @par Prototype:
   * <tt>void %insert_text(const TextIter& pos, const Glib::ustring& text, int bytes)</tt>
   */
  Glib::SignalProxy3<void,const TextIter&,const Glib::ustring&,int> signal_insert_text();

  
  /**
   * @par Prototype:
   * <tt>void %insert_pixbuf(const TextIter& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)</tt>
   */
  Glib::SignalProxy2<void,const TextIter&,const Glib::RefPtr<Gdk::Pixbuf>&> signal_insert_pixbuf();

  
  /**
   * @par Prototype:
   * <tt>void %insert_child_anchor(const TextIter& pos, const Glib::RefPtr<TextChildAnchor>& anchor)</tt>
   */
  Glib::SignalProxy2<void,const TextIter&,const Glib::RefPtr<TextChildAnchor>&> signal_insert_child_anchor();

  
  /**
   * @par Prototype:
   * <tt>void %delete_range(const TextIter& start, const TextIter& end)</tt>
   */
  Glib::SignalProxy2<void,const TextIter&,const TextIter&> signal_delete_range();

  
  /**
   * @par Prototype:
   * <tt>void %changed()</tt>
   */
  Glib::SignalProxy0<void> signal_changed();

  
  /**
   * @par Prototype:
   * <tt>void %modified_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_modified_changed();

  
  /**
   * @par Prototype:
   * <tt>void %mark_set(const TextIter& location, const Glib::RefPtr<TextMark>& mark)</tt>
   */
  Glib::SignalProxy2<void,const TextIter&,const Glib::RefPtr<TextMark>&> signal_mark_set();

  
  /**
   * @par Prototype:
   * <tt>void %mark_deleted(const Glib::RefPtr<TextMark>& mark)</tt>
   */
  Glib::SignalProxy1<void,const Glib::RefPtr<TextMark>&> signal_mark_deleted();

  
  /**
   * @par Prototype:
   * <tt>void %apply_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start_char, const TextIter& end_char)</tt>
   */
  Glib::SignalProxy3<void,const Glib::RefPtr<TextTag>&,const TextIter&,const TextIter&> signal_apply_tag();

  
  /**
   * @par Prototype:
   * <tt>void %remove_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start_char, const TextIter& end_char)</tt>
   */
  Glib::SignalProxy3<void,const Glib::RefPtr<TextTag>&,const TextIter&,const TextIter&> signal_remove_tag();

  
  /**
   * @par Prototype:
   * <tt>void %begin_user_action()</tt>
   */
  Glib::SignalProxy0<void> signal_begin_user_action();

  
  /**
   * @par Prototype:
   * <tt>void %end_user_action()</tt>
   */
  Glib::SignalProxy0<void> signal_end_user_action();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::TextBuffer */
  Glib::RefPtr<Gtk::TextBuffer> wrap(GtkTextBuffer* object, bool take_copy = false);
}


#endif /* _GTKMM_TEXTBUFFER_H */

