// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_IMAGE_H
#define _GTKMM_IMAGE_H

#include <glibmm.h>

/* $Id: image.hg,v 1.19 2002/04/02 13:25:17 daniel Exp $ */

/* image.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/misc.h>
#include <gtkmm/iconset.h>
#include <gdkmm/pixbufanimation.h>
#include <gtk/gtkimage.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkImage GtkImage;
typedef struct _GtkImageClass GtkImageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{ class Image_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum ImageType
{
  IMAGE_EMPTY,
  IMAGE_PIXMAP,
  IMAGE_IMAGE,
  IMAGE_PIXBUF,
  IMAGE_STOCK,
  IMAGE_ICON_SET,
  IMAGE_ANIMATION
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ImageType> : public Glib::Value_Enum<Gtk::ImageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @ingroup Widgets
 */

class Image : public Misc
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Image CppObjectType;
  typedef Image_Class CppClassType;
  typedef GtkImage BaseObjectType;
  typedef GtkImageClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Image();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class CppClassType;
  static CppClassType image_class_;

  Image(const Image&);
  Image& operator=(const Image&); // not implemented

protected:
  explicit Image(GtkImage* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkImage* gobj()             { return (GtkImage*)(gobject_); }
  const GtkImage* gobj() const { return (GtkImage*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:

  Image();
  explicit Image(const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask);
  explicit Image(const Glib::RefPtr<Gdk::Image>& image, const Glib::RefPtr<Gdk::Bitmap>& mask);
  explicit Image(const Glib::ustring& file);
  explicit Image(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  Image(const Glib::ustring& stock_id, IconSize size);
  Image(IconSet& icon_set, IconSize size);
  Image(const Glib::RefPtr<Gdk::PixbufAnimation>& animation);
  

  /** See new_from_pixmap() for details.
   * @param pixmap A Gdk::Pixmap or <tt>0</tt>.
   * @param mask A Gdk::Bitmap or <tt>0</tt>.
   */
  void set(const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask);
 
  /** See new_from_image() for details.
   * @param gdk_image A Gdk::Image or <tt>0</tt>.
   * @param mask A Gdk::Bitmap or <tt>0</tt>.
   */
  void set(const Glib::RefPtr<Gdk::Image>& image, const Glib::RefPtr<Gdk::Bitmap>& mask);
 
  /** See new_from_file() for details.
   * @param filename A filename or <tt>0</tt>.
   */
  void set(const Glib::ustring& filename);
 
  /** See new_from_pixbuf() for details.
   * @param pixbuf A Gdk::Pixbuf or <tt>0</tt>.
   */
  void set(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
 
  /** See new_from_stock() for details.
   * @param stock_id A stock icon name.
   * @param size A stock icon size.
   */
  void set(const Glib::ustring& stock_id, IconSize size);
 
  /** See new_from_icon_set() for details.
   * @param icon_set A Gtk::IconSet.
   * @param size A stock icon size.
   */
  void set(IconSet& icon_set, IconSize size);
 
  /** Causes the Gtk::Image to display the given animation (or display
   * nothing, if you set the animation to <tt>0</tt>).
   * @param animation The Gdk::PixbufAnimation.
   */
  void set(const Glib::RefPtr<Gdk::PixbufAnimation>& animation);

 void clear();

 
  /** Gets the type of representation being used by the Gtk::Image
   * to store image data. If the Gtk::Image has no image data,
   * the return value will be Gtk::IMAGE_EMPTY.
   * @return Image representation being used.
   */
  ImageType get_storage_type();

  void get_pixmap(Glib::RefPtr<Gdk::Pixmap>& pixmap, Glib::RefPtr<Gdk::Bitmap>& mask) const;
  void get_image(Glib::RefPtr<Gdk::Image>& gdk_image, Glib::RefPtr<Gdk::Bitmap>& mask) const;
  
  /** Gets the Gdk::Pixbuf being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::IMAGE_EMPTY or
   * Gtk::IMAGE_PIXBUF (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned pixbuf.
   * @return The displayed pixbuf, or <tt>0</tt> if the image is empty.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_pixbuf() const;
  void get_stock(Glib::ustring& stock_id, IconSize& size) const;
  void get_icon_set(IconSet& icon_set, IconSize& size) const;
  
  /** Gets the Gdk::PixbufAnimation being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::IMAGE_EMPTY or
   * Gtk::IMAGE_ANIMATION (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned animation.
   * @return The displayed animation, or <tt>0</tt> if the image is empty.
   */
  Glib::RefPtr<Gdk::PixbufAnimation> get_animation();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_pixbuf();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixmap> > property_pixmap();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Image> > property_image();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixmap> > property_mask();

  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_file();

  Glib::PropertyProxy<Glib::ustring> property_stock();

  Glib::PropertyProxy<Gtk::IconSet> property_icon_set();

  Glib::PropertyProxy<int> property_icon_size();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::PixbufAnimation> > property_pixbuf_animation();

  Glib::PropertyProxy_ReadOnly<ImageType> property_storage_type();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Image */
  Gtk::Image* wrap(GtkImage* object, bool take_copy = false);
}
#endif /* _GTKMM_IMAGE_H */

