
#include <gtkmm/colorselection.h>
#include <gtkmm/private/colorselection_p.h>

// -*- c++ -*-
/* $Id: colorselection.ccg,v 1.10 2001/12/19 07:31:19 kenelson Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkcolorsel.h>
#include <gtk/gtkcolorseldialog.h>

namespace Gtk
{

Gdk::Color ColorSelection::get_current_color() const
{
  Gdk::Color color; //GdkColor Just a simple struct.
  gtk_color_selection_get_current_color(const_cast<GtkColorSelection*>(gobj()), color.gobj());
  return color;
}

Gdk::Color ColorSelection::get_previous_color() const
{
  Gdk::Color color; //GdkColor Just a simple struct.
  gtk_color_selection_get_previous_color(const_cast<GtkColorSelection*>(gobj()), color.gobj());
  return color;
}

ColorSelectionDialog::ColorSelectionDialog()
:
  Gtk::Dialog(reinterpret_cast<GtkDialog*>(g_object_new(get_type(), "title", 0, 0)))
{
}

} /* namespace Gtk */


namespace
{

const Glib::SignalProxyInfo ColorSelection_signal_color_changed_info =
{
  "color_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::ColorSelection* wrap(GtkColorSelection* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::ColorSelection *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType ColorSelection_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_color_selection_get_type(), "gtkmm__ColorSelection", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void ColorSelection_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->color_changed = &color_changed_callback;
}


void ColorSelection_Class::color_changed_callback(GtkColorSelection* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_color_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->color_changed)
      (*base->color_changed)(self);
  }
}


Glib::ObjectBase* ColorSelection_Class::wrap_new(GObject* o)
{
  return manage(new ColorSelection((GtkColorSelection*)(o)));
}


/* The implementation: */

ColorSelection::ColorSelection(GtkColorSelection* castitem)
: Gtk::VBox((GtkVBox*)(castitem))
{}

ColorSelection::~ColorSelection()
{
  destroy_();
}

ColorSelection::CppClassType ColorSelection::colorselection_class_; //Initialize static member.

GType ColorSelection::get_type()
{
  return colorselection_class_.get_type();
}

GType ColorSelection::get_base_type()
{
  return gtk_color_selection_get_type();
}

ColorSelection::ColorSelection()
: Gtk::VBox((GtkVBox*)(g_object_new(get_type(), (char*)0)))
{}

bool ColorSelection::get_has_opacity_control() const
{
  return gtk_color_selection_get_has_opacity_control(const_cast<GtkColorSelection*>(gobj()));
}

void ColorSelection::set_has_opacity_control(bool has_opacity)
{
  gtk_color_selection_set_has_opacity_control(gobj(), static_cast<int>(has_opacity));
}

bool ColorSelection::get_has_palette() const
{
  return gtk_color_selection_get_has_palette(const_cast<GtkColorSelection*>(gobj()));
}

void ColorSelection::set_has_palette(bool has_palette)
{
  gtk_color_selection_set_has_palette(gobj(), static_cast<int>(has_palette));
}

void ColorSelection::set_current_color(const Gdk::Color& color)
{
  gtk_color_selection_set_current_color(gobj(), const_cast<GdkColor*>(color.gobj()));
}

void ColorSelection::set_current_alpha(guint16 alpha)
{
  gtk_color_selection_set_current_alpha(gobj(), alpha);
}

guint16 ColorSelection::get_current_alpha() const
{
  return gtk_color_selection_get_current_alpha(const_cast<GtkColorSelection*>(gobj()));
}

void ColorSelection::set_previous_color(const Gdk::Color& color)
{
  gtk_color_selection_set_previous_color(gobj(), const_cast<GdkColor*>(color.gobj()));
}

void ColorSelection::set_previous_alpha(guint16 alpha)
{
  gtk_color_selection_set_previous_alpha(gobj(), alpha);
}

guint16 ColorSelection::get_previous_alpha()
{
  return gtk_color_selection_get_previous_alpha(gobj());
}

bool ColorSelection::is_adjusting()
{
  return gtk_color_selection_is_adjusting(gobj());
}


Glib::SignalProxy0<void> ColorSelection::signal_color_changed()
{
  return Glib::SignalProxy0<void>(this, &ColorSelection_signal_color_changed_info);
}


Glib::PropertyProxy<bool> ColorSelection::property_has_palette()
{
  return Glib::PropertyProxy<bool>(this, "has_palette");
}

Glib::PropertyProxy<bool> ColorSelection::property_has_opacity_control()
{
  return Glib::PropertyProxy<bool>(this, "has_opacity_control");
}

Glib::PropertyProxy<Gdk::Color> ColorSelection::property_current_color()
{
  return Glib::PropertyProxy<Gdk::Color>(this, "current_color");
}

Glib::PropertyProxy<guint> ColorSelection::property_current_alpha()
{
  return Glib::PropertyProxy<guint>(this, "current_alpha");
}


void Gtk::ColorSelection::on_color_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->color_changed)
    (*base->color_changed)(gobj());
}


} // namespace Gtk


namespace Glib
{

Gtk::ColorSelectionDialog* wrap(GtkColorSelectionDialog* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::ColorSelectionDialog *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType ColorSelectionDialog_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_color_selection_dialog_get_type(), "gtkmm__ColorSelectionDialog", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void ColorSelectionDialog_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* ColorSelectionDialog_Class::wrap_new(GObject* o)
{
  return manage(new ColorSelectionDialog((GtkColorSelectionDialog*)(o)));
}


/* The implementation: */

ColorSelectionDialog::ColorSelectionDialog(GtkColorSelectionDialog* castitem)
: Gtk::Dialog((GtkDialog*)(castitem))
{}

ColorSelectionDialog::~ColorSelectionDialog()
{
  destroy_();
}

ColorSelectionDialog::CppClassType ColorSelectionDialog::colorselectiondialog_class_; //Initialize static member.

GType ColorSelectionDialog::get_type()
{
  return colorselectiondialog_class_.get_type();
}

GType ColorSelectionDialog::get_base_type()
{
  return gtk_color_selection_dialog_get_type();
}

ColorSelectionDialog::ColorSelectionDialog(const Glib::ustring& title)
: Gtk::Dialog((GtkDialog*)( g_object_new(get_type(), "title", title.c_str(), (char*)0) ))
{}

ColorSelection* ColorSelectionDialog::get_colorsel()
{
  return Glib::wrap((GtkColorSelection*)(gobj()->colorsel));
}

const ColorSelection* ColorSelectionDialog::get_colorsel() const
{
  return Glib::wrap((GtkColorSelection*)(gobj()->colorsel));
}

Button* ColorSelectionDialog::get_ok_button()
{
  return Glib::wrap((GtkButton*)(gobj()->ok_button));
}

const Button* ColorSelectionDialog::get_ok_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->ok_button));
}

Button* ColorSelectionDialog::get_cancel_button()
{
  return Glib::wrap((GtkButton*)(gobj()->cancel_button));
}

const Button* ColorSelectionDialog::get_cancel_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->cancel_button));
}

Button* ColorSelectionDialog::get_help_button()
{
  return Glib::wrap((GtkButton*)(gobj()->help_button));
}

const Button* ColorSelectionDialog::get_help_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->help_button));
}


} // namespace Gtk

