// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_CELLRENDERER_H
#define _GTKMM_CELLRENDERER_H

#include <glibmm.h>

/* $Id: cellrenderer.hg,v 1.11 2002/04/02 13:25:14 daniel Exp $ */

/* cellrenderer.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/object.h>
#include <gtkmm/widget.h>
#include <gtk/gtkcellrenderer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkCellRenderer GtkCellRenderer;
typedef struct _GtkCellRendererClass GtkCellRendererClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{ class CellRenderer_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum CellRendererMode
{
  CELL_RENDERER_MODE_INERT,
  CELL_RENDERER_MODE_ACTIVATABLE,
  CELL_RENDERER_MODE_EDITABLE
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::CellRendererMode> : public Glib::Value_Enum<Gtk::CellRendererMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%CellRendererState operator|(CellRendererState, CellRendererState)</tt><br>
 * <tt>%CellRendererState operator&(CellRendererState, CellRendererState)</tt><br>
 * <tt>%CellRendererState operator~(CellRendererState)</tt><br>
 */
enum CellRendererState
{
  CELL_RENDERER_SELECTED = 1 << 0,
  CELL_RENDERER_PRELIT = 1 << 1,
  CELL_RENDERER_INSENSITIVE = 1 << 2,
  CELL_RENDERER_SORTED = 1 << 3
};

/** @ingroup gtkmmEnums */
inline CellRendererState operator|(CellRendererState lhs, CellRendererState rhs)
  { return static_cast<CellRendererState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline CellRendererState operator&(CellRendererState lhs, CellRendererState rhs)
  { return static_cast<CellRendererState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline CellRendererState operator~(CellRendererState flags)
  { return static_cast<CellRendererState>(~static_cast<unsigned>(flags)); }

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::CellRendererState> : public Glib::Value_Flags<Gtk::CellRendererState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


class CellRenderer : public Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef CellRenderer CppObjectType;
  typedef CellRenderer_Class CppClassType;
  typedef GtkCellRenderer BaseObjectType;
  typedef GtkCellRendererClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~CellRenderer();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class CppClassType;
  static CppClassType cellrenderer_class_;

  CellRenderer(const CellRenderer&);
  CellRenderer& operator=(const CellRenderer&); // not implemented

protected:
  explicit CellRenderer(GtkCellRenderer* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkCellRenderer* gobj()             { return (GtkCellRenderer*)(gobject_); }
  const GtkCellRenderer* gobj() const { return (GtkCellRenderer*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual void get_size(GtkWidget * widget, GdkRectangle * cell_area, int * x_offset, int * y_offset, int * width, int * height);
  virtual void render(GdkWindow * window, GtkWidget * widget, GdkRectangle * background_area, GdkRectangle * cell_area, GdkRectangle * expose_area, CellRendererState flags);
  virtual gboolean activate(GdkEvent * event, GtkWidget * widget, const char * path, GdkRectangle * background_area, GdkRectangle * cell_area, CellRendererState flags);
  virtual GtkCellEditable* start_editing(GdkEvent * event, GtkWidget * widget, const char * path, GdkRectangle * background_area, GdkRectangle * cell_area, CellRendererState flags);

  //Default Signal Handlers::


private:

public:

  
  /** Obtains the width and height needed to render the cell. Used by view widgets
   * to determine the appropriate size for the cell_area passed to
   * render().  If @a cell_area is not <tt>0</tt>, fills in the x and y
   * offsets (if set) of the cell relative to this location.  Please note that the
   * values set in @a width and @a height, as well as those in @a x_offset and @a y_offset
   * are inclusive of the xpad and ypad properties.
   * @param widget The widget the renderer is rendering to.
   * @param cell_area The area a cell will be allocated, or <tt>0</tt>.
   * @param x_offset Location to return x offset of cell relative to @a cell_area, or <tt>0</tt>.
   * @param y_offset Location to return y offset of cell relative to @a cell_area, or <tt>0</tt>.
   * @param width Location to return width needed to render a cell, or <tt>0</tt>.
   * @param height Location to return height needed to render a cell, or <tt>0</tt>.
   */
  void get_size(Widget& widget,
						   Gdk::Rectangle& cell_area,
						   int& x_offset, int& y_offset,
						   int& width, int& height);
  
  /** Invokes the virtual render function of the Gtk::CellRenderer. The three
   * passed-in rectangles are areas of @a window. Most renderers will draw within
   * @a cell_area; the xalign, yalign, xpad, and ypad fields of the Gtk::CellRenderer
   * should be honored with respect to @a cell_area. @a background_area includes the
   * blank space around the cell, and also the area containing the tree expander;
   * so the @a background_area rectangles for all cells tile to cover the entire
   * @a window.  @a expose_area is a clip rectangle.
   * @param window A Gdk::Drawable to draw to.
   * @param widget The widget owning @a window.
   * @param background_area Entire cell area (including tree expanders and maybe padding on the sides).
   * @param cell_area Area normally rendered by a cell renderer.
   * @param expose_area Area that actually needs updating.
   * @param flags Flags that affect rendering.
   */
  void render(const Glib::RefPtr<Gdk::Window>& window, Widget& widget,
               Gdk::Rectangle& background_area, Gdk::Rectangle& cell_area, Gdk::Rectangle& expose_area,
						   CellRendererState flags);
  
  /** Passes an activate event to the cell renderer for possible processing.  Some
   * cell renderers may use events; for example, Gtk::CellRendererToggle toggles
   * when it gets a mouse click.
   * @param event A Gdk::Event.
   * @param widget Widget that received the event.
   * @param path Widget-dependent string representation of the event location; e.g. for Gtk::TreeView, a string representation of Gtk::TreePath.
   * @param background_area Background area as passed to @a gtk_cell_renderer_render.
   * @param cell_area Cell area as passed to @a gtk_cell_renderer_render.
   * @param flags Render flags.
   * @return <tt>true</tt> if the event was consumed/handled.
   */
  bool activate(GdkEvent* event, Widget& widget,
						   const Glib::ustring& path, Gdk::Rectangle& background_area, Gdk::Rectangle& cell_area,
						   CellRendererState flags);
  
  /** Passes an activate event to the cell renderer for possible processing.
   * @param event A Gdk::Event.
   * @param widget Widget that received the event.
   * @param path Widget-dependent string representation of the event location; e.g. for Gtk::TreeView, a string representation of Gtk::TreePath.
   * @param background_area Background area as passed to @a gtk_cell_renderer_render.
   * @param cell_area Cell area as passed to @a gtk_cell_renderer_render.
   * @param flags Render flags.
   * @return A new Gtk::CellEditable, or <tt>0</tt>.
   */
  GtkCellEditable* start_editing(GdkEvent* event, Widget& widget,
						   const Glib::ustring& path, Gdk::Rectangle& background_area, Gdk::Rectangle& cell_area,
						   CellRendererState  flags);
  
  /** Sets the renderer size to be explicit, independent of the properties set.
   * @param width The width of the cell renderer, or -1.
   * @param height The height of the cell renderer, or -1.
   */
  void set_fixed_size(int width, int height);
  
  /** Fills in @a width and @a height with the appropriate size of @a cell.
   * @param width Location to fill in with the fixed width of the widget, or <tt>0</tt>.
   * @param height Location to fill in with the fixed height of the widget, or <tt>0</tt>.
   */
  void get_fixed_size(int& width, int& height);


  Glib::PropertyProxy<CellRendererMode> property_mode();

  Glib::PropertyProxy<bool> property_visible();

  Glib::PropertyProxy<float> property_xalign();

  Glib::PropertyProxy<float> property_yalign();

  Glib::PropertyProxy<guint> property_xpad();

  Glib::PropertyProxy<guint> property_ypad();

  Glib::PropertyProxy<int> property_width();

  Glib::PropertyProxy<int> property_height();

  Glib::PropertyProxy<bool> property_is_expander();

  Glib::PropertyProxy<bool> property_is_expanded();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::CellRenderer */
  Gtk::CellRenderer* wrap(GtkCellRenderer* object, bool take_copy = false);
}
#endif /* _GTKMM_CELLRENDERER_H */

