#include <gdkmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>
extern "C"
{

//Declarations of the *_get_type() functions:

GType gdk_colormap_get_type(void);
GType gdk_drag_context_get_type(void);
GType gdk_drawable_get_type(void);
GType gdk_gc_get_type(void);
GType gdk_image_get_type(void);
GType gdk_pixbuf_get_type(void);
GType gdk_pixbuf_animation_get_type(void);
GType gdk_pixbuf_animation_iter_get_type(void);
GType gdk_pixbuf_loader_get_type(void);
GType gdk_visual_get_type(void);

//Declarations of the *_error_quark() functions:

GQuark gdk_pixbuf_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gdk {  class Colormap_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class DragContext_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class Drawable_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class GC_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class Image_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class Pixbuf_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class PixbufAnimation_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class PixbufAnimationIter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class PixbufLoader_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gdk {  class Visual_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

//Declarations of the *Error::throw_func() methods:

namespace Gdk {  class PixbufError { public: static void throw_func(GError*); };  }

namespace Gdk { 

void wrap_init()
{
  Glib::Error::register_domain(gdk_pixbuf_error_quark(), & Gdk::PixbufError::throw_func);
  Glib::wrap_register(gdk_colormap_get_type(), & Gdk::Colormap_Class::wrap_new);
  Glib::wrap_register(gdk_drag_context_get_type(), & Gdk::DragContext_Class::wrap_new);
  Glib::wrap_register(gdk_drawable_get_type(), & Gdk::Drawable_Class::wrap_new);
  Glib::wrap_register(gdk_gc_get_type(), & Gdk::GC_Class::wrap_new);
  Glib::wrap_register(gdk_image_get_type(), & Gdk::Image_Class::wrap_new);
  Glib::wrap_register(gdk_pixbuf_get_type(), & Gdk::Pixbuf_Class::wrap_new);
  Glib::wrap_register(gdk_pixbuf_animation_get_type(), & Gdk::PixbufAnimation_Class::wrap_new);
  Glib::wrap_register(gdk_pixbuf_animation_iter_get_type(), & Gdk::PixbufAnimationIter_Class::wrap_new);
  Glib::wrap_register(gdk_pixbuf_loader_get_type(), & Gdk::PixbufLoader_Class::wrap_new);
  Glib::wrap_register(gdk_visual_get_type(), & Gdk::Visual_Class::wrap_new);
} // wrap_init()

} //Gdk
