// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEITER_H
#define _GTKMM_TREEITER_H

#include <glibmm.h>

/* $Id: treeiter.hg,v 1.11 2002/04/08 17:20:02 daniel Exp $ */

/* treeiter.h
 *
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software, ) you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation, ) either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, ) without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library, ) if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iterator>
#include <gtkmmconfig.h>
#include <gtk/gtktreemodel.h>

GTKMM_USING_STD(forward_iterator_tag)


namespace Gtk
{

class TreeIterChildren;

/**
 * @ingroup TreeView
 */
class TreeIterBase
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeIterBase CppObjectType;
  typedef GtkTreeIter BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  TreeIterBase();
  TreeIterBase(const GtkTreeIter* gobject); // always takes a copy

  GtkTreeIter*       gobj()       { return &gobject_; }
  const GtkTreeIter* gobj() const { return &gobject_; }

protected:
  GtkTreeIter gobject_;

private:
  
  
};


/** The Gtk::TreeModel iterator.
 * @ingroup TreeView
 */
class TreeIter : public TreeIterBase
{
public:
  typedef std::forward_iterator_tag   iterator_category;
  typedef void                        value_type;
  typedef int                         difference_type;
  typedef void                        reference;
  typedef void                        pointer;

  TreeIter();

  TreeIter& operator++();
  const TreeIter operator++(int);

  const TreeIterChildren& children() const;
  TreeIter parent() const;

  bool equal(const TreeIter& other) const;
  operator bool() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

  explicit TreeIter(GtkTreeModel* model);
  TreeIter(GtkTreeModel* model, const GtkTreeIter* iter);

  void set_model_gobject(GtkTreeModel* model)
    { model_ = model; }

  void setup_end_iterator(const TreeIter& last_valid);

  const GtkTreeIter* get_gobject_if_not_end() const
    { return (!is_end_) ? &gobject_ : 0; }

  const GtkTreeIter* get_parent_gobject_if_end() const
    { return (is_end_ && gobject_.stamp) ? &gobject_ : 0; }

protected:
  GtkTreeModel* model_;
  bool          is_end_;

  friend class Gtk::TreeIterChildren;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
};

/** @relates Gtk::TreeIter */
inline bool operator==(const TreeIter& lhs, const TreeIter& rhs)
  { return lhs.equal(rhs); }

/** @relates Gtk::TreeIter */
inline bool operator!=(const TreeIter& lhs, const TreeIter& rhs)
  { return !lhs.equal(rhs); }


/** Virtual container of child nodes.
 * @ingroup TreeView
 */
class TreeIterChildren : private TreeIter
{
public:
  typedef TreeIter      value_type;
  typedef unsigned int  size_type;
  typedef int           difference_type;

  TreeIter begin() const;
  TreeIter end()   const;

  TreeIter operator[](unsigned int index) const;

  unsigned int size() const;
  bool empty() const;
  operator bool() const { return !this->empty(); }

#ifndef DOXYGEN_SHOULD_SKIP_THIS

  explicit TreeIterChildren(GtkTreeModel* model)
    : TreeIter(model) {}

  const GtkTreeIter* get_parent_gobject() const
    { return (gobject_.stamp != 0) ? &gobject_ : 0; }

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
};

} // namespace Gtk


namespace Glib
{

/** @relates Gtk::TreeIterBase */
Gtk::TreeIterBase& wrap(GtkTreeIter* object);

/** @relates Gtk::TreeIterBase */
const Gtk::TreeIterBase& wrap(const GtkTreeIter* object);

} // namespace Glib

#endif /* _GTKMM_TREEITER_H */

