// -*- c++ -*-
#ifndef _GLIBMM_OBJECTBASE_H
#define _GLIBMM_OBJECTBASE_H

/* $Id: objectbase.h,v 1.5 2002/02/28 18:58:16 daniel Exp $ */

/* objectbase.h
 * 
 * Copyright 2001 Free Software Foundation
 * Copyright 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* this file is critical for our compile times, no #includes to this
   header, please */


#include <sigc++/object.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GObject GObject;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Glib
{

#ifndef DOXYGEN_SHOULD_SKIP_THIS
class GSigConnectionNode;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

class ObjectBase : public SigC::Object
{
protected:
  ObjectBase();
  virtual ~ObjectBase() = 0;

  void initialize(GObject* castitem); //Called by Object and Interface constructors. See comments there.

public:
  virtual void reference()   const; // overrides SigC::ObjectBase::reference()
  virtual void unreference() const; // overrides SigC::ObjectBase::unreference()

  inline GObject*       gobj()       { return gobject_; }
  inline const GObject* gobj() const { return gobject_; }

  // Give a ref-ed copy to someone. Use for direct struct access.
  GObject* gobj_copy() const;

protected:
  GObject*  gobject_; // the GLib/GDK/GTK+ object instance
  bool      cpp_destruction_in_progress_;

  static  void destroy_notify_callback_(void* data);
  virtual void destroy_notify_();

  void _set_current_wrapper(GObject* object);
  static ObjectBase* _get_current_wrapper(GObject* object);

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  ObjectBase(const ObjectBase&);
  ObjectBase& operator=(const ObjectBase&); // not implemented
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual void set_manage(); // calls g_error()

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class Glib::GSigConnectionNode; // for GSigConnectionNode::notify()
#endif
};

} /* namespace Glib */

#endif /* _GLIBMM_OBJECTBASE_H */

