
#include <gtkmm/rc.h>
#include <gtkmm/private/rc_p.h>

// -*- c++ -*-
/* $Id: rc.ccg,v 1.16 2002/04/09 17:08:13 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtk/gtkrc.h>

namespace Gtk
{

RC::RC(const Glib::ustring &filename)
{
  //gtk_rc_init();
  gtk_rc_parse(filename.c_str());
}

Glib::RefPtr<Style>
RC::get_style(const Widget &widget)
{
  return Glib::wrap(gtk_rc_get_style(const_cast<GtkWidget*>(widget.gobj())));
}

void
RC::parse_string(const Glib::ustring &rc_string)
{
  gtk_rc_parse_string(const_cast<char*>(rc_string.c_str()));
}


void
RC::add_default_file(const Glib::ustring &filename)
{
  gtk_rc_add_default_file(const_cast<char*>(filename.c_str()));
}

void
RC::set_default_files(const Glib::ArrayHandle<Glib::ustring>& filenames)
{
  gtk_rc_set_default_files(const_cast<char**>(filenames.data()));
}

Glib::ArrayHandle<Glib::ustring>
RC::get_default_files()
{
  return Glib::ArrayHandle<Glib::ustring>(
      const_cast<const char**>(gtk_rc_get_default_files()), Glib::OWNERSHIP_NONE);
}

/* deprecated:
void
RC::add_widget_name_style(const Glib::RefPtr<const RcStyle>& style, const Glib::ustring &pattern)
{
  gtk_rc_add_widget_name_style(const_cast<GtkRcStyle*>(style->gobj()), const_cast<char*>(pattern.c_str()));
}

void
RC::add_widget_class_style(const Glib::RefPtr<const RcStyle>& style, const Glib::ustring &pattern)
{
  gtk_rc_add_widget_class_style(const_cast<GtkRcStyle*>(style->gobj()), const_cast<char*>(pattern.c_str()));
}

void
RC::add_class_style(const Glib::RefPtr<const RcStyle>& style, const Glib::ustring &pattern)
{
  gtk_rc_add_class_style(const_cast<GtkRcStyle*>(style->gobj()), const_cast<char*>(pattern.c_str()));
}
*/

bool
RC::reparse_all()
{
  return (gtk_rc_reparse_all()) ? true : false;
}


Glib::ustring
RC::find_pixmap_in_path(GtkSettings* context, GScanner *scanner,
			    const Glib::ustring &pixmap_file)
{
  return Glib::convert_return_gchar_ptr_to_ustring(
      gtk_rc_find_pixmap_in_path(context, scanner, const_cast<char*>(pixmap_file.c_str())));
}


Glib::ustring
RC::find_module_in_path(const Glib::ustring &module_file)
{
  return Glib::convert_return_gchar_ptr_to_ustring(
      gtk_rc_find_module_in_path(const_cast<char*>(module_file.c_str())));
}

Glib::ustring
RC::get_theme_dir()
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_rc_get_theme_dir());
}

Glib::ustring
RC::get_module_dir()
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_rc_get_module_dir());
}

}


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::RcStyle> wrap(GtkRcStyle* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::RcStyle>( dynamic_cast<Gtk::RcStyle*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType RcStyle_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_rc_style_get_type(), "gtkmm__RcStyle", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void RcStyle_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* RcStyle_Class::wrap_new(GObject* o)
{
  return new RcStyle((GtkRcStyle*)(o));
}


/* The implementation: */

GtkRcStyle* RcStyle::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<RcStyle> RcStyle::wrap_specific_type(GtkRcStyle* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<RcStyle> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    RcStyle* pCppObject = dynamic_cast<RcStyle*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<RcStyle>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<RcStyle>( new RcStyle(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

RcStyle::RcStyle(GtkRcStyle* castitem)
: Glib::Object((GObject*)(castitem))
{}

RcStyle::~RcStyle()
{
}

RcStyle::CppClassType RcStyle::rcstyle_class_; //Initialize static member.

GType RcStyle::get_type()
{
  return rcstyle_class_.get_type();
}

GType RcStyle::get_base_type()
{
  return gtk_rc_style_get_type();
}

RcStyle::RcStyle()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<RcStyle> RcStyle::create()
{
  return Glib::RefPtr<RcStyle>( new RcStyle() );
}


} // namespace Gtk

