
#include <gtkmm/menuitem.h>
#include <gtkmm/private/menuitem_p.h>

// -*- c++ -*-
/* $Id: menuitem.ccg,v 1.20 2002/04/02 13:25:18 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkmenuitem.h>
#include <gtk/gtkaccelmap.h>
#include <gtkmm/label.h>
#include <gtkmm/misc.h>
#include <gtkmm/menu.h>
#include <gtkmm/box.h>
#include <gtkmm/window.h>
#include <gtkmm/menubar.h>

// gtk_menu_item_(de)select are just a wrapper for gtk_item_(de)select
// and defined in Gtk_Item, so they do not be redefined here

namespace Gtk
{


MenuItem::MenuItem(const Glib::ustring& label, bool mnemonic /* = false */)
:
  Item((GtkItem*) g_object_new(get_type(), (char*)0))
{
  add_accel_label(label, mnemonic); /* Left-aligned label */
}

void MenuItem::add_accel_label(const Glib::ustring& str, bool mnemonic /* = true */)
{
  AccelLabel* label = manage(new AccelLabel(str, mnemonic));
  label->set_alignment(0.0, 0.5);

  add(*label);
  label->set_accel_widget(*this);
  label->show();
}

bool MenuItem::has_submenu() const
{
  return get_submenu() != 0;
}

void MenuItem::accelerate(Window& window)
{
  if(!accel_key_.is_null())
  {
    if(accel_key_.get_path().empty())
    {
      add_accelerator("activate", window.get_accel_group(), 
                      accel_key_.get_key(), accel_key_.get_mod(), ACCEL_VISIBLE);
    }
    else
    {
      gtk_accel_map_add_entry(accel_key_.get_path().c_str(),
                              accel_key_.get_key(),
                              (GdkModifierType)accel_key_.get_mod());

      Item::set_accel_path(accel_key_.get_path(), window.get_accel_group());
    }
  }

  if(has_submenu())
    get_submenu()->accelerate(window);
}

} // namespace Gtk


namespace
{

const Glib::SignalProxyInfo MenuItem_signal_activate_info =
{
  "activate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo MenuItem_signal_activate_item_info =
{
  "activate_item",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void MenuItem_signal_toggle_size_request_callback(GtkMenuItem*, gint* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,int*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo MenuItem_signal_toggle_size_request_info =
{
  "toggle_size_request",
  (GCallback) &MenuItem_signal_toggle_size_request_callback,
  (GCallback) &MenuItem_signal_toggle_size_request_callback
};


void MenuItem_signal_toggle_size_allocate_callback(GtkMenuItem*, gint p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo MenuItem_signal_toggle_size_allocate_info =
{
  "toggle_size_allocate",
  (GCallback) &MenuItem_signal_toggle_size_allocate_callback,
  (GCallback) &MenuItem_signal_toggle_size_allocate_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::MenuItem* wrap(GtkMenuItem* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::MenuItem *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType MenuItem_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_menu_item_get_type(), "gtkmm__MenuItem", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void MenuItem_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->activate = &activate_callback;
  klass->activate_item = &activate_item_callback;
  klass->toggle_size_request = &toggle_size_request_callback;
  klass->toggle_size_allocate = &toggle_size_allocate_callback;
}


void MenuItem_Class::activate_callback(GtkMenuItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_activate();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->activate)
      (*base->activate)(self);
  }
}

void MenuItem_Class::activate_item_callback(GtkMenuItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_activate_item();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->activate_item)
      (*base->activate_item)(self);
  }
}

void MenuItem_Class::toggle_size_request_callback(GtkMenuItem* self, gint* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_toggle_size_request(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggle_size_request)
      (*base->toggle_size_request)(self, p0);
  }
}

void MenuItem_Class::toggle_size_allocate_callback(GtkMenuItem* self, gint p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_toggle_size_allocate(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggle_size_allocate)
      (*base->toggle_size_allocate)(self, p0);
  }
}


Glib::ObjectBase* MenuItem_Class::wrap_new(GObject* o)
{
  return manage(new MenuItem((GtkMenuItem*)(o)));
}


/* The implementation: */

MenuItem::MenuItem(GtkMenuItem* castitem)
: Gtk::Item((GtkItem*)(castitem))
{}

MenuItem::~MenuItem()
{
  destroy_();
}

MenuItem::CppClassType MenuItem::menuitem_class_; //Initialize static member.

GType MenuItem::get_type()
{
  return menuitem_class_.get_type();
}

GType MenuItem::get_base_type()
{
  return gtk_menu_item_get_type();
}

MenuItem::MenuItem()
: Gtk::Item((GtkItem*)(g_object_new(get_type(), (char*)0)))
{}

void MenuItem::set_submenu(Menu& submenu)
{
  gtk_menu_item_set_submenu(gobj(), (submenu).Gtk::Widget::gobj());
}

Menu* MenuItem::get_submenu()
{
  return Glib::wrap((GtkMenu*)(gtk_menu_item_get_submenu(gobj())));
}

const Menu* MenuItem::get_submenu() const
{
  return Glib::wrap((GtkMenu*)(gtk_menu_item_get_submenu(const_cast<GtkMenuItem*>(gobj()))));
}

void MenuItem::remove_submenu()
{
  gtk_menu_item_remove_submenu(gobj());
}

void MenuItem::select()
{
  gtk_menu_item_select(gobj());
}

void MenuItem::deselect()
{
  gtk_menu_item_deselect(gobj());
}

void MenuItem::activate()
{
  gtk_menu_item_activate(gobj());
}

void MenuItem::toggle_size_request(int& requisition)
{
  gtk_menu_item_toggle_size_request(gobj(), &requisition);
}

void MenuItem::toggle_size_allocate(int allocation)
{
  gtk_menu_item_toggle_size_allocate(gobj(), allocation);
}

void MenuItem::set_right_justified(bool right_justified)
{
  gtk_menu_item_set_right_justified(gobj(), static_cast<int>(right_justified));
}

bool MenuItem::get_right_justified() const
{
  return gtk_menu_item_get_right_justified(const_cast<GtkMenuItem*>(gobj()));
}

void MenuItem::set_accel_path(const Glib::ustring& accel_path)
{
  gtk_menu_item_set_accel_path(gobj(), accel_path.c_str());
}


Glib::SignalProxy0<void> MenuItem::signal_activate()
{
  return Glib::SignalProxy0<void>(this, &MenuItem_signal_activate_info);
}

Glib::SignalProxy0<void> MenuItem::signal_activate_item()
{
  return Glib::SignalProxy0<void>(this, &MenuItem_signal_activate_item_info);
}

Glib::SignalProxy1<void,int*> MenuItem::signal_toggle_size_request()
{
  return Glib::SignalProxy1<void,int*>(this, &MenuItem_signal_toggle_size_request_info);
}

Glib::SignalProxy1<void,int> MenuItem::signal_toggle_size_allocate()
{
  return Glib::SignalProxy1<void,int>(this, &MenuItem_signal_toggle_size_allocate_info);
}


void Gtk::MenuItem::on_activate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->activate)
    (*base->activate)(gobj());
}

void Gtk::MenuItem::on_activate_item()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->activate_item)
    (*base->activate_item)(gobj());
}

void Gtk::MenuItem::on_toggle_size_request(int* requisition)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggle_size_request)
    (*base->toggle_size_request)(gobj(),requisition);
}

void Gtk::MenuItem::on_toggle_size_allocate(int allocation)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggle_size_allocate)
    (*base->toggle_size_allocate)(gobj(),allocation);
}


} // namespace Gtk

