
#include <gtkmm/cellrenderer.h>
#include <gtkmm/private/cellrenderer_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: cellrenderer.ccg,v 1.1 2001/10/31 10:49:51 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtkcellrenderer.h>


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gtk::CellRendererMode>::value_type()
{
  return gtk_cell_renderer_mode_get_type();
}

// static
GType Glib::Value<Gtk::CellRendererState>::value_type()
{
  return gtk_cell_renderer_state_get_type();
}


namespace Glib
{

Gtk::CellRenderer* wrap(GtkCellRenderer* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::CellRenderer *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType CellRenderer_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_cell_renderer_get_type(), "gtkmm__CellRenderer", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void CellRenderer_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->get_size = &get_size_vfunc_callback;
  klass->render = &render_vfunc_callback;
  klass->activate = &activate_vfunc_callback;
  klass->start_editing = &start_editing_vfunc_callback;
}


void CellRenderer_Class::get_size_vfunc_callback(GtkCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->get_size(widget, cell_area, x_offset
, y_offset
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->get_size)
      (*base->get_size)(self, widget, cell_area, x_offset, y_offset, width, height);
  }
}

void CellRenderer_Class::render_vfunc_callback(GtkCellRenderer* self, GdkWindow* window, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GdkRectangle* expose_area, GtkCellRendererState flags)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->render(window, widget, background_area, cell_area, expose_area, ((CellRendererState)(flags))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->render)
      (*base->render)(self, window, widget, background_area, cell_area, expose_area, flags);
  }
}

gboolean CellRenderer_Class::activate_vfunc_callback(GtkCellRenderer* self, GdkEvent* event, GtkWidget* widget, const gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->activate(event, widget, path
, background_area, cell_area, ((CellRendererState)(flags))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->activate)
      (*base->activate)(self, event, widget, path, background_area, cell_area, flags);
  }

  typedef gboolean RType;
  return RType();
}

GtkCellEditable* CellRenderer_Class::start_editing_vfunc_callback(GtkCellRenderer* self, GdkEvent* event, GtkWidget* widget, const gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->start_editing(event, widget, path
, background_area, cell_area, ((CellRendererState)(flags))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->start_editing)
      (*base->start_editing)(self, event, widget, path, background_area, cell_area, flags);
  }

  typedef GtkCellEditable* RType;
  return RType();
}


Glib::ObjectBase* CellRenderer_Class::wrap_new(GObject* o)
{
  return manage(new CellRenderer((GtkCellRenderer*)(o)));
}


/* The implementation: */

CellRenderer::CellRenderer(GtkCellRenderer* castitem)
: Gtk::Object((GtkObject*)(castitem))
{}

CellRenderer::~CellRenderer()
{
  destroy_();
}

CellRenderer::CppClassType CellRenderer::cellrenderer_class_; //Initialize static member.

GType CellRenderer::get_type()
{
  return cellrenderer_class_.get_type();
}

GType CellRenderer::get_base_type()
{
  return gtk_cell_renderer_get_type();
}

void CellRenderer::get_size(Widget& widget, Gdk::Rectangle& cell_area, int& x_offset, int& y_offset, int& width, int& height)
{
  gtk_cell_renderer_get_size(gobj(), (widget).Gtk::Widget::gobj(), (cell_area).gobj(), &x_offset, &y_offset, &width, &height);
}

void CellRenderer::render(const Glib::RefPtr<Gdk::Window>& window, Widget& widget, Gdk::Rectangle& background_area, Gdk::Rectangle& cell_area, Gdk::Rectangle& expose_area, CellRendererState flags)
{
  gtk_cell_renderer_render(gobj(), Glib::unwrap(window), (widget).Gtk::Widget::gobj(), (background_area).gobj(), (cell_area).gobj(), (expose_area).gobj(), ((GtkCellRendererState)(flags)));
}

bool CellRenderer::activate(GdkEvent* event, Widget& widget, const Glib::ustring& path, Gdk::Rectangle& background_area, Gdk::Rectangle& cell_area, CellRendererState flags)
{
  return gtk_cell_renderer_activate(gobj(), event, (widget).Gtk::Widget::gobj(), path.c_str(), (background_area).gobj(), (cell_area).gobj(), ((GtkCellRendererState)(flags)));
}

GtkCellEditable* CellRenderer::start_editing(GdkEvent* event, Widget& widget, const Glib::ustring& path, Gdk::Rectangle& background_area, Gdk::Rectangle& cell_area, CellRendererState flags)
{
  return gtk_cell_renderer_start_editing(gobj(), event, (widget).Gtk::Widget::gobj(), path.c_str(), (background_area).gobj(), (cell_area).gobj(), ((GtkCellRendererState)(flags)));
}

void CellRenderer::set_fixed_size(int width, int height)
{
  gtk_cell_renderer_set_fixed_size(gobj(), width, height);
}

void CellRenderer::get_fixed_size(int& width, int& height)
{
  gtk_cell_renderer_get_fixed_size(gobj(), &width, &height);
}


Glib::PropertyProxy<CellRendererMode> CellRenderer::property_mode()
{
  return Glib::PropertyProxy<CellRendererMode>(this, "mode");
}

Glib::PropertyProxy<bool> CellRenderer::property_visible()
{
  return Glib::PropertyProxy<bool>(this, "visible");
}

Glib::PropertyProxy<float> CellRenderer::property_xalign()
{
  return Glib::PropertyProxy<float>(this, "xalign");
}

Glib::PropertyProxy<float> CellRenderer::property_yalign()
{
  return Glib::PropertyProxy<float>(this, "yalign");
}

Glib::PropertyProxy<guint> CellRenderer::property_xpad()
{
  return Glib::PropertyProxy<guint>(this, "xpad");
}

Glib::PropertyProxy<guint> CellRenderer::property_ypad()
{
  return Glib::PropertyProxy<guint>(this, "ypad");
}

Glib::PropertyProxy<int> CellRenderer::property_width()
{
  return Glib::PropertyProxy<int>(this, "width");
}

Glib::PropertyProxy<int> CellRenderer::property_height()
{
  return Glib::PropertyProxy<int>(this, "height");
}

Glib::PropertyProxy<bool> CellRenderer::property_is_expander()
{
  return Glib::PropertyProxy<bool>(this, "is_expander");
}

Glib::PropertyProxy<bool> CellRenderer::property_is_expanded()
{
  return Glib::PropertyProxy<bool>(this, "is_expanded");
}


void Gtk::CellRenderer::get_size(GtkWidget * widget, GdkRectangle * cell_area, int * x_offset, int * y_offset, int * width, int * height)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->get_size)
    (*base->get_size)(gobj(),widget,cell_area,x_offset,y_offset,width,height);
}

void Gtk::CellRenderer::render(GdkWindow * window, GtkWidget * widget, GdkRectangle * background_area, GdkRectangle * cell_area, GdkRectangle * expose_area, CellRendererState flags)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->render)
    (*base->render)(gobj(),window,widget,background_area,cell_area,expose_area,((GtkCellRendererState)(flags)));
}

gboolean Gtk::CellRenderer::activate(GdkEvent * event, GtkWidget * widget, const char * path, GdkRectangle * background_area, GdkRectangle * cell_area, CellRendererState flags)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->activate)
    return (*base->activate)(gobj(),event,widget,path,background_area,cell_area,((GtkCellRendererState)(flags)));

  typedef gboolean RType;
  return RType();
}

GtkCellEditable* Gtk::CellRenderer::start_editing(GdkEvent * event, GtkWidget * widget, const char * path, GdkRectangle * background_area, GdkRectangle * cell_area, CellRendererState flags)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->start_editing)
    return (*base->start_editing)(gobj(),event,widget,path,background_area,cell_area,((GtkCellRendererState)(flags)));

  typedef GtkCellEditable* RType;
  return RType();
}


} // namespace Gtk

