
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/dragcontext.h>
#include <gdkmm/private/dragcontext_p.h>

#include <gdk/gdkenumtypes.h>
// -*- c++ -*-
/* $Id: dragcontext.ccg,v 1.2 2002/03/09 00:06:10 murrayc Exp $ */

/*
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkdnd.h>

namespace Gdk
{

//Glib::ListHandle<GdkAtom> DragContext::get_targets() const
//{
//  return gobj()->targets;
//}

} /* namespace Gdk */

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::DragAction>::value_type()
{
  return gdk_drag_action_get_type();
}

// static
GType Glib::Value<Gdk::DragProtocol>::value_type()
{
  return gdk_drag_protocol_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::DragContext> wrap(GdkDragContext* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gdk::DragContext>( dynamic_cast<Gdk::DragContext*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

GType DragContext_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gdk_drag_context_get_type(), "gdkmm__DragContext", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void DragContext_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* DragContext_Class::wrap_new(GObject* o)
{
  return new DragContext((GdkDragContext*)(o));
}


/* The implementation: */

GdkDragContext* DragContext::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<DragContext> DragContext::wrap_specific_type(GdkDragContext* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<DragContext> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    DragContext* pCppObject = dynamic_cast<DragContext*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<DragContext>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<DragContext>( new DragContext(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

DragContext::DragContext(GdkDragContext* castitem)
: Glib::Object((GObject*)(castitem))
{}

DragContext::~DragContext()
{
}

DragContext::CppClassType DragContext::dragcontext_class_; //Initialize static member.

GType DragContext::get_type()
{
  return dragcontext_class_.get_type();
}

GType DragContext::get_base_type()
{
  return gdk_drag_context_get_type();
}

DragContext::DragContext()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<DragContext> DragContext::create()
{
  return Glib::RefPtr<DragContext>( new DragContext() );
}
void DragContext::drag_status(DragAction action, guint32 time)
{
  gdk_drag_status(gobj(), ((GdkDragAction)(action)), time);
}

void DragContext::drop_reply(bool ok, guint32 time)
{
  gdk_drop_reply(gobj(), static_cast<int>(ok), time);
}

void DragContext::drop_finish(bool success, guint32 time)
{
  gdk_drop_finish(gobj(), static_cast<int>(success), time);
}

GdkAtom DragContext::get_selection()
{
  return gdk_drag_get_selection(gobj());
}

void DragContext::drag_finish(bool success, bool del, guint32 time)
{
  gtk_drag_finish(gobj(), static_cast<int>(success), static_cast<int>(del), time);
}

void DragContext::set_icon(const Glib::RefPtr<Gdk::Colormap>& colormap, const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask, int hot_x, int hot_y)
{
  gtk_drag_set_icon_pixmap(gobj(), Glib::unwrap(colormap), Glib::unwrap(pixmap), Glib::unwrap(mask), hot_x, hot_y);
}

void DragContext::set_icon(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, int hot_x, int hot_y)
{
  gtk_drag_set_icon_pixbuf(gobj(), Glib::unwrap(pixbuf), hot_x, hot_y);
}

void DragContext::set_icon(const Glib::ustring& stock_id, int hot_x, int hot_y)
{
  gtk_drag_set_icon_stock(gobj(), stock_id.c_str(), hot_x, hot_y);
}

void DragContext::set_icon()
{
  gtk_drag_set_icon_default(gobj());
}

DragProtocol DragContext::get_protocol() const
{
  return ((DragProtocol)(gobj()->protocol));
}

bool DragContext::get_is_source() const
{
  return gobj()->is_source;
}

DragAction DragContext::get_actions() const
{
  return ((DragAction)(gobj()->actions));
}

DragAction DragContext::get_suggested_action() const
{
  return ((DragAction)(gobj()->suggested_action));
}

DragAction DragContext::get_action() const
{
  return ((DragAction)(gobj()->action));
}

guint32 DragContext::get_start_time() const
{
  return gobj()->start_time;
}


} // namespace Gdk

