#include <gtkmm/progressbar.h>
#include <gtkmm/table.h>
#include <gtkmm/label.h>
#include <gtkmm/button.h>
#include <gtkmm/main.h>
#include <gtkmm/window.h>

// gtkmm version of the "progress bar" example from the gtk+ tutorial

class ProgressExample : public Gtk::Window
{
public:
  ProgressExample();

protected:
  //Signal handlers:
  virtual bool on_timeout();
  virtual void on_reset_clicked() { m_pstat = false; }

  bool m_pstat;
  Gtk::Button m_ButtonReset, m_ButtonCancel;
  Gtk::Label m_label;
  Gtk::ProgressBar m_ProgressBar;
  Gtk::Table m_table;
};

ProgressExample::ProgressExample()
:
  m_pstat(true),
  m_ButtonReset("Reset"), m_ButtonCancel("Cancel"),
  m_label("Progress Bar Example"),
  m_table(3,2, true)
{
  set_border_width(10);
  add(m_table);

  m_table.attach(m_label, 0,2,0,1);
  m_table.attach(m_ProgressBar, 0,2,0,2);

  // Set the timeout to handle automatic updating of the progress bar
  Glib::signal_timeout().connect(slot(*this, &ProgressExample::on_timeout), 50);

  m_ButtonReset.signal_clicked().connect(slot(*this, &ProgressExample::on_reset_clicked));
  m_table.attach(m_ButtonReset, 0,1,2,3);

  m_ButtonCancel.signal_clicked().connect(SigC::slot(*this, &ProgressExample::hide));

  m_table.attach(m_ButtonCancel, 1,2,2,3);

  show_all();
}

bool ProgressExample::on_timeout()
{
  double fraction = m_ProgressBar.get_fraction();

  fraction += 0.01;

  if(fraction >= 1.0 || !m_pstat)
  {
    fraction = 0.0;
    m_pstat  = true;
  }

  m_ProgressBar.set_fraction(fraction);

  return true;
}


int main(int argc, char** argv)
{
  Gtk::Main myapp(argc, argv);

  ProgressExample window;
  myapp.run(window);

  return 0;
}

