#include <gtkmm/scrolledwindow.h>
#include <gtkmm/main.h>
#include <gtkmm/scrollbar.h>
#include <gtkmm/window.h>
#include <gtkmm/textview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include <gtkmm/cellrenderertext.h>
#include <gtkmm/paned.h>
  
class AppMessages: public Gtk::ScrolledWindow 
{
public:
  AppMessages();
  virtual ~AppMessages();

protected:
  Glib::RefPtr<Gtk::ListStore> m_refListStore;
  Gtk::TreeView m_TreeView;
  Gtk::CellRendererText m_Cell;
  Gtk::TreeViewColumn m_Column;
};

/* Create the list of "messages" */
AppMessages::AppMessages()
{
  /* Create a new scrolled window, with scrollbars only if needed */
  set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  add(m_TreeView);

  /* create list store */
  Gtk::TreeModelColumnRecord columns;
  Gtk::TreeModelColumn<Glib::ustring> column0;
  columns.add( column0 );

  m_refListStore = Gtk::ListStore::create(columns);

  m_TreeView.set_model(m_refListStore);
  m_TreeView.show();


  /* Add some messages to the window */
  for(int i = 0; i < 10; i++)
  {
    Gtk::TreeIter iter = m_refListStore->append();
    m_refListStore->set_value(iter, column0, Glib::ustring("message"));
  }

  enum
  {
    COLUMN_MESSAGES,
    COLUMN_TEXT,
    NUM_COLUMNS
  };
  m_Column.add_attribute(m_Cell, "Messages", COLUMN_MESSAGES);
  m_Column.add_attribute(m_Cell, "Text", COLUMN_TEXT);

  m_TreeView.append_column(m_Column);
}

AppMessages::~AppMessages()
{
}


class AppText : public Gtk::ScrolledWindow
{
public:
  AppText();
  virtual ~AppText();

  virtual void insert_text();

protected:
  Gtk::TextView m_TextView;
};
   
/* Create a scrolled text area that displays a "message" */
AppText::AppText()
{
  set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  add(m_TextView);
  insert_text();
  m_TextView.show();
}

AppText::~AppText()
{
}

void AppText::insert_text()
{
  Glib::RefPtr<Gtk::TextBuffer> refTextBuffer = m_TextView.get_buffer();

  Gtk::TextIter iter = refTextBuffer->get_iter_at_offset(0);
  refTextBuffer->insert(iter,
    "From: pathfinder@nasa.gov\n"
    "To: mom@nasa.gov\n"
    "Subject: Made it!\n"
    "\n"
    "We just got in this morning. The weather has been\n"
    "great - clear but cold, and there are lots of fun sights.\n"
    "Sojourner says hi. See you soon.\n"
    " -Path\n");
}

class AppWindow : public Gtk::Window
{
public:
  AppWindow();
  virtual ~AppWindow();

protected:
  Gtk::Paned m_VPaned;
  AppMessages m_AppMessages;
  AppText m_AppText;
};

   
AppWindow::AppWindow()
{
  set_title ("Paned Windows");
  set_border_width (10);
  set_size_request (450, 400);

  /* Add a vpaned widget to our toplevel window */
  add(m_VPaned);

  /* Now add the contents of the two halves of the window */
  m_VPaned.add1(m_AppMessages);
  m_VPaned.add2(m_AppText);

  show_all ();
}

AppWindow::~AppWindow()
{}


int main(int argc, char *argv[] )
{
  /* Initialise GTK */
  Gtk::Main kit(&argc, &argv);

  /* Create a new window */
  AppWindow app;

  /* Enter the event loop */
  Gtk::Main::run(app);

  return(0);
}

