;
; NSIS script for gtkglextmm Win32 binary installer.
;
; written by Naofumi Yasufuku <naofumi@users.sourceforge.net>
;
; about NSIS, see http://nsis.sourceforge.net/
;

!define GTKGLEXTMM_VERSION         1.0.0
!define GTKGLEXTMM_API_VERSION     1.0
!define GTKGLEXTMM_PUBLISHER       "GtkGLExt"
!define GTKGLEXTMM_URL_INFO_ABOUT  "http://gtkglext.sourceforge.net/"
!define GTKGLEXTMM_URL_UPDATE_INFO "http://sourceforge.net/projects/gtkglext/"
!define GTKGLEXTMM_HELP_LINK       "mailto:gtkglext-users@lists.sourceforge.net"

;--------------------------------
;Configuration

OutFile gtkglextmm-win32-${GTKGLEXTMM_VERSION}.exe
SetCompressor bzip2

InstType "Full (Runtime w/ Development and Examples)"
InstType "Runtime (w/o Development and Examples)"

ShowInstDetails show
ShowUninstDetails show
SetDateSave on

; the default installation drive is changed by .onInit
InstallDir C:\GtkGLExt\${GTKGLEXTMM_API_VERSION}
InstallDirRegKey HKLM SOFTWARE\gtkglextmm\${GTKGLEXTMM_API_VERSION} "Path"

;--------------------------------
;Modern UI Configuration

!include "MUI.nsh"

!define MUI_PRODUCT "gtkglextmm"
!define MUI_VERSION "${GTKGLEXTMM_VERSION}"

!define MUI_NAME "${MUI_PRODUCT} ${MUI_VERSION}" ;Installer name

!define MUI_WELCOMEPAGE
!define MUI_LICENSEPAGE
!define MUI_COMPONENTSPAGE
  !define MUI_COMPONENTSPAGE_SMALLDESC
!define MUI_DIRECTORYPAGE
!define MUI_STARTMENUPAGE
  ;$9 is being used to store the Start Menu Folder.
  ;Do not use this variable in your script (or Push/Pop it)!
  ;To change this variable, use MUI_STARTMENUPAGE_VARIABLE.
  !define MUI_STARTMENUPAGE_DEFAULTFOLDER "${MUI_PRODUCT} ${GTKGLEXTMM_API_VERSION}"
  !define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKLM"
  !define MUI_STARTMENUPAGE_REGISTRY_KEY "SOFTWARE\gtkglextmm\${GTKGLEXTMM_API_VERSION}"
  !define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "StartMenuFolder"
!define MUI_FINISHPAGE
  ;!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\Docs\index.html"
  !define MUI_FINISHPAGE_NOAUTOCLOSE
  !define MUI_FINISHPAGE_NOREBOOTSUPPORT

!define MUI_ABORTWARNING

!define MUI_UNINSTALLER
!define MUI_UNCONFIRMPAGE

;--------------------------------
;Languages

!define MUI_TEXT_WELCOME_INFO_TEXT "This wizard will guide you through the installation of gtkglextmm, C++ Wrapper for GtkGLExt.\r\n\r\n\r\n"

!insertmacro MUI_LANGUAGE "English"
  
;--------------------------------
;Reserve Files

!insertmacro MUI_RESERVEFILE_WELCOMEFINISHPAGE

;--------------------------------
;Data

LicenseData COPYING.LIB

;--------------------------------
;Installer Sections

Section "gtkglextmm Runtime" SecRuntime
  SectionIn 1 2 RO

  SetOutPath $INSTDIR\bin
  File bin\*.dll

  ; Registry
  WriteRegStr HKLM "SOFTWARE\gtkglextmm\${GTKGLEXTMM_API_VERSION}\Runtime" "Path" "$INSTDIR"
  WriteRegStr HKLM "SOFTWARE\gtkglextmm\${GTKGLEXTMM_API_VERSION}\Runtime" "Version" "${GTKGLEXTMM_VERSION}"

SectionEnd

Section "gtkglextmm Development" SecDevelopment
  SectionIn 1

  SetOutPath $INSTDIR\include\gtkglextmm-${GTKGLEXTMM_API_VERSION}
  File include\gtkglextmm-${GTKGLEXTMM_API_VERSION}\*.h

  SetOutPath $INSTDIR\include\gtkglextmm-${GTKGLEXTMM_API_VERSION}\gdkmm\gl
  File include\gtkglextmm-${GTKGLEXTMM_API_VERSION}\gdkmm\gl\*.h

  SetOutPath $INSTDIR\include\gtkglextmm-${GTKGLEXTMM_API_VERSION}\gdkmm\gl\private
  File include\gtkglextmm-${GTKGLEXTMM_API_VERSION}\gdkmm\gl\private\*.h

  SetOutPath $INSTDIR\include\gtkglextmm-${GTKGLEXTMM_API_VERSION}
  File include\gtkglextmm-${GTKGLEXTMM_API_VERSION}\*.h

  SetOutPath $INSTDIR\include\gtkglextmm-${GTKGLEXTMM_API_VERSION}\gtkmm\gl
  File include\gtkglextmm-${GTKGLEXTMM_API_VERSION}\gtkmm\gl\*.h

  SetOutPath $INSTDIR\lib\gtkglextmm-${GTKGLEXTMM_API_VERSION}\include
  File lib\gtkglextmm-${GTKGLEXTMM_API_VERSION}\include\gdkglextmm-config.h

  SetOutPath $INSTDIR\lib\gtkglextmm-${GTKGLEXTMM_API_VERSION}\proc\m4
  File lib\gtkglextmm-${GTKGLEXTMM_API_VERSION}\proc\m4\*.m4

  SetOutPath $INSTDIR\lib
  File lib\*.a

  SetOutPath $INSTDIR\lib\pkgconfig
  File lib\pkgconfig\*.pc

  SetOutPath $INSTDIR\share\aclocal
  File share\aclocal\*.m4

  SetOutPath $INSTDIR\share\doc\gtkglextmm-${GTKGLEXTMM_API_VERSION}\html
  File share\doc\gtkglextmm-${GTKGLEXTMM_API_VERSION}\html\*.html
  File share\doc\gtkglextmm-${GTKGLEXTMM_API_VERSION}\html\*.css
  File share\doc\gtkglextmm-${GTKGLEXTMM_API_VERSION}\html\*.png
  File share\doc\gtkglextmm-${GTKGLEXTMM_API_VERSION}\html\*.dot

  ; Update .pc files
  ; short name will cause a problem with current libtool :-<
  ;GetFullPathName /SHORT $0 $INSTDIR
  StrCpy $0 $INSTDIR
  Push $0
  Call ChangeDirSeparator
  Pop $0

  DetailPrint "Updating $INSTDIR\lib\pkgconfig\gdkglextmm-${GTKGLEXTMM_API_VERSION}.pc"
  Push $INSTDIR\lib\pkgconfig\gdkglextmm-${GTKGLEXTMM_API_VERSION}.pc
  Push $0
  Call UpdatePCFile
  DetailPrint "Done"

  DetailPrint "Updating $INSTDIR\lib\pkgconfig\gdkglextmm-win32-${GTKGLEXTMM_API_VERSION}.pc"
  Push $INSTDIR\lib\pkgconfig\gdkglextmm-win32-${GTKGLEXTMM_API_VERSION}.pc
  Push $0
  Call UpdatePCFile
  DetailPrint "Done"

  DetailPrint "Updating $INSTDIR\lib\pkgconfig\gtkglextmm-${GTKGLEXTMM_API_VERSION}.pc"
  Push $INSTDIR\lib\pkgconfig\gtkglextmm-${GTKGLEXTMM_API_VERSION}.pc
  Push $0
  Call UpdatePCFile
  DetailPrint "Done"

  DetailPrint "Updating $INSTDIR\lib\pkgconfig\gtkglextmm-win32-${GTKGLEXTMM_API_VERSION}.pc"
  Push $INSTDIR\lib\pkgconfig\gtkglextmm-win32-${GTKGLEXTMM_API_VERSION}.pc
  Push $0
  Call UpdatePCFile
  DetailPrint "Done"

  ; Registry
  WriteRegStr HKLM "SOFTWARE\gtkglextmm\${GTKGLEXTMM_API_VERSION}\Development" "Path" "$INSTDIR"
  WriteRegStr HKLM "SOFTWARE\gtkglextmm\${GTKGLEXTMM_API_VERSION}\Development" "Version" "${GTKGLEXTMM_VERSION}"

SectionEnd

Section "gtkglextmm Examples" SecExamples
  SectionIn 1

  SetOutPath $INSTDIR\gtkglextmm-examples
  File gtkglextmm-examples\Makefile.mingw
  File gtkglextmm-examples\*.h
  File gtkglextmm-examples\*.cc
  File gtkglextmm-examples\*.c
  File gtkglextmm-examples\*.exe

SectionEnd

Section "Start Menu" SecStartMenu
  SectionIn 1 2

  ;Create shortcuts
  SetShellVarContext all
  !insertmacro MUI_STARTMENU_WRITE_BEGIN    

    CreateDirectory "$SMPROGRAMS\${MUI_STARTMENUPAGE_VARIABLE}"

    WriteINIStr "$SMPROGRAMS\${MUI_STARTMENUPAGE_VARIABLE}\GtkGLExt Website.url" "InternetShortcut" "URL" "http://gtkglext.sourceforge.net/"

    IfFileExists "$INSTDIR\share\doc\gtkglextmm-${GTKGLEXTMM_API_VERSION}\html\index.html" "" +2
      CreateShortCut "$SMPROGRAMS\${MUI_STARTMENUPAGE_VARIABLE}\gtkglextmm Documentation.lnk" "$INSTDIR\share\doc\gtkglextmm-${GTKGLEXTMM_API_VERSION}\html\index.html"

    CreateShortCut "$SMPROGRAMS\${MUI_STARTMENUPAGE_VARIABLE}\Uninstall gtkglextmm.lnk" "$INSTDIR\uninst-gtkglextmm.exe"

  !insertmacro MUI_STARTMENU_WRITE_END

SectionEnd

Section -post

  ; Write $INSTDIR\bin\gtkglextmm-env.sh
  DetailPrint "Generating $INSTDIR\bin\gtkglextmm-env.sh"
  Push $INSTDIR\bin\gtkglextmm-env.sh
  Call WriteEnvSh
  DetailPrint "Done"

  ; Registry
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\gtkglextmm" "DisplayName" "${MUI_PRODUCT} ${MUI_VERSION}"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\gtkglextmm" "DisplayVersion" "${MUI_VERSION}"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\gtkglextmm" "Publisher" "${GTKGLEXTMM_PUBLISHER}"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\gtkglextmm" "URLInfoAbout" "${GTKGLEXTMM_URL_INFO_ABOUT}"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\gtkglextmm" "URLUpdateInfo" "${GTKGLEXTMM_URL_UPDATE_INFO}"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\gtkglextmm" "HelpLink" "${GTKGLEXTMM_HELP_LINK}"
  WriteRegExpandStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\gtkglextmm" "UninstallString" "$INSTDIR\uninst-gtkglextmm.exe"

  ;; Uninstaller
  Delete $INSTDIR\uninst-gtkglextmm.exe
  WriteUninstaller $INSTDIR\uninst-gtkglextmm.exe

SectionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecRuntime} "gtkglextmm runtime libraries"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecDevelopment} "gtkglextmm development headers, libraries, and documentations"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecExamples} "gtkglextmm example programs"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecStartMenu} "Adds icons to your start menu for easy access"
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END

;--------------------------------
;Installer Functions

Function .onInit
  ; Change the default installation drive
  StrLen $R0 $INSTDIR
  StrCpy $R1 $INSTDIR $R0 1
  StrCpy $INSTDIR $PROGRAMFILES 1
  StrCpy $INSTDIR "$INSTDIR$R1"
FunctionEnd

; ChangeDirSeparator
; input, top of stack  (e.g. C:\Program Files\...)
; output, top of stack (replaces, with e.g. C:/Program Files/...)
; modifies no other variables.
Function ChangeDirSeparator
  Exch $R0
  Push $R1
  Push $R2
  Push $R3
    StrCpy $R1 $R0
    StrCpy $R0 ""
    StrCpy $R2 0
    goto loop
    replace:
      StrCpy $R0 "$R0/"
    loop:
      StrCpy $R3 $R1 1 $R2
      IntOp $R2 $R2 + 1
      StrCmp $R3 "\" replace
      StrCmp $R3 "" done
      StrCpy $R0 "$R0$R3"
      goto loop
    done:
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd

; UpdatePCFile
; update pkg-config .pc file
Function UpdatePCFile
  Pop $R0 ; prefix
  Pop $R1 ; target .pc file
  Push $R7
  Push $R8
  Push $R9
    Rename $R1 $R1.orig
    FileOpen $R7 $R1.orig r
    FileOpen $R8 $R1 w
    FileRead $R7 $R9 ; skip original prefix
    FileWrite $R8 "prefix=$R0$\n"
    loop:
      FileRead $R7 $R9
      StrCmp $R9 "" done
      FileWrite $R8 $R9
      goto loop
    done:
    FileClose $R7
    FileClose $R8
    Delete $R1.orig
  Pop $R9
  Pop $R8
  Pop $R7
FunctionEnd

; WriteEnvSh
Function WriteEnvSh
  Pop $R0 ; Output file
  Push $R8
  Push $R9
    GetFullPathName /SHORT $R8 $INSTDIR
    Push $R8
    Call ChangeDirSeparator
    Pop $R8
    FileOpen $R9 $R0 w
    FileWrite $R9 "#!/bin/sh$\n"
    FileWrite $R9 "$\n"
    FileWrite $R9 "export GTKGLEXTMM_PREFIX=$R8$\n"
    FileWrite $R9 "$\n"
    FileWrite $R9 "echo $\"Setting environment variables for gtkglextmm.$\"$\n"
    FileWrite $R9 "echo $\"$\"$\n"
    FileWrite $R9 "$\n"
    FileWrite $R9 "case $$TERM in$\n"
    FileWrite $R9 "cygwin)$\n"
    FileWrite $R9 "  GTKGLEXTMM_PATH=`cygpath -u $${GTKGLEXTMM_PREFIX}/bin`$\n"
    FileWrite $R9 "  ;;$\n"
    FileWrite $R9 "msys)$\n"
    FileWrite $R9 "  GTKGLEXTMM_PATH=/$${GTKGLEXTMM_PREFIX%:*}$${GTKGLEXTMM_PREFIX#*:}/bin$\n"
    FileWrite $R9 "  ;;$\n"
    FileWrite $R9 "*)$\n"
    FileWrite $R9 "  echo $\"Unknown TERM$\"$\n"
    FileWrite $R9 "  ;;$\n"
    FileWrite $R9 "esac$\n"
    FileWrite $R9 "$\n"
    FileWrite $R9 "echo $\"export PATH=\$\"$${GTKGLEXTMM_PATH}:\$${PATH}\$\"$\"$\n"
    FileWrite $R9 "export PATH=$\"$${GTKGLEXTMM_PATH}:$${PATH}$\"$\n"
    FileWrite $R9 "$\n"
    FileWrite $R9 "echo $\"export PKG_CONFIG_PATH=\$\"$${GTKGLEXTMM_PREFIX}/lib/pkgconfig;\$${PKG_CONFIG_PATH}\$\"$\"$\n"
    FileWrite $R9 "export PKG_CONFIG_PATH=$\"$${GTKGLEXTMM_PREFIX}/lib/pkgconfig;$${PKG_CONFIG_PATH}$\"$\n"
    FileWrite $R9 "$\n"
    FileWrite $R9 "echo $\"$\"$\n"
    FileClose $R9
  Pop $R9
  Pop $R8
FunctionEnd

;--------------------------------
;Uninstaller Section

Section Uninstall

  ;Remove shortcut
  SetShellVarContext all
  ReadRegStr $0 "${MUI_STARTMENUPAGE_REGISTRY_ROOT}" "${MUI_STARTMENUPAGE_REGISTRY_KEY}" "${MUI_STARTMENUPAGE_REGISTRY_VALUENAME}"
  StrCmp $0 "" noshortcuts
    Delete "$SMPROGRAMS\$0\GtkGLExt Website.url"
    Delete "$SMPROGRAMS\$0\gtkglextmm Documentation.lnk"
    Delete "$SMPROGRAMS\$0\Uninstall gtkglextmm.lnk"
    RMDir "$SMPROGRAMS\$0" ;Only if empty, so it won't delete other shortcuts
  noshortcuts:

  DeleteRegKey HKLM "SOFTWARE\gtkglextmm\${GTKGLEXTMM_API_VERSION}"
  DeleteRegKey HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\gtkglextmm"

  Delete $INSTDIR\uninst-gtkglextmm.exe

  ; bin

  Delete $INSTDIR\bin\gtkglextmm-env.sh
  Delete $INSTDIR\bin\libgdkglextmm-win32-${GTKGLEXTMM_API_VERSION}-*.dll
  Delete $INSTDIR\bin\libgtkglextmm-win32-${GTKGLEXTMM_API_VERSION}-*.dll

  RMDir $INSTDIR\bin

  ; include

  RMDir /r $INSTDIR\include\gtkglextmm-1.0

  RMDir $INSTDIR\include

  ; lib

  RMDir /r $INSTDIR\lib\gtkglextmm-1.0

  Delete $INSTDIR\lib\libgdkglextmm-win32-${GTKGLEXTMM_API_VERSION}.dll.a
  Delete $INSTDIR\lib\libgtkglextmm-win32-${GTKGLEXTMM_API_VERSION}.dll.a

  Delete $INSTDIR\lib\pkgconfig\gdkglextmm-${GTKGLEXTMM_API_VERSION}.pc
  Delete $INSTDIR\lib\pkgconfig\gdkglextmm-win32-${GTKGLEXTMM_API_VERSION}.pc
  Delete $INSTDIR\lib\pkgconfig\gtkglextmm-${GTKGLEXTMM_API_VERSION}.pc
  Delete $INSTDIR\lib\pkgconfig\gtkglextmm-win32-${GTKGLEXTMM_API_VERSION}.pc
  RMDir $INSTDIR\lib\pkgconfig

  RMDir $INSTDIR\lib

  ; share

  Delete $INSTDIR\share\aclocal\gtkglextmm-${GTKGLEXTMM_API_VERSION}.m4
  RMDir $INSTDIR\share\aclocal

  RMDir /r $INSTDIR\share\doc\gtkglextmm-${GTKGLEXTMM_API_VERSION}
  RMDir $INSTDIR\share\doc

  RMDir $INSTDIR\share

  ; gtkglextmm-examples

  RMDir /r $INSTDIR\gtkglextmm-examples

  ; $INSTDIR

  RMDir $INSTDIR

  ;Modern UI Finish Header
  !insertmacro MUI_UNFINISHHEADER

SectionEnd
