/*
 * This file is part of Gtef, a text editor library.
 *
 * Copyright 2016, 2017 - Sébastien Wilmet <swilmet@gnome.org>
 *
 * Gtef is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * Gtef is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GTEF_H
#define GTEF_H

#define GTEF_H_INSIDE

#include <gtef/gtef-types.h>
#include <gtef/gtef-enum-types.h>

#include <gtef/gtef-action-info.h>
#include <gtef/gtef-action-info-store.h>
#include <gtef/gtef-application.h>
#include <gtef/gtef-buffer.h>
#include <gtef/gtef-encoding.h>
#include <gtef/gtef-file.h>
#include <gtef/gtef-file-loader.h>
#include <gtef/gtef-file-metadata.h>
#include <gtef/gtef-file-saver.h>
#include <gtef/gtef-fold-region.h>
#include <gtef/gtef-gutter-renderer-folds.h>
#include <gtef/gtef-info-bar.h>
#include <gtef/gtef-iter.h>
#include <gtef/gtef-metadata-manager.h>
#include <gtef/gtef-tab.h>
#include <gtef/gtef-utils.h>
#include <gtef/gtef-view.h>

#undef GTEF_H_INSIDE

#endif /* GTEF_H */
