// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/clock.h>
#include <gstreamermm/private/clock_p.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstenumtypes.h>


static gboolean ClockID_Clock_gstreamermm_callback(GstClock* clock, GstClockTime time, GstClockID id, void* data)
{
  Gst::ClockID::SlotClock* the_slot = static_cast<Gst::ClockID::SlotClock*>(data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    bool result = (*the_slot)(Glib::wrap(clock, true), time, Glib::wrap((GstClockEntry*)(id), true));

    //Delete the once executing slot before returning result
    delete the_slot;

    return result;
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

namespace Gst
{

guint get_hours(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) (((GstClockTime)(time)) / (GST_SECOND * 60 * 60)) : 99;
}

guint get_minutes(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / (GST_SECOND * 60)) % 60) : 99;
}

guint get_seconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / GST_SECOND) % 60) : 99;
}

guint get_milliseconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / GST_MSECOND) % 1000) : 999;
}

guint get_microseconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / GST_USECOND) % 1000) : 999;
}

guint get_nanoseconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) ((((GstClockTime)(time)) / GST_NSECOND) % 1000) : 999;
}

guint get_fractional_seconds(ClockTime time)
{
  return GST_CLOCK_TIME_IS_VALID (time) ? \
        (guint) (((GstClockTime)(time)) % GST_SECOND) : 999999999;
}

ClockReturn ClockID::wait_async(const SlotClock& slot)
{
  SlotClock* slot_copy = new SlotClock(slot);
  return (ClockReturn) gst_clock_id_wait_async(gobj(), &ClockID_Clock_gstreamermm_callback, slot_copy);
}

ClockReturn ClockID::wait()
{
  return (ClockReturn) gst_clock_id_wait(gobj(), NULL);
}

} //namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::ClockEntryType>::value_type()
{
  return gst_clock_entry_type_get_type();
}

// static
GType Glib::Value<Gst::ClockReturn>::value_type()
{
  return gst_clock_return_get_type();
}

// static
GType Glib::Value<Gst::ClockFlags>::value_type()
{
  return gst_clock_flags_get_type();
}


/* Why reinterpret_cast<ClockID*>(gobject) is needed:
 *
 * A ClockID instance is in fact always a GstClockEntry instance.
 * Unfortunately, GstClockEntry cannot be a member of ClockID,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because ClockID does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gst::ClockID> wrap(GstClockEntry* object, bool take_copy)
{
  if(take_copy && object)
    gst_clock_id_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::ClockID>(reinterpret_cast<Gst::ClockID*>(object));
}

} // namespace Glib


namespace Gst
{


void ClockID::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_clock_id_ref(reinterpret_cast<GstClockEntry*>(const_cast<ClockID*>(this)));
}

void ClockID::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_clock_id_unref(reinterpret_cast<GstClockEntry*>(const_cast<ClockID*>(this)));
}

GstClockEntry* ClockID::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstClockEntry*>(this);
}

const GstClockEntry* ClockID::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstClockEntry*>(this);
}

GstClockEntry* ClockID::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GstClockEntry *const gobject = reinterpret_cast<GstClockEntry*>(const_cast<ClockID*>(this));
  gst_clock_id_ref(gobject);
  return gobject;
}


ClockTime ClockID::get_time() const
{
  return ((ClockTime)(gst_clock_id_get_time(const_cast<GstClockEntry*>(gobj()))));
}

ClockReturn ClockID::wait(ClockTimeDiff& jitter)
{
  return ((ClockReturn)(gst_clock_id_wait(gobj(), (GstClockTimeDiff*)(&(jitter)))));
}

void ClockID::unschedule()
{
gst_clock_id_unschedule(gobj()); 
}


} // namespace Gst


namespace Glib
{

Glib::RefPtr<Gst::Clock> wrap(GstClock* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Clock>( dynamic_cast<Gst::Clock*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Clock_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Clock_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_clock_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Clock_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->change_resolution = &change_resolution_vfunc_callback;
  klass->get_resolution = &get_resolution_vfunc_callback;
  klass->get_internal_time = &get_internal_time_vfunc_callback;
  klass->wait_async = &wait_async_vfunc_callback;
  klass->unschedule = &unschedule_vfunc_callback;
  klass->wait_jitter = &wait_jitter_vfunc_callback;
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
GstClockTime Clock_Class::change_resolution_vfunc_callback(GstClock* self, GstClockTime old_resolution, GstClockTime new_resolution)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return ((GstClockTime)(obj->change_resolution_vfunc(((ClockTime)(old_resolution))
, ((ClockTime)(new_resolution))
)));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->change_resolution)
    return (*base->change_resolution)(self, old_resolution, new_resolution);


  typedef GstClockTime RType;
  return RType();
}
GstClockTime Clock_Class::get_resolution_vfunc_callback(GstClock* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return ((GstClockTime)(obj->get_resolution_vfunc()));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_resolution)
    return (*base->get_resolution)(self);


  typedef GstClockTime RType;
  return RType();
}
GstClockTime Clock_Class::get_internal_time_vfunc_callback(GstClock* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return ((GstClockTime)(obj->get_internal_time_vfunc()));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_internal_time)
    return (*base->get_internal_time)(self);


  typedef GstClockTime RType;
  return RType();
}
GstClockReturn Clock_Class::wait_async_vfunc_callback(GstClock* self, GstClockEntry* entry)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return ((GstClockReturn)(obj->wait_async_vfunc(Glib::wrap(entry, true)
)));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->wait_async)
    return (*base->wait_async)(self, entry);


  typedef GstClockReturn RType;
  return RType();
}
void Clock_Class::unschedule_vfunc_callback(GstClock* self, GstClockEntry* entry)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->unschedule_vfunc(Glib::wrap(entry, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->unschedule)
    (*base->unschedule)(self, entry);

}
GstClockReturn Clock_Class::wait_jitter_vfunc_callback(GstClock* self, GstClockEntry* entry, GstClockTimeDiff* jitter)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return ((GstClockReturn)(obj->wait_jitter_vfunc(Glib::wrap(entry, true)
, (ClockTimeDiff&)(*(jitter))
)));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->wait_jitter)
    return (*base->wait_jitter)(self, entry, jitter);


  typedef GstClockReturn RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Clock_Class::wrap_new(GObject* object)
{
  return new Clock((GstClock*)object);
}


/* The implementation: */

GstClock* Clock::gobj_copy()
{
  reference();
  return gobj();
}

Clock::Clock(const Glib::ConstructParams& construct_params)
:
  Object(construct_params)
{

}

Clock::Clock(GstClock* castitem)
:
  Object((GstObject*)(castitem))
{}

Clock::~Clock()
{}


Clock::CppClassType Clock::clock_class_; // initialize static member

GType Clock::get_type()
{
  return clock_class_.init().get_type();
}

GType Clock::get_base_type()
{
  return gst_clock_get_type();
}

bool Clock::add_observation(ClockTime slave_time, ClockTime master_time, gdouble* result)
{
  return gst_clock_add_observation(gobj(), ((GstClockTime)(slave_time)), ((GstClockTime)(master_time)), result);
}

bool Clock::set_master(const Clock& master_clock)
{
  return gst_clock_set_master(gobj(), ((GstClock*)(&(master_clock))));
}

Glib::RefPtr<Gst::Clock> Clock::get_master()
{
  return Glib::wrap(gst_clock_get_master(gobj()));
}

Glib::RefPtr<const Gst::Clock> Clock::get_master() const
{
  return const_cast<Clock*>(this)->get_master();
}

ClockTime Clock::set_resolution(ClockTime resolution)
{
  return ((ClockTime)(gst_clock_set_resolution(gobj(), ((GstClockTime)(resolution)))));
}

ClockTime Clock::get_resolution() const
{
  return ((ClockTime)(gst_clock_get_resolution(const_cast<GstClock*>(gobj()))));
}

ClockTime Clock::get_time() const
{
  return ((ClockTime)(gst_clock_get_time(const_cast<GstClock*>(gobj()))));
}

Glib::RefPtr<Gst::ClockID> Clock::create_single_shot_id(ClockTime time)
{
  return Glib::wrap((GstClockEntry*)(gst_clock_new_single_shot_id(gobj(), ((GstClockTime)(time)))));
}

Glib::RefPtr<Gst::ClockID> Clock::create_periodic_id(ClockTime start_time, ClockTime intervals)
{
  return Glib::wrap((GstClockEntry*)(gst_clock_new_periodic_id(gobj(), ((GstClockTime)(start_time)), ((GstClockTime)(intervals)))));
}

ClockTime Clock::get_internal_time() const
{
  return ((ClockTime)(gst_clock_get_internal_time(const_cast<GstClock*>(gobj()))));
}

ClockTime Clock::adjust_unlocked(ClockTime internal_time)
{
  return ((ClockTime)(gst_clock_adjust_unlocked(gobj(), ((GstClockTime)(internal_time)))));
}

ClockTime Clock::unadjust_unlocked(ClockTime external_time)
{
  return ((ClockTime)(gst_clock_unadjust_unlocked(gobj(), ((GstClockTime)(external_time)))));
}

void Clock::get_calibration(ClockTime& internal, ClockTime& external, ClockTime& rate_num, ClockTime& rate_denom) const
{
gst_clock_get_calibration(const_cast<GstClock*>(gobj()), (GstClockTime*)(&(internal)), (GstClockTime*)(&(external)), (GstClockTime*)(&(rate_num)), (GstClockTime*)(&(rate_denom))); 
}

void Clock::set_calibration(ClockTime internal, ClockTime external, ClockTime rate_num, ClockTime rate_denom)
{
gst_clock_set_calibration(gobj(), ((GstClockTime)(internal)), ((GstClockTime)(external)), ((GstClockTime)(rate_num)), ((GstClockTime)(rate_denom))); 
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Clock::property_stats() 
{
  return Glib::PropertyProxy<bool>(this, "stats");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Clock::property_stats() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "stats");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<guint64> Clock::property_timeout() 
{
  return Glib::PropertyProxy<guint64>(this, "timeout");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint64> Clock::property_timeout() const
{
  return Glib::PropertyProxy_ReadOnly<guint64>(this, "timeout");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Clock::property_window_size() 
{
  return Glib::PropertyProxy<int>(this, "window-size");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Clock::property_window_size() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "window-size");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Clock::property_window_threshold() 
{
  return Glib::PropertyProxy<int>(this, "window-threshold");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Clock::property_window_threshold() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "window-threshold");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
ClockTime Gst::Clock::change_resolution_vfunc(ClockTime old_resolution, ClockTime new_resolution) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->change_resolution)
    return ((ClockTime)((*base->change_resolution)(gobj(),((GstClockTime)(old_resolution)),((GstClockTime)(new_resolution)))));

  typedef ClockTime RType;
  return RType();
}
ClockTime Gst::Clock::get_resolution_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_resolution)
    return ((ClockTime)((*base->get_resolution)(const_cast<GstClock*>(gobj()))));

  typedef ClockTime RType;
  return RType();
}
ClockTime Gst::Clock::get_internal_time_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_internal_time)
    return ((ClockTime)((*base->get_internal_time)(const_cast<GstClock*>(gobj()))));

  typedef ClockTime RType;
  return RType();
}
ClockReturn Gst::Clock::wait_async_vfunc(const Glib::RefPtr<Gst::ClockID>& id) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->wait_async)
    return ((ClockReturn)((*base->wait_async)(gobj(),(id)->gobj())));

  typedef ClockReturn RType;
  return RType();
}
void Gst::Clock::unschedule_vfunc(const Glib::RefPtr<Gst::ClockID>& id) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unschedule)
    (*base->unschedule)(gobj(),(id)->gobj());
}
ClockReturn Gst::Clock::wait_jitter_vfunc(const Glib::RefPtr<Gst::ClockID>& id, ClockTimeDiff& jitter) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->wait_jitter)
    return ((ClockReturn)((*base->wait_jitter)(gobj(),(id)->gobj(),(GstClockTimeDiff*)(&(jitter)))));

  typedef ClockReturn RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


