// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_SYSTEMCLOCK_H
#define _GSTREAMERMM_SYSTEMCLOCK_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/clock.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstSystemClock GstSystemClock;
typedef struct _GstSystemClockClass GstSystemClockClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class SystemClock_Class; } // namespace Gst
namespace Gst
{

/** Gst::SystemClock — Default clock that uses the current system time.
 * The GStreamer core provides a Gst::SystemClock based on the system time.
 * Asynchronous callbacks are scheduled from an internal thread.
 *
 * Gst::Clock implementors are encouraged to subclass this systemclock as it
 * implements the async notification.
 *
 * Subclasses can however override all of the important methods for sync and
 * async notifications to implement their own callback methods or blocking wait
 * operations.
 *
 * Last reviewed on 2006-03-08 (0.10.4)
 */

class SystemClock : public Clock
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SystemClock CppObjectType;
  typedef SystemClock_Class CppClassType;
  typedef GstSystemClock BaseObjectType;
  typedef GstSystemClockClass BaseClassType;

private:  friend class SystemClock_Class;
  static CppClassType systemclock_class_;

private:
  // noncopyable
  SystemClock(const SystemClock&);
  SystemClock& operator=(const SystemClock&);

protected:
  explicit SystemClock(const Glib::ConstructParams& construct_params);
  explicit SystemClock(GstSystemClock* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SystemClock();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstSystemClock*       gobj()       { return reinterpret_cast<GstSystemClock*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstSystemClock* gobj() const { return reinterpret_cast<GstSystemClock*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstSystemClock* gobj_copy();

private:


protected:
  SystemClock();

public:
  
  /** Get a handle to the default system clock. The refcount of the
   * clock will be increased so you need to unref the clock after
   * usage.
   * @return The default clock.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::Clock> obtain();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::SystemClock
   */
  Glib::RefPtr<Gst::SystemClock> wrap(GstSystemClock* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_SYSTEMCLOCK_H */

