// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERBASEMM_BASEAUDIOSRC_H
#define _GSTREAMERBASEMM_BASEAUDIOSRC_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/pushsrc.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstBaseAudioSrc GstBaseAudioSrc;
typedef struct _GstBaseAudioSrcClass GstBaseAudioSrcClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace GstBase
{ class BaseAudioSrc_Class; } // namespace GstBase
namespace GstBase
{

/** GstBase::BaseAudioSrc — Base class for audio sources.
 * This is the base class for audio sources. Subclasses need to implement the
 * create_ringbuffer_vfunc vmethod. This base class will then take care of
 * reading samples from the ringbuffer, synchronisation and flushing.
 *
 * Last reviewed on 2006-09-27 (0.10.12).
 *
 * @ingroup GstBaseBaseClasses
 */

class BaseAudioSrc : public Gst::PushSrc
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BaseAudioSrc CppObjectType;
  typedef BaseAudioSrc_Class CppClassType;
  typedef GstBaseAudioSrc BaseObjectType;
  typedef GstBaseAudioSrcClass BaseClassType;

private:  friend class BaseAudioSrc_Class;
  static CppClassType baseaudiosrc_class_;

private:
  // noncopyable
  BaseAudioSrc(const BaseAudioSrc&);
  BaseAudioSrc& operator=(const BaseAudioSrc&);

protected:
  explicit BaseAudioSrc(const Glib::ConstructParams& construct_params);
  explicit BaseAudioSrc(GstBaseAudioSrc* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BaseAudioSrc();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstBaseAudioSrc*       gobj()       { return reinterpret_cast<GstBaseAudioSrc*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstBaseAudioSrc* gobj() const { return reinterpret_cast<GstBaseAudioSrc*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBaseAudioSrc* gobj_copy();

private:


public:
  /** Get the Gst::Clock of the GstBase::AudioSrc.
   */
   Glib::RefPtr<Gst::Clock> get_clock() const;
 
  //TODO: _WRAP_METHOD(Glib::RefPtr<GstBase::RingBuffer> create_ring_buffer(), gst_base_audio_src_create_ringbuffer)

  
  /** Controls whether @a src will provide a clock or not. If @a provide is <tt>true</tt>, 
   * gst_element_provide_clock() will return a clock that reflects the datarate
   * of @a src. If @a provide is <tt>false</tt>, gst_element_provide_clock() will return <tt>0</tt>.
   * 
   * Since: 0.10.16
   * @param provide New state.
   */
  void set_provide_clock(bool provide);
  
  /** Queries whether @a src will provide a clock or not. See also
   * gst_base_audio_src_set_provide_clock.
   * @return <tt>true</tt> if @a src will provide a clock.
   * 
   * Since: 0.10.16.
   */
  bool get_provide_clock();

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Actual configured size of audio buffer in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gint64> property_actual_buffer_time() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Actual configured audio latency in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gint64> property_actual_latency_time() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Size of audio buffer in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gint64> property_buffer_time() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Size of audio buffer in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gint64> property_buffer_time() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Audio latency in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gint64> property_latency_time() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Audio latency in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gint64> property_latency_time() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Provide a clock to be used as the global pipeline clock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_provide_clock() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Provide a clock to be used as the global pipeline clock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_provide_clock() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //TODO: Wrap this property when bug #564206 is resolved.
  //_WRAP_PROPERTY("slave-method", BaseAudioSrcSlaveMethod)

  //TODO: Wrap vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace GstBase


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates GstBase::BaseAudioSrc
   */
  Glib::RefPtr<GstBase::BaseAudioSrc> wrap(GstBaseAudioSrc* object, bool take_copy = false);
}


#endif /* _GSTREAMERBASEMM_BASEAUDIOSRC_H */

