// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/query.h>
#include <gstreamermm/private/query_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstenumtypes.h>
#include <gstreamermm/iterator.h>


namespace Gst
{

QueryTypeDefinition::QueryTypeDefinition()
: value(Gst::QUERY_NONE),
  quark((GQuark)(0))
{}

QueryTypeDefinition::QueryTypeDefinition(GstQueryTypeDefinition* castitem)
: value(Gst::QUERY_NONE),
  quark((castitem) ? castitem->quark : 0)
{
  if (castitem)
  {
    value = (QueryType)(castitem->value);
    nick = castitem->nick;
    description = castitem->description;
  }
}

namespace Enums
{

Glib::ustring get_name(QueryType t)
{
  return gst_query_type_get_name(GstQueryType(t));
}

Glib::QueryQuark get_quark(QueryType t)
{
  return Glib::QueryQuark(gst_query_type_to_quark(GstQueryType(t)));
}

} //namespace Enums

Glib::RefPtr<Query> Query::copy() const
{
  return Gst::wrap(gst_query_copy(gobj()));
}

Glib::RefPtr<Query> Query::create_writable()
{
  return Gst::wrap(gst_query_make_writable(gobj()));
}

bool get_details(QueryType type, QueryTypeDefinition &def)
{
  const GstQueryTypeDefinition* gstdef = gst_query_type_get_details(GstQueryType(type));

  g_return_val_if_fail(gstdef != NULL, false);

  def.value = QueryType(gstdef->value);
  def.nick = gstdef->nick;
  def.description = gstdef->description;
  def.quark = gstdef->quark;

  return true;
}

QueryApplication::QueryApplication(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryApplication::create(QueryType type, Structure& structure)
{
  GstQuery* query = gst_query_new_application(GstQueryType(type),
    structure.gobj()); 
  return Gst::Query::wrap(query);
}

QueryConvert::QueryConvert(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryConvert::create(Format src_format, gint64 value, Format dest_format)
{
  GstQuery* query = gst_query_new_convert(GstFormat(src_format), value,
    GstFormat(dest_format));
  return Gst::Query::wrap(query);
}

void QueryConvert::set(Format src_format, gint64 src_value, Format dest_format, gint64 dest_value)
{
  gst_query_set_convert(gobj(), GstFormat(src_format), src_value, GstFormat(dest_format), dest_value);
}

void QueryConvert::parse(Format& src_format, gint64& src_value, Format& dest_format, gint64& dest_value)
{
  gst_query_parse_convert(gobj(), (GstFormat*)(&src_format), &src_value, (GstFormat*)(&dest_format), &dest_value);
}

void QueryConvert::parse(Format& dest_format, gint64& dest_value)
{
  gst_query_parse_convert(gobj(), NULL, NULL, (GstFormat*)(&dest_format), &dest_value);
}

Format QueryConvert::parse_src_format()
{
  Format src_format;
  gst_query_parse_convert(gobj(), (GstFormat*)(&src_format), NULL, NULL, NULL);
  return src_format;
}

gint64 QueryConvert::parse_src_value()
{
  gint64 src_value;
  gst_query_parse_convert(gobj(), NULL, &src_value, NULL, NULL);
  return src_value;
}

Format QueryConvert::parse_dest_format()
{
  Format dest_format;
  gst_query_parse_convert(gobj(), NULL, NULL, (GstFormat*)(&dest_format), NULL);
  return dest_format;
}

gint64 QueryConvert::parse_dest_value()
{
  gint64 dest_value;
  gst_query_parse_convert(gobj(), NULL, NULL, NULL, &dest_value);
  return dest_value;
}

QueryPosition::QueryPosition(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryPosition::create(Format format)
{
  GstQuery* query = gst_query_new_position(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QueryPosition::set(Format format, gint64 position)
{
  gst_query_set_position(gobj(), GstFormat(format), position);
}

void QueryPosition::parse(Format& format, gint64& position)
{
  gst_query_parse_position(gobj(), (GstFormat*)(&format), &position);
}

gint64 QueryPosition::parse()
{
  gint64 position;
  gst_query_parse_position(gobj(), NULL, &position);
  return position;
}

Format QueryPosition::parse_format()
{
  Format format;
  gst_query_parse_position(gobj(), (GstFormat*)(&format), NULL);
  return format;
}

QueryDuration::QueryDuration(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryDuration::create(Format format)
{
  GstQuery* query = gst_query_new_duration(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QueryDuration::set(Format format, gint64 duration)
{
  gst_query_set_duration(gobj(), GstFormat(format), duration);
}

void QueryDuration::parse(Format& format, gint64& duration)
{
  gst_query_parse_duration(gobj(), (GstFormat*)(&format), &duration);
}

gint64 QueryDuration::parse()
{
  gint64 duration;
  gst_query_parse_duration(gobj(), NULL, &duration);
  return duration;
}

Format QueryDuration::parse_format()
{
  Format format;
  gst_query_parse_duration(gobj(), (GstFormat*)(&format), NULL);
  return format;
}

QueryLatency::QueryLatency(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryLatency::create()
{
  GstQuery* query = gst_query_new_latency();
  return Gst::Query::wrap(query);
}

void QueryLatency::set(bool live, ClockTime min_latency, ClockTime max_latency)
{
  gst_query_set_latency(gobj(), live, GstClockTime(min_latency), GstClockTime(max_latency));
}

void QueryLatency::parse(bool& live, ClockTime& min_latency, ClockTime& max_latency)
{
  gboolean glive;
  gst_query_parse_latency(gobj(), &glive, (ClockTime*)(&min_latency), (ClockTime*)(&max_latency));
  live = glive;
}

bool QueryLatency::parse_live()
{
  gboolean glive;
  gst_query_parse_latency(gobj(), &glive, NULL, NULL);
  return glive;
}

ClockTime QueryLatency::parse_min()
{
  ClockTime min;
  gst_query_parse_latency(gobj(), NULL, (ClockTime*)(&min), NULL);
  return min;
}

ClockTime QueryLatency::parse_max()
{
  ClockTime max;
  gst_query_parse_latency(gobj(), NULL, NULL, (ClockTime*)(&max));
  return max;
}

QuerySeeking::QuerySeeking(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QuerySeeking::create(Format format)
{
  GstQuery* query = gst_query_new_seeking(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QuerySeeking::set(Format format, bool seekable, gint64 segment_start, gint64 segment_end)
{
  gst_query_set_seeking(gobj(), GstFormat(format), seekable, segment_start, segment_end);
}

void QuerySeeking::parse(Format& format, bool& seekable, gint64& segment_start, gint64& segment_end)
{
  gboolean gseekable;
  gst_query_parse_seeking(gobj(), (GstFormat*)(&format), &gseekable, &segment_start, &segment_end);
  seekable = gseekable;
}

Format QuerySeeking::parse_format()
{
  Format format;
  gst_query_parse_seeking(gobj(), (GstFormat*)(&format), NULL, NULL, NULL);
  return format;
}

bool QuerySeeking::parse_seekable()
{
  gboolean gseekable;
  gst_query_parse_seeking(gobj(), NULL, &gseekable, NULL, NULL);
  return gseekable;
}

gint64 QuerySeeking::parse_start()
{
  gint64 start;
  gst_query_parse_seeking(gobj(), NULL, NULL, &start, NULL);
  return start;
}

gint64 QuerySeeking::parse_end()
{
  gint64 end;
  gst_query_parse_seeking(gobj(), NULL, NULL,NULL, &end);
  return end;
}

QueryFormats::QueryFormats(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryFormats::create()
{
  GstQuery* query = gst_query_new_formats();
  return Gst::Query::wrap(query);
}

void QueryFormats::set(const Glib::ArrayHandle<Format>& formats)
{
  gst_query_set_formatsv(gobj(), formats.size(), (GstFormat*)(formats.data()));
}

void QueryFormats::set(int n_formats, const Glib::ArrayHandle<Format>& formats)
{
  gst_query_set_formatsv(gobj(), n_formats, (GstFormat*)(formats.data()));
}

guint QueryFormats::parse_length()
{
  guint n_formats;
  gst_query_parse_formats_length(gobj(), &n_formats);
  return n_formats;
}

Format QueryFormats::parse(guint nth)
{
  Format format;
  gst_query_parse_formats_nth(gobj(), nth, (GstFormat*)(&format));
  return format;
}

QuerySegment::QuerySegment(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QuerySegment::create(Format format)
{
  GstQuery* query = gst_query_new_segment(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QuerySegment::set(double rate, Format format, gint64 start_value, gint64 stop_value)
{
  gst_query_set_segment(gobj(), rate, GstFormat(format), start_value, stop_value);
}

void QuerySegment::parse(double& rate, Format& format, gint64& start_value, gint64& stop_value)
{
  gst_query_parse_segment(gobj(), &rate, (GstFormat*)(&format), &start_value, &stop_value);
}

double QuerySegment::parse_rate()
{
  double rate;
  gst_query_parse_segment(gobj(), &rate, NULL, NULL, NULL);
  return rate;
}

Format QuerySegment::parse_format()
{
  Format format;
  gst_query_parse_segment(gobj(), NULL, (GstFormat*)(&format), NULL, NULL);
  return format;
}

gint64 QuerySegment::parse_start()
{
  gint64 start;
  gst_query_parse_segment(gobj(), NULL, NULL, &start, NULL);
  return start;
}

gint64 QuerySegment::parse_stop()
{
  gint64 stop;
  gst_query_parse_segment(gobj(), NULL, NULL,NULL, &stop);
  return stop;
}

QueryBuffering::QueryBuffering(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryBuffering::create(Format format)
{
  GstQuery* query = gst_query_new_buffering(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QueryBuffering::set(bool busy, int percent)
{
  gst_query_set_buffering_percent(gobj(), busy, percent);
}

void QueryBuffering::parse(bool& busy, int& percent)
{
  gboolean gbusy;
  gst_query_parse_buffering_percent(gobj(), &gbusy, &percent);
  busy = gbusy;
}

bool QueryBuffering::parse_busy()
{
  gboolean gbusy;
  gst_query_parse_buffering_percent(gobj(), &gbusy, NULL);
  return gbusy;
}

int QueryBuffering::parse_percent()
{
  int percent;
  gst_query_parse_buffering_percent(gobj(), NULL, &percent);
  return percent;
}

void QueryBuffering::set(BufferingMode mode, int avg_in, int avg_out, gint64 buffering_left)
{
  gst_query_set_buffering_stats(gobj(), (GstBufferingMode)(mode), avg_in,
    avg_out, buffering_left);
}

void QueryBuffering::parse(BufferingMode& mode, int& avg_in, int& avg_out, gint64 buffering_left)
{
  gst_query_parse_buffering_stats(gobj(), (GstBufferingMode*)(&mode), &avg_in,
    &avg_out, &buffering_left);
}

BufferingMode QueryBuffering::parse_mode()
{
  BufferingMode mode;
  gst_query_parse_buffering_stats(gobj(), (GstBufferingMode*)(&mode), NULL,
    NULL, NULL);
  return mode;
}

int QueryBuffering::parse_input_rate()
{
  int avg_in;
  gst_query_parse_buffering_stats(gobj(), NULL, &avg_in, NULL, NULL);
  return avg_in;
}

int QueryBuffering::parse_output_rate()
{
  int avg_out;
  gst_query_parse_buffering_stats(gobj(), NULL, NULL, &avg_out, NULL);
  return avg_out;
}

gint64 QueryBuffering::parse_time_left()
{
  gint64 buffering_left;
  gst_query_parse_buffering_stats(gobj(), NULL, NULL, NULL, &buffering_left);
  return buffering_left;
}

void QueryBuffering::set(Format format, gint64 start, gint64 stop, gint64 estimated_total)
{
  gst_query_set_buffering_range(gobj(), (GstFormat)(format), start, stop,
    estimated_total);
}

void QueryBuffering::parse(Format& format, gint64& start, gint64& stop, gint64& estimated_total)
{
  gst_query_parse_buffering_range(gobj(), (GstFormat*)(&format), &start,
    &stop, &estimated_total);
}

Format QueryBuffering::parse_format()
{
  Format format;
  gst_query_parse_buffering_range(gobj(), (GstFormat*)(&format), NULL, NULL,
    NULL);
  return format;
}

gint64 QueryBuffering::parse_start()
{
  gint64 start;
  gst_query_parse_buffering_range(gobj(), NULL, &start, NULL, NULL);
  return start;
}

gint64 QueryBuffering::parse_stop()
{
  gint64 stop;
  gst_query_parse_buffering_range(gobj(), NULL, NULL, &stop, NULL);
  return stop;
}

gint64 QueryBuffering::parse_total_time()
{
  gint64 estimated_total;
  gst_query_parse_buffering_range(gobj(), NULL, NULL, NULL, &estimated_total);
  return estimated_total;
}

Glib::RefPtr<Query> Query::wrap(GstQuery* query, bool take_copy) {

  Glib::RefPtr<Query> result;

  if(!query)
    return result;

  switch (GST_QUERY_TYPE(query)) {
    case GST_QUERY_POSITION:
      result = Glib::RefPtr<Query>( new Gst::QueryPosition(query) );
      break;
    case GST_QUERY_DURATION:
      result = Glib::RefPtr<Query>( new Gst::QueryDuration(query) );
      break;
    case GST_QUERY_LATENCY:
      result = Glib::RefPtr<Query>( new Gst::QueryLatency(query) );
      break;
    case GST_QUERY_SEEKING:
      result = Glib::RefPtr<Query>( new Gst::QuerySeeking(query) );
      break;
    case GST_QUERY_SEGMENT:
      result = Glib::RefPtr<Query>( new Gst::QuerySegment(query) );
      break;
    case GST_QUERY_CONVERT:
      result = Glib::RefPtr<Query>( new Gst::QueryConvert(query) );
      break;
    case GST_QUERY_FORMATS:
      result = Glib::RefPtr<Query>( new Gst::QueryFormats(query) );
      break;
    case GST_QUERY_BUFFERING:
      result = Glib::RefPtr<Query>( new Gst::QueryBuffering(query) );
      break;
    case GST_QUERY_NONE:
    case GST_QUERY_JITTER:
      result = Gst::wrap(query, false);
      break;
	/* The rest of the query types are custom ones */
    default:
      result = Glib::RefPtr<Query>( new Gst::QueryApplication(query) );
  }

  if(result && take_copy)
    result->reference();

  return result;
}

} //namesapce Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::QueryType>::value_type()
{
  return gst_query_type_get_type();
}

// static
GType Glib::Value<Gst::BufferingMode>::value_type()
{
  return gst_buffering_mode_get_type();
}


namespace Gst
{


} // namespace Gst


namespace Gst
{

Glib::RefPtr<Gst::Query> wrap(GstQuery* object, bool take_copy)
{
  //Note that we use Gst::wrap() instead of Glib::wrap() 
  //because we are dealing with a GstMiniObject, not a GObject:
  return Glib::RefPtr<Gst::Query>( dynamic_cast<Gst::Query*> (Gst::wrap_auto ((GstMiniObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Gst */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Query_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Query_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_query_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Query_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Query_Class::wrap_new(GstMiniObject* object)
{
  return new Query((GstQuery*)object);
}


/* The implementation: */

GstQuery* Query::gobj_copy()
{
  reference();
  return gobj();
}


Query::Query(GstQuery* castitem)
:
  Gst::MiniObject((GstMiniObject*)(castitem))
{}

Query::~Query()
{}


Query::CppClassType Query::query_class_; // initialize static member

GType Query::get_type()
{
  return query_class_.init().get_type();
}

GType Query::get_base_type()
{
  return gst_query_get_type();
}

const Structure Query::get_structure() const
{
  return Glib::wrap(const_cast<GstStructure*>(gst_query_get_structure(const_cast<GstQuery*>(gobj()))), true);
}

 QueryType Query::get_query_type() const
{
  return ((QueryType)(gobj()->type));
}
 
QueryType Query::register_query_type(const Glib::ustring& nick, const Glib::ustring& description)
{
  return ((QueryType)(gst_query_type_register(nick.c_str(), description.c_str())));
}


QueryType Query::get_query_type(const Glib::ustring& nick)
{
  return ((QueryType)(gst_query_type_get_by_nick(nick.c_str())));
}


bool Query::query_types_contain(const Glib::ArrayHandle<QueryType>& types, QueryType type)
{
  return gst_query_types_contains((GstQueryType*)((types).data()), ((GstQueryType)(type)));
}


IteratorBasic<const QueryTypeDefinition> Query::iterate_definitions()
{
  return IteratorBasic<const QueryTypeDefinition>::IteratorBasic(gst_query_type_iterate_definitions());
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


