// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/value.h>
#include <gstreamermm/private/value_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gst
{

Fourcc::Fourcc()
: first(0), second(0), third(0), fourth(0)
{}

Fourcc& Fourcc::operator=(const Fourcc& src)
{
  first = src.first;
  second = src.second;
  third = src.third;
  fourth = src.fourth;

  return *this;
}

Fourcc::Fourcc(char first, char second, char third, char fourth)
: first(first), second(second), third(third), fourth(fourth)
{}

Fourcc::Fourcc(const Glib::ustring& s)
: first(0), second(0), third(0), fourth(0)
{
  guint32 fourcc = GST_STR_FOURCC(s.c_str());
  get_ccs(fourcc);

}

Fourcc::Fourcc(guint32 fourcc)
: first(0), second(0), third(0), fourth(0)
{
  get_ccs(fourcc);
}

Fourcc::Fourcc(const Fourcc& f)
: first(f.first), second(f.second), third(f.third), fourth(f.fourth)
{}

Fourcc::Fourcc(const Glib::ValueBase& value)
: first(0), second(0), third(0), fourth(0)
{
  if(G_VALUE_TYPE(value.gobj()) == GST_TYPE_FOURCC)
  {
    int fourcc = gst_value_get_fourcc(value.gobj());
    get_ccs(fourcc);
  }
}

guint32 Fourcc::get_fourcc() const
{
  return GST_MAKE_FOURCC(first, second, third, fourth);
}

void Fourcc::get_ccs(guint32 fourcc)
{
  first = fourcc & 0xff;
  second = (fourcc >> 8) & 0xff;
  third = (fourcc >> 16) & 0xff;
  fourth = (fourcc >> 24) & 0xff;
}


Fraction::Fraction()
: num(0), denom(1)
{}

Fraction::Fraction(int num, int denom)
: num(num), denom(denom)
{}

Fraction::Fraction(const Fraction& src)
: num(src.num), denom(src.denom)
{}

Fraction::Fraction(const Glib::ValueBase& value)
: num(0), denom(1)
{
  if(G_VALUE_TYPE(value.gobj()) == GST_TYPE_FRACTION)
  {
    num = gst_value_get_fraction_numerator(value.gobj());
    denom = gst_value_get_fraction_denominator(value.gobj());
  }
}

Fraction& Fraction::operator=(const Fraction& src)
{
  num = src.num;
  denom = src.denom;

  return *this;
}


IntRange::IntRange()
: min(0), max(0)
{}

IntRange::IntRange(int min, int max)
: min(min), max(max)
{}

IntRange::IntRange(const IntRange& src)
: min(src.min), max(src.max)
{}

IntRange::IntRange(const Glib::ValueBase& value)
: min(0), max(0)
{
  if(G_VALUE_TYPE(value.gobj()) == GST_TYPE_INT_RANGE)
  {
    min = gst_value_get_int_range_min(value.gobj());
    max = gst_value_get_int_range_max(value.gobj());
  }
}

IntRange& IntRange::operator=(const IntRange& src)
{
  min = src.min;
  max = src.max;

  return *this;
}


DoubleRange::DoubleRange()
: min(0), max(0)
{}

DoubleRange::DoubleRange(double min, double max)
: min(min), max(max)
{}

DoubleRange::DoubleRange(const DoubleRange& r)
: min(r.min), max(r.max)
{}

DoubleRange::DoubleRange(const Glib::ValueBase& value)
: min(0), max(0)
{
  if(G_VALUE_TYPE(value.gobj()) == GST_TYPE_DOUBLE_RANGE)
  {
    min = gst_value_get_double_range_min(value.gobj());
    max = gst_value_get_double_range_max(value.gobj());
  }
}

DoubleRange& DoubleRange::operator=(const DoubleRange& src)
{
  min = src.min;
  max = src.max;

  return *this;
}

FractionRange::FractionRange()
: min(), max()
{}

FractionRange::FractionRange(const Fraction& min, const Fraction& max)
: min(min), max(max)
{}

FractionRange::FractionRange(const FractionRange& src)
: min(src.min), max(src.max)
{}

FractionRange& FractionRange::operator=(const FractionRange& src)
{
  min = src.min;
  max = src.max;

  return *this;
}

FractionRange::FractionRange(const Glib::ValueBase& value)
: min(), max()
{
  if(G_VALUE_TYPE(value.gobj()) == GST_TYPE_FRACTION_RANGE)
  {
    const GValue* min = gst_value_get_fraction_range_min(value.gobj());
    const GValue* max = gst_value_get_fraction_range_max(value.gobj());

    this->min.num = gst_value_get_fraction_numerator(min);
    this->min.denom = gst_value_get_fraction_denominator(min);

    this->max.num = gst_value_get_fraction_numerator(max);
    this->max.denom = gst_value_get_fraction_denominator(max);
  }
}

} //namespace Gst


namespace
{
} // anonymous namespace


