// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_XML_H
#define _GSTREAMERMM_XML_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstxml.h>
#include <gstreamermm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstXML GstXML;
typedef struct _GstXMLClass GstXMLClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class XML_Class; } // namespace Gst
namespace Gst
{

class Element;


class XML : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef XML CppObjectType;
  typedef XML_Class CppClassType;
  typedef GstXML BaseObjectType;
  typedef GstXMLClass BaseClassType;

private:  friend class XML_Class;
  static CppClassType xml_class_;

private:
  // noncopyable
  XML(const XML&);
  XML& operator=(const XML&);

protected:
  explicit XML(const Glib::ConstructParams& construct_params);
  explicit XML(GstXML* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~XML();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstXML*       gobj()       { return reinterpret_cast<GstXML*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstXML* gobj() const { return reinterpret_cast<GstXML*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstXML* gobj_copy();

private:


protected:
  XML();

public:
  
  static Glib::RefPtr<XML> create();


  /** Fills the GstXML object with the elements from the
   * xmlDocPtr.
   * @param doc A pointer to an xml document to parse.
   * @param root The name of the root object to build.
   * @return <tt>true</tt> on success, <tt>false</tt> otherwise.
   */
  bool parse_doc(xmlDocPtr doc, const std::string& root);
  
  /** Fills the GstXML object with the corresponding elements from
   * the XML file fname. Optionally it will only build the element from
   * the element node root (if it is not <tt>0</tt>). This feature is useful
   * if you only want to build a specific element from an XML file
   * but not the pipeline it is embedded in.
   * 
   * Pass "-" as fname to read from stdin. You can also pass a URI
   * of any format that libxml supports, including http.
   * @param fname The filename with the xml description.
   * @param root The name of the root object to build.
   * @return <tt>true</tt> on success, <tt>false</tt> otherwise.
   */
  bool parse_file(const std::string& filename, const std::string& root);

  /** Fills the Gst::XML object with the corresponding elements from an in
   * memory XML buffer.
   *
   * @param buffer The in memory XML buffer.
   * @param root The name of the root objects to build.
   * @return true on success.
   */
  bool parse_memory(const std::string& buffer, const std::string& root);

  //Note: gst_xml_get_element() returns a reference.
  
  /** This function is used to get a pointer to the GstElement corresponding
   * to name in the pipeline description. You would use this if you have
   * to do anything to the element after loading.
   * @param name The name of element to retrieve.
   * @return A pointer to a new GstElement, caller owns returned reference.
   */
  Glib::RefPtr<Element> get_element(const std::string& name);
  
  /** This function is used to get a pointer to the GstElement corresponding
   * to name in the pipeline description. You would use this if you have
   * to do anything to the element after loading.
   * @param name The name of element to retrieve.
   * @return A pointer to a new GstElement, caller owns returned reference.
   */
  Glib::RefPtr<const Element> get_element(const std::string& name) const;

 
  /** Retrieve a list of toplevel elements.
   * @return A GList of top-level elements. The caller does not own a copy
   * of the list and must not free or modify the list. The caller also does not
   * own a reference to any of the elements in the list and should obtain its own
   * reference using Gst::Object::ref() if necessary.
   */
  Glib::ListHandle< Glib::RefPtr<Element> > get_topelements();

 
  /** Retrieve a list of toplevel elements.
   * @return A GList of top-level elements. The caller does not own a copy
   * of the list and must not free or modify the list. The caller also does not
   * own a reference to any of the elements in the list and should obtain its own
   * reference using Gst::Object::ref() if necessary.
   */
  Glib::ListHandle< Glib::RefPtr<const Element> > get_topelements() const;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%object_loaded(const Glib::RefPtr<Gst::Object>& object, xmlNode* xml_node)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Gst::Object>&,xmlNode* > signal_object_loaded();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_object_loaded(const Glib::RefPtr<Gst::Object>& object, xmlNode* xml_node);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

xmlDocPtr write_xml(const Glib::RefPtr<Element>& element);
int write_xml_file(const Glib::RefPtr<Element>& element, const std::string& filename);
Glib::RefPtr<Element> make_element(const xmlNodePtr& xml_node, const Glib::RefPtr<Object>& parent);

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::XML
   */
  Glib::RefPtr<Gst::XML> wrap(GstXML* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_XML_H */

