// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERBASEMM_XOVERLAY_H
#define _GSTREAMERBASEMM_XOVERLAY_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/interfaces/xoverlay.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstXOverlay GstXOverlay;
typedef struct _GstXOverlayClass GstXOverlayClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace GstBase
{ class XOverlay_Class; } // namespace GstBase
namespace GstBase
{

/** XOverlay — Interface for setting/getting a Window on elements supporting
 * it.
 * The XOverlay interface is used for 2 main purposes :
 *
 * - To get a grab on the Window where the video sink element is going to
 * render. This is achieved by either being informed about the Window
 * identifier that the video sink element generated, or by forcing the video
 * sink element to use a specific Window identifier for rendering.
 *
 * - To force a redrawing of the latest video frame the video sink element
 * displayed on the Window. Indeed if the Pipeline is in STATE_PAUSED state,
 * moving the Window around will damage its content. Application developers
 * will want to handle the Expose events themselves and force the video sink
 * element to refresh the Window's content.
 *
 * Using the Window created by the video sink is probably the simplest
 * scenario, in some cases, though, it might not be flexible enough for
 * application developers if they need to catch events such as mouse moves and
 * button clicks.
 *
 * Setting a specific Window identifier on the video sink element is the most
 * flexible solution but it has some issues. Indeed the application needs to
 * set its Window identifier at the right time to avoid internal Window
 * creation from the video sink element. To solve this issue a Message is
 * posted on the bus to inform the application that it should set the Window
 * identifier immediately. Here is an example on how to do that correctly:
 *
 * TODO: Insert translated example code from C API
 */

class XOverlay : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef XOverlay CppObjectType;
  typedef XOverlay_Class CppClassType;
  typedef GstXOverlay BaseObjectType;
  typedef GstXOverlayClass BaseClassType;

private:
  friend class XOverlay_Class;
  static CppClassType xoverlay_class_;

  // noncopyable
  XOverlay(const XOverlay&);
  XOverlay& operator=(const XOverlay&);

protected:
  XOverlay(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit XOverlay(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit XOverlay(GstXOverlay* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~XOverlay();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstXOverlay*       gobj()       { return reinterpret_cast<GstXOverlay*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GstXOverlay* gobj() const { return reinterpret_cast<GstXOverlay*>(gobject_); }

private:


public:
  
  /** This will call the video overlay's set_xwindow_id method. You should
   * use this method to tell to a XOverlay to display video output to a
   * specific XWindow. Passing 0 as the xwindow_id will tell the overlay to
   * stop using that window and create an internal one.
   * @param xwindow_id A X::ID referencing the XWindow.
   */
  void set_xwindow_id(gulong xwindow_id);
  
  /** This will post a "have-xwindow-id" element message on the bus.
   * 
   * This function should only be used by video overlay plugin developers.
   * @param xwindow_id A X::ID referencing the XWindow.
   */
  void got_xwindow_id(gulong xwindow_id);
  
  /** This will post a "prepare-xwindow-id" element message on the bus
   * to give applications an opportunity to call 
   * gst_x_overlay_set_xwindow_id() before a plugin creates its own
   * window.
   * 
   * This function should only be used by video overlay plugin developers.
   */
  void prepare_xwindow_id();
  
  /** Tell an overlay that it has been exposed. This will redraw the current frame
   * in the drawable even if the pipeline is PAUSED.
   */
  void expose();
  
  /** Tell an overlay that it should handle events from the window system. These
   * events are forwared upstream as navigation events. In some window system,
   * events are not propagated in the window hierarchy if a client is listening
   * for them. This method allows you to disable events handling completely
   * from the XOverlay.
   * @param handle_events A <tt>bool</tt> indicating if events should be handled or not.
   */
  void handle_events(bool handle_events);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace GstBase


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates GstBase::XOverlay
   */
  Glib::RefPtr<GstBase::XOverlay> wrap(GstXOverlay* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERBASEMM_XOVERLAY_H */

