// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/structure.h>
#include <gstreamermm/private/structure_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstvalue.h> //Must be included before gststructure.h
#include <gst/gststructure.h>

namespace Gst
{

static gboolean
Structure_ForEach_gstreamermm_callback(GQuark field_id, const GValue *value, gpointer data)
{
  Structure::ForeachSlot& slot = *static_cast<Structure::ForeachSlot*>(data);
  return slot(field_id, value);
}

static gboolean
Structure_Map_gstreamermm_callback(GQuark field_id, GValue *value, gpointer data)
{
  Structure::MapSlot& slot = *static_cast<Structure::MapSlot*>(data);
  return slot(field_id, value);
}

Structure::Structure(const Glib::ustring& name)
{
  gobject_ = gst_structure_empty_new(name.c_str());
}

void
Structure::get_field(const Glib::ustring& name, Glib::ValueBase& value) const
{
  value.init(gst_structure_get_value(gobj(), name.c_str()));
}

bool
Structure::get_boolean(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_BOOLEAN);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_int(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_INT);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_uint(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_UINT);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_fourcc(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_UINT);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}


bool
Structure::get_double(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_DOUBLE);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_string(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_STRING);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_date (const Glib::ustring& name, Glib::Date& value) const
{
  GDate *date = 0;
  const bool has = gst_structure_get_date(gobj(), name.c_str(), &date);
  value.set_julian(g_date_get_julian(date));
  return has;
}


bool
Structure::get_clock_time(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_UINT64);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}


bool
Structure::get_enum(const Glib::ustring& name, GType enum_type, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), enum_type);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}


bool
Structure::get_fraction(const Glib::ustring& name, int& value_numerator, int& value_denominator) const
{
  return gst_structure_get_fraction(gobj(), name.c_str(), &value_numerator, &value_denominator);
}

bool
Structure::foreach(const ForeachSlot& slot)
{
  ForeachSlot slot_copy(slot);
  gst_structure_foreach(gobj(), &Structure_ForEach_gstreamermm_callback, &slot_copy);
}

bool
Structure::map_in_place(const MapSlot& slot)
{
  MapSlot slot_copy(slot);
  gst_structure_map_in_place(gobj(), &Structure_Map_gstreamermm_callback, &slot_copy);
}

Structure
Structure::create_from_string(const Glib::ustring& the_string)
{
  return Structure(gst_structure_from_string(the_string.c_str(), NULL)); 
}

} //namespace Gst

namespace
{
} // anonymous namespace


namespace Glib
{

Gst::Structure wrap(GstStructure* object, bool take_copy)
{
  return Gst::Structure(object, take_copy);
}

} // namespace Glib


namespace Gst
{


// static
GType Structure::get_type()
{
  return gst_structure_get_type();
}

Structure::Structure()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

Structure::Structure(const Structure& other)
:
  gobject_ ((other.gobject_) ? gst_structure_copy(other.gobject_) : 0)
{}

Structure::Structure(GstStructure* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gst_structure_copy(gobject) : gobject)
{}

Structure& Structure::operator=(const Structure& other)
{
  Structure temp (other);
  swap(temp);
  return *this;
}

Structure::~Structure()
{
  if(gobject_)
    gst_structure_free(gobject_);
}

void Structure::swap(Structure& other)
{
  GstStructure *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GstStructure* Structure::gobj_copy() const
{
  return gst_structure_copy(gobject_);
}


int Structure::size() const
{
  return gst_structure_n_fields(const_cast<GstStructure*>(gobj()));
}

void Structure::clear()
{
gst_structure_remove_all_fields(gobj()); 
}

void Structure::set_field(const Glib::ustring& fieldname, const Glib::ValueBase& value)
{
gst_structure_set_value(gobj(), fieldname.c_str(), (value).gobj()); 
}

void Structure::remove_field(const Glib::ustring& fieldname)
{
gst_structure_remove_field(gobj(), fieldname.c_str()); 
}

GType Structure::get_field_type(const Glib::ustring& fieldname) const
{
  return gst_structure_get_field_type(const_cast<GstStructure*>(gobj()), fieldname.c_str());
}

bool Structure::has_field(const Glib::ustring& fieldname) const
{
  return gst_structure_has_field(const_cast<GstStructure*>(gobj()), fieldname.c_str());
}

bool Structure::has_field(const Glib::ustring& fieldname, GType type) const
{
  return gst_structure_has_field_typed(const_cast<GstStructure*>(gobj()), fieldname.c_str(), type);
}

Glib::QueryQuark Structure::get_name_id() const
{
  return Glib::QueryQuark(gst_structure_get_name_id(const_cast<GstStructure*>(gobj())));
}

Glib::ustring Structure::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_structure_get_name(const_cast<GstStructure*>(gobj())));
}

bool Structure::has_name(const Glib::ustring& name) const
{
  return gst_structure_has_name(const_cast<GstStructure*>(gobj()), name.c_str());
}

void Structure::set_name(const Glib::ustring& name)
{
gst_structure_set_name(gobj(), name.c_str()); 
}

Glib::ustring Structure::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gst_structure_to_string(const_cast<GstStructure*>(gobj())));
}

Glib::ustring Structure::nth_field_name(guint index) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_structure_nth_field_name(const_cast<GstStructure*>(gobj()), index));
}


} // namespace Gst


