// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_INDEX_H
#define _GSTREAMERMM_INDEX_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/object.h>
#include <gstreamermm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstIndex GstIndex;
typedef struct _GstIndexClass GstIndexClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Index_Class; } // namespace Gst
namespace Gst
{

/** The basic element of an index.
 */
class IndexEntry
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef IndexEntry CppObjectType;
  typedef GstIndexEntry BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  IndexEntry();

  // Use make_a_copy=true when getting it directly from a struct.
  explicit IndexEntry(GstIndexEntry* castitem, bool make_a_copy = false);

  IndexEntry(const IndexEntry& src);
  IndexEntry& operator=(const IndexEntry& src);

  ~IndexEntry();

  GstIndexEntry*       gobj()       { return gobject_; }
  const GstIndexEntry* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstIndexEntry* gobj_copy() const;

protected:
  GstIndexEntry* gobject_;

private:

public:
  
  bool assoc_map(Format format, gint64& value);


};

/** A group of related entries in an index.
 */
class IndexGroup
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef IndexGroup CppObjectType;
  typedef GstIndexGroup BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


};

/** An association in an entry.
 */
class IndexAssociation
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef IndexAssociation CppObjectType;
  typedef GstIndexAssociation BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


};


/** Gst::Index is used to generate a stream index of one or more elements in a pipeline.
 */

class Index : public Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Index CppObjectType;
  typedef Index_Class CppClassType;
  typedef GstIndex BaseObjectType;
  typedef GstIndexClass BaseClassType;

private:  friend class Index_Class;
  static CppClassType index_class_;

private:
  // noncopyable
  Index(const Index&);
  Index& operator=(const Index&);

protected:
  explicit Index(const Glib::ConstructParams& construct_params);
  explicit Index(GstIndex* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Index();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstIndex*       gobj()       { return reinterpret_cast<GstIndex*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstIndex* gobj() const { return reinterpret_cast<GstIndex*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstIndex* gobj_copy();

private:


protected:
  Index();

public:
  
  bool is_readable() const;
  
  bool is_writable() const;
  
  void commit(int id);
  
  gint get_group() const;
  
  gint new_group();
  
  bool set_group(int group_number);
  
  void set_certainty(IndexCertainty certainty);
  
  IndexCertainty set_certainty() const;
  
  bool get_writer_id(const Glib::RefPtr<Gst::Object>& writer, int& id) const;
  
  IndexEntry add_format(int id, Format format);
  
  IndexEntry add_association(int id, AssocFlags flags, int n, const IndexAssociation& list);
  
  IndexEntry add_id(int id, const Glib::ustring& description);

  //TODO: Reorder parameters to allow default values?
  
  IndexEntry get_assoc_entry(int id, IndexLookupMethod method, AssocFlags flags, Format format, gint64 value) const;

  /** For example,
   * @code
   * bool on_index_filter(IndexEntry entry);
   * @endcode
   */ 
  typedef sigc::slot<bool, IndexEntry> SlotIndexFilter;

  void set_filter(const SlotIndexFilter& slot);

  /** For example,
   * @code
   * bool on_index_resolve(const Glib::RefPtr<Gst::Object>& writer, Glib::ustring& writer_string);
   * @endcode
   */ 
  typedef sigc::slot<bool, const Glib::RefPtr<Gst::Object>&, Glib::ustring&> SlotIndexResolver;

  void set_resolver(const SlotIndexResolver& slot);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

}//namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::IndexEntry
   */
Gst::IndexEntry wrap(GstIndexEntry* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Index
   */
  Glib::RefPtr<Gst::Index> wrap(GstIndex* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_INDEX_H */

