// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/structure.h>
#include <gstreamermm/private/structure_p.h>

#include <gst/gstvalue.h> //Must be included before gststructure.h
#include <gst/gststructure.h>

namespace Gst
{
// StructureValueProxy

StructureValueProxy::StructureValueProxy(Structure& structure, const Glib::ustring& name)
: m_Structure(structure)
, m_Name(name)
{
}

void
StructureValueProxy::operator=(const Glib::ustring& value)
{
  gst_structure_set(m_Structure.gobj(), m_Name.c_str(), G_TYPE_STRING, value.c_str(), NULL);
}

void
StructureValueProxy::operator=(bool value)
{
  gst_structure_set(m_Structure.gobj(), m_Name.c_str(), G_TYPE_BOOLEAN, value, NULL);
}

void
StructureValueProxy::operator=(gdouble value)
{
  gst_structure_set(m_Structure.gobj(), m_Name.c_str(), G_TYPE_DOUBLE, value, NULL);
}

void
StructureValueProxy::operator=(int value)
{
  gst_structure_set(m_Structure.gobj(), m_Name.c_str(), G_TYPE_INT, value, NULL);
}

void
StructureValueProxy::operator=(const Fraction& value)
{
  GValue v = {0,};
  g_value_init(&v, GST_TYPE_FRACTION);
  gst_value_set_fraction(&v, value.numerator, value.denominator);
  gst_structure_set_value(m_Structure.gobj(), m_Name.c_str(), &v);
  g_value_unset(&v);
}

// Structure

static gboolean
Structure_ForEach_gstmm_callback(GQuark field_id, const GValue *value, gpointer data)
{
  Structure::ForeachSlot& slot = *static_cast<Structure::ForeachSlot*>(data);
  return slot(field_id, value);
}

static gboolean
Structure_Map_gstmm_callback(GQuark field_id, GValue *value, gpointer data)
{
  Structure::MapSlot& slot = *static_cast<Structure::MapSlot*>(data);
  return slot(field_id, value);
}

Structure::Structure(const Glib::ustring& name)
{
  gobject_ = gst_structure_empty_new(name.c_str());
}

Structure::Structure(GQuark quark)
{
  gobject_ = gst_structure_id_empty_new(quark);
}

StructureValueProxy
Structure::operator[](const Glib::ustring& name)
{
  return StructureValueProxy(*this, name);
}

void
Structure::clear()
{
  gst_structure_remove_all_fields(gobject_);
}

int
Structure::size() const
{
  return gst_structure_n_fields(gobject_);
}


//TODO: ValueBase should be used as an output paramter in getters because it is a base type.
/*
Glib::ValueBase
Structure::get_value(const Glib::ustring& name) const
{
  Glib::ValueBase v;
  v.init(gst_structure_get_value(gobject_, name.c_str()));
  return v;
}
*/

bool
Structure::get_boolean(const Glib::ustring& name, bool& value) const
{
  gboolean val_ = false;
  const bool has = gst_structure_get_boolean(gobject_, name.c_str(), &val_);
  if(has)
  {
    value = val_;
  }

  return has;
}

bool
Structure::get_int(const Glib::ustring& name, int& value) const
{
  return gst_structure_get_int(gobject_, name.c_str(), &value);
}

bool
Structure::get_uint(const Glib::ustring& name, guint& value) const
{
  return gst_structure_get_uint(gobject_, name.c_str(), &value);
}

bool
Structure::get_fourcc(const Glib::ustring& name, guint32& value) const
{
  return gst_structure_get_fourcc(gobject_, name.c_str(), &value);
}


bool
Structure::get_double(const Glib::ustring& name, gdouble& value) const
{
  return gst_structure_get_double(gobject_, name.c_str(), &value);
}

Glib::ustring
Structure::get_string(const Glib::ustring& name) const
{
  return gst_structure_get_string(gobject_, name.c_str());
}

bool
Structure::get_date (const Glib::ustring& name, Glib::Date& value) const
{
  GDate *date = 0;
  const bool has = gst_structure_get_date(gobject_, name.c_str(), &date);
  value.set_julian(g_date_get_julian(date));
  return has;
}


bool
Structure::get_clock_time(const Glib::ustring& name, ClockTime& value) const
{
  return gst_structure_get_clock_time(gobject_, name.c_str(), &value);
}


bool
Structure::get_enum(const Glib::ustring& name, GType enumtype, int& value) const
{
  return gst_structure_get_enum(gobject_, name.c_str(), enumtype, &value);
}


bool
Structure::get_fraction(const Glib::ustring& name, int& value_numerator, int& value_denominator) const
{
  return gst_structure_get_fraction(gobject_, name.c_str(), &value_numerator, &value_denominator);
}

bool
Structure::foreach(const ForeachSlot& slot)
{
  ForeachSlot slot_copy(slot);
  gst_structure_foreach(gobject_, &Structure_ForEach_gstmm_callback, &slot_copy);
}

bool
Structure::map_in_place(const MapSlot& slot)
{
  MapSlot slot_copy(slot);
  gst_structure_map_in_place(gobject_, &Structure_Map_gstmm_callback, &slot_copy);
}

Structure
Structure::create_from_string(const Glib::ustring& the_string)
{
  return Structure(gst_structure_from_string(the_string.c_str(), NULL)); 
}

} //namespace Gst

namespace
{
} // anonymous namespace


namespace Glib
{

Gst::Structure wrap(GstStructure* object, bool take_copy)
{
  return Gst::Structure(object, take_copy);
}

} // namespace Glib


namespace Gst
{


// static
GType Structure::get_type()
{
  return gst_structure_get_type();
}

Structure::Structure()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

Structure::Structure(const Structure& other)
:
  gobject_ ((other.gobject_) ? gst_structure_copy(other.gobject_) : 0)
{}

Structure::Structure(GstStructure* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gst_structure_copy(gobject) : gobject)
{}

Structure& Structure::operator=(const Structure& other)
{
  Structure temp (other);
  swap(temp);
  return *this;
}

Structure::~Structure()
{
  if(gobject_)
    gst_structure_free(gobject_);
}

void Structure::swap(Structure& other)
{
  GstStructure *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GstStructure* Structure::gobj_copy() const
{
  return gst_structure_copy(gobject_);
}


void Structure::id_set_value(GQuark field, const Glib::ValueBase& value)
{
gst_structure_id_set_value(gobj(), field, (value).gobj()); 
}

void Structure::remove_field(const Glib::ustring& fieldname)
{
gst_structure_remove_field(gobj(), fieldname.c_str()); 
}

GType Structure::get_field_type(const Glib::ustring& fieldname) const
{
  return gst_structure_get_field_type(const_cast<GstStructure*>(gobj()), fieldname.c_str());
}

bool Structure::has_field(const Glib::ustring& fieldname) const
{
  return gst_structure_has_field(const_cast<GstStructure*>(gobj()), fieldname.c_str());
}

bool Structure::has_field_typed(const Glib::ustring& fieldname, GType type) const
{
  return gst_structure_has_field_typed(const_cast<GstStructure*>(gobj()), fieldname.c_str(), type);
}

GQuark Structure::get_name_id() const
{
  return gst_structure_get_name_id(const_cast<GstStructure*>(gobj()));
}

Glib::ustring Structure::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_structure_get_name(const_cast<GstStructure*>(gobj())));
}

bool Structure::has_name(const Glib::ustring& name) const
{
  return gst_structure_has_name(const_cast<GstStructure*>(gobj()), name.c_str());
}

void Structure::set_name(const Glib::ustring& name)
{
gst_structure_set_name(gobj(), name.c_str()); 
}

Glib::ustring Structure::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gst_structure_to_string(const_cast<GstStructure*>(gobj())));
}

Glib::ustring Structure::nth_field_name(guint index) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_structure_nth_field_name(const_cast<GstStructure*>(gobj()), index));
}


} // namespace Gst


