// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_INTERFACE_H
#define _GSTREAMERMM_INTERFACE_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <gstreamermm/element.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstImplementsInterface GstImplementsInterface;
typedef struct _GstImplementsInterfaceClass GstImplementsInterfaceClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Interface_Class; } // namespace Gst
namespace Gst
{

/** The core interface implemented by Gst::Element instances that allows
 * runtime querying of interface availability.
 * This provides interface functionality on a per-instance basis and not a
 * per-class basis, which is the case for GObject.
 * @ingroup GstInterfaces
 */

class Interface : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Interface CppObjectType;
  typedef Interface_Class CppClassType;
  typedef GstImplementsInterface BaseObjectType;
  typedef GstImplementsInterfaceClass BaseClassType;

private:
  friend class Interface_Class;
  static CppClassType interface_class_;

  // noncopyable
  Interface(const Interface&);
  Interface& operator=(const Interface&);

protected:
  Interface(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Interface(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Interface(GstImplementsInterface* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Interface();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstImplementsInterface*       gobj()       { return reinterpret_cast<GstImplementsInterface*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GstImplementsInterface* gobj() const { return reinterpret_cast<GstImplementsInterface*>(gobject_); }

private:


public:
  
  /** Test whether the given element implements a certain interface of type
   * iface_type, and test whether it is supported for this specific instance.
   * @param iface_type (final) type of the interface which we want to be implemented.
   * @return Whether or not the element implements the interface.
   */
  static bool element_implements(const Glib::RefPtr<const Gst::Element>&element, GType iface_type);

  /** Casts an element to an interface that its underlying GObject implements.
   * See Gst::ElementInterfaced for more details.
   */
  template <class T_CastTo>
    static Glib::RefPtr< Gst::ElementInterfaced<T_CastTo> >
    cast(const Glib::RefPtr<Gst::Element>& element);

  /** Virtual method to tell whether an interface is supported.
   */
    virtual bool supported_vfunc(GType iface_type) const;


  //For some reason, gmmproc thinks that all of the GstElement functions (and
  //signals) are also members of GstImplementsInterface.
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class T_CastTo>
Glib::RefPtr< Gst::ElementInterfaced<T_CastTo> > Interface::cast(const Glib::RefPtr<Gst::Element>& element)
{
  if(element && gst_element_implements_interface(Glib::unwrap(element), T_CastTo::get_type()))
  {
    void* result = gst_implements_interface_cast(Glib::unwrap(element),
      T_CastTo::get_type());

    Gst::ElementInterfaced<T_CastTo>* element_interfaced =
      new ElementInterfaced<T_CastTo>((GstElement*) result);

    return Glib::RefPtr< Gst::ElementInterfaced<T_CastTo> >(element_interfaced);
  }
  else
    return Glib::RefPtr< Gst::ElementInterfaced<T_CastTo> >(0);
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Interface
   */
  Glib::RefPtr<Gst::Interface> wrap(GstImplementsInterface* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_INTERFACE_H */

